/**
 * Copyright ShutheSL ( http://wonderfl.net/user/ShutheSL )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sJVz
 */

// forked from bongiovi015's Pixelate with perlin noise
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Shader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.ShaderFilter;
    import flash.geom.Point;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.utils.ByteArray;

    public class WonderPixelate extends Sprite
    {
        public var loaderImage : Loader = new Loader;
        public var loaderShader : URLLoader = new URLLoader;
        public var bmp : Bitmap;
        public var shader : Shader = new Shader;
        public var seed : int = Math.floor(Math.random()*0xFFFF);
        public var offset : Array = [new Point, new Point];
        public var bmpdPerlin : BitmapData;
    
        
        public function WonderPixelate(){
            graphics.beginFill(0, 1);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            loaderImage.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
            loaderImage.load(new URLRequest("http://www.raphazen.com/files/miyaichi.JPG"), new LoaderContext(true));
        }
        
        
        private function imgLoaded(e:Event) : void {
            bmp = Bitmap(loaderImage.content);
            addChild(bmp).y = ( 465 - bmp.height ) * .5;
            loaderShader.addEventListener(Event.COMPLETE, shaderLoaded);
            loaderShader.dataFormat = URLLoaderDataFormat.BINARY;
            loaderShader.load(new URLRequest("http://www.bongiovi.tw/wonderfl/PixelateWithMap.pbj"));
        }
        
        
        private function shaderLoaded(e:Event) : void {
            shader.byteCode = ByteArray(loaderShader.data);
            bmpdPerlin = new BitmapData(bmp.width*.5, bmp.height*.5);
            addEventListener(Event.ENTER_FRAME, render);
        }
        
        
        public function render(e:Event) : void {
            const SPEED : int = 2;
            bmpdPerlin.perlinNoise(bmp.width*.5, bmp.height*.5, 3, seed, false, true, 4, false, offset);
            offset[0].x += SPEED;
            offset[1].y += SPEED;
            shader.data.size.value = [stage.mouseX / stage.stageWidth * 15 + 10];
            shader.data.radius.value = [stage.mouseY / stage.stageHeight * 15 + 10];
            
            shader.data.srcPerlin.input = bmpdPerlin;
            bmp.filters = [new ShaderFilter(shader)];
        }
    }
}


/*

<languageVersion : 1.0;>

kernel PixelateWithMap
<   namespace : "bongiovi.tw";
    vendor : "bongiovi";
    version : 1;
    description : "Pixelate With Map";
>
{
    input image4 src;    
    input image4 srcPerlin;    
    output pixel4 dst;

    parameter float size
    <
        minValue:1.0;
        maxValue:1000.0;
        defaultValue:20.0;
    >;
    
    
    parameter float radius
    <
        minValue:0.0;
        maxValue:100.0;
        defaultValue:20.0;
    >;
    
    
    
    void
    evaluatePixel()
    {    
        float2 pos = outCoord();
        float2 center = floor(pos/size) * size + size * .5;
        float offsetPerlin = sampleLinear(srcPerlin, center*.5).b;
        float offset = step(radius*(offsetPerlin), distance(pos, center));
        dst = sampleLinear(src, center) * offset;
    }
}


*/
