/**
 * Copyright makc3d ( http://wonderfl.net/user/makc3d )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qzx3
 */

// move mouse horizontally :)
package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import alternativ7.engine3d.*;
    import alternativ7.engine3d.containers.*;
    import alternativ7.engine3d.core.*;
    import alternativ7.engine3d.materials.*;
    import alternativ7.engine3d.primitives.*;
    
    [SWF(backgroundColor="#000000", frameRate="60", width="465", height="465")]
    public class DemoForWonderfl extends Sprite {
        private static const CELL_NUM:uint = 6;
        
        public function DemoForWonderfl() {
            // swf init
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            // load
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
            loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/2/2c/2c60/2c60558d49b0335dea8992cfa894adc466d95358"), new LoaderContext(true));
        }
        private var camera:Camera3D;
        private var container:DistanceSortContainer;
        private var boxes:Array = [];
        private var wrap:DistanceSortContainer;
        
        private function completeHandler(e:Event):void {
            // Camera
            camera = new Camera3D();
            camera.view = new View(465, 465);
            addChild(camera.view);
            camera.x = 0;
            camera.y = 800;
            camera.z = 0;
            camera.fov = 45;
            camera.rotationX = -90 * Math.PI / 180;
            camera.rotationZ = 180 * Math.PI / 180;
            // Root object
            container = new DistanceSortContainer();
            container.sortByZ = true;
            wrap = new DistanceSortContainer();
            wrap.sortByZ = true;
            container.addChild(wrap);
            // Box
            var material:TextureMaterial = new TextureMaterial();
            material.texture = e.target.content.bitmapData;
            material.mipMapping = MipMapping.NONE;
            material.repeat = false;
            material.smooth = false;
            for (var i:int = 0; i < CELL_NUM; i++) {
                for (var j:int = 0; j < CELL_NUM; j++) {
                    for (var k:int = 0; k < CELL_NUM; k++) {
                        var box:Box = new Box(40, 40, 40, 1, 1, 1);
                        box.setMaterialToAllFaces(material);
                        box.sorting = Sorting.NONE;
                        box.x = 70 * (i - CELL_NUM / 2);
                        box.y = 70 * (j - CELL_NUM / 2);
                        box.z = 70 * (k - CELL_NUM / 2);
                        wrap.addChild(box);
                        this.boxes.push(box);
                    }
                }
            }
            // Adding
            container.addChild(camera);
            // Debug
            addChild(camera.diagram);
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(Event.RESIZE, resizeHandler);
            resizeHandler();
        }
        
        private function enterFrameHandler(e:Event = null):void {
            camera.fov = Math.PI * (mouseX + 1) / 400;
            camera.render(); // dirty hack to calculate focalLength :)
            camera.y = camera.alternativa3d::focalLength * 2;
            for (var i:int = 0; i < boxes.length; i++) {
                boxes[ i ].rotationX += 1 * Math.PI / 180;
                boxes[ i ].rotationY += 1 * Math.PI / 180;
            }
            wrap.rotationX += 1 * Math.PI / 180;
            wrap.rotationY += 1 * Math.PI / 180;
            camera.render();
        }
        
        private function resizeHandler(e:Event = null):void {
            camera.view.width = stage.stageWidth;
            camera.view.height = stage.stageHeight;
            graphics.clear();
            graphics.beginFill(0x0);
            graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
        }
    }
}