/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/qRLp
 */

package {
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.system.ApplicationDomain;
    import flash.system.LoaderContext;
    import com.actionscriptbible.Example;
    import net.wonderfl.utils.WonderflSWFUrl;
    
    [SWF(frameRate="120")]
    public class FlashTest extends Example {
        public const LibURL:String = WonderflSWFUrl.getURLFromPageURL("http://wonderfl.net/code/7f44a22e80d947a0aa79e1665165b57f37bfd521");
        public const ClassName:String = "Ball";
        public var Lib:Class;
        public var child:*;
        
        public function FlashTest() {
            trace("ステージをクリックしてください");
            //クリックしたら外部SWFを取得する
            stage.addEventListener(MouseEvent.CLICK, function click(event:MouseEvent):void{
                trace("click")
                stage.removeEventListener(MouseEvent.CLICK, click);
                stage.addEventListener(Event.ENTER_FRAME, enterFrame);
                imports();
            });

        }
        
        //外部SWFからクラスを取得する
        public function imports():void{
            //アプリケーションドメインの設定
            var appDomain:ApplicationDomain = ApplicationDomain.currentDomain;
            var loader:Loader = new Loader();
            //読み込み時にアプリケーションドメインを指定
            loader.load(new URLRequest(LibURL), new LoaderContext(true, appDomain));
            trace("読み込み中");
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function complete(event:Event):void{
                trace("complete");
                event.target.removeEventListener(Event.COMPLETE, complete);
                //アプリケーションドメインに指定したクラスがあるか
                if(appDomain.hasDefinition(ClassName)){
                    //取得したクラスをClass型変数に代入
                    Lib = appDomain.getDefinition(ClassName) as Class;
                    //取得したクラスで変数作成
                    child = addChild(new Lib(0xFF3344));
                    trace("外部SWFファイルから"+ClassName+"クラスをインポートしました");
                }
                else{
                    trace("外部SWFファイルには"+ClassName+"クラスは存在しません");
                }
            });
        }
        
        public function enterFrame(event:Event):void{
            if(!child) return;
            //取得したクラスのメソッドを呼ぶ
            child.spring((mouseX-child.x)/60, (mouseY-child.y)/60);
        }
    }
}