/**
 * Copyright Nyarineko ( http://wonderfl.net/user/Nyarineko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/prcA
 */

// forked from undo's 落ち着け・・・素数を数えて落ち着くんだ・・・
// forked from nitoyon's Enumerate Prime Numbers (227letters) (Sieve of Eratosthenes)
// inspired by http://twitter.com/javascripter/statuses/8367943818
package{
	import flash.text.*;
	import flash.display.*;
	import flash.events.*;
	import flash.net.*;
	import flash.utils.escapeMultiByte;
	
	public class C extends Sprite
	{
		private var defaultText:String = "\n落ち着け・・・素数を数えて落ち着くんだ・・・\n\n素数だと思ったら「落ち着く」ボタン またはキーボードの→キー\n素数じゃないと思ったら「落ち着かない」ボタン またはキーボードの←キー\n\nを押すんだ・・・";
		private var a:Array = [];
		private var i:int = 0;
		private var lastNum:int = 0;
		private var thisURL:String = " http://bit.ly/blMbVu %23wonderfl";
		
		private var tf:TextField;
		private var sbtn:Button;
		private var pbtn:Button;
		private var yes:Button;
		private var no:Button;
		
		private var startTime:uint;
		private var elapsed:uint;
		private var timeDisp:TextField;
		
		public function C()
		{
			for (var c:int = 1, d:int; c++<1E3; )
			{
				if (!a[c])
				{
					for (d=c; d<1E3; )
					{
						a[d+=c]=1;
					}
				}
			}
			timeDisp = new TextField();
			addChild(timeDisp);
			
			
		tf = new TextField();
		tf.autoSize = TextFieldAutoSize.CENTER;
		var tform:TextFormat = new TextFormat();
		tform.align = TextFormatAlign.CENTER;
		tf.defaultTextFormat = tform;
		tf.text = defaultText;
		addChild(tf);
		tf.x = stage.stageWidth/2 - tf.textWidth/2;
		tf.y = 100;
			
		sbtn = new Button("[spaceキー] ゲームスタート", 150);
		//sbtn.width = 150;
		sbtn.x = stage.stageWidth/2 - sbtn.width/2;
		sbtn.y = 200;
		sbtn.addEventListener(MouseEvent.CLICK, onClick);
		addChild(sbtn);
			
		pbtn = new Button("twitterにポスト", 100);
		pbtn.x = stage.stageWidth/2 - pbtn.width/2;
		pbtn.y = 250;
		pbtn.visible = false;
		pbtn.addEventListener(MouseEvent.CLICK, post);
		addChild(pbtn);
			
		yes = new Button("→落ち着く", 100);
		yes.x = stage.stageWidth/2 + 10;
		yes.y = 200;
		yes.addEventListener(MouseEvent.CLICK, onYes);
		addChild(yes);
			
		no = new Button("落ち着かない←", 100);
		no.x = stage.stageWidth/2 - no.width - 10;
		no.y = 200;
		no.addEventListener(MouseEvent.CLICK, onNo);
		addChild(no);
			
		yes.visible = false;
		no.visible = false;
			
		stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
		
				}
		
		private function onFrame(e:Event):void {
			var tmp:uint = (new Date()).time;
			elapsed = tmp - startTime;
		
			var ms:uint = elapsed;
		
			var div:uint = 1000 * 60 * 60;
			var hour:uint = ms / div;
			ms -= hour * div;
			div /= 60;
			var min:uint = ms / div;
			ms -= min * div;
			div /= 60;
			var sec:uint = ms / div;
			ms -= sec * div;
		
			var tx:String = hour.toString() + ":"
			if (min < 10) tx += "0";
			tx += min.toString() + "'";
			if (sec < 10) tx += "0";
			tx += sec.toString() + "'";
			if (ms < 100) tx += "0";
			tx += uint(ms / 10).toString();
		
			timeDisp.text = tx;
		}
				
				
		private function onClick(evt:MouseEvent):void
		{
			startGame();
			
			startTime = (new Date()).time;
			stage.addEventListener(Event.ENTER_FRAME, onFrame);
		}
			
		private function startGame():void
		{
			sbtn.visible = false;
			pbtn.visible = false;
			yes.visible = true;
			no.visible = true;
			
			lastNum = 0;
			
			tf.text = String(i);
		}
			
		private function onYes(evt:Event):void
		{
			check(true);
		}
			
		private function onNo(evt:Event):void
		{
			check(false);
		}
			
		private function onKeyDown(evt:KeyboardEvent):void
		{
			switch (evt.keyCode)
			{
				case 32 :
					if (sbtn.visible)
					{
						startGame();
					}
					break;
				case 39 :
					if (yes.visible)
					{
						check(true);
					}
					break;
				case 37 :
					if (no.visible)
					{
						check(false);
					}
					break;
				default :
					break;
			}
		}
			
		private function check(b:Boolean):void
		{
			if (i == 0 || i == 1)
			{
				if (b)
				{
					endGame();
					return;
				}
			}
			else
			{
				if (a[i] && b)
				{
					endGame();
					return;
				}
				else if (!a[i] && !b)
				{
					endGame();
					return;
				}
			}
			
			if(!a[i]) lastNum = i;
			i++;
			tf.text = String(i);
		}
			
		private function endGame():void
		{
			sbtn.visible = true;
			pbtn.visible = true;
			yes.visible = false;
			no.visible = false;
			stage.removeEventListener(Event.ENTER_FRAME, onFrame);
			
			if(lastNum == 0 || lastNum == 1) tf.text = "メメタァ\n\n最後に数えた素数：なし";
			else tf.text = "メメタァ\n\n最後に数えた素数："+lastNum;
			
			i = 0;
		}
			
		private function post(evt:MouseEvent):void
		{
			var st:String;
			if(lastNum== -1)
			{
				st = "http://twitter.com/home?status="+escapeMultiByte("素数を数えられませんでした。") + thisURL;
			}
			else
			{
				st = "http://twitter.com/home?status=" + lastNum + escapeMultiByte("まで素数を数えて落ち着きました。 time:") + timeDisp.text + thisURL;
			}
			navigateToURL(new URLRequest(st));
		}

	}
}

import flash.display.*;
import flash.text.*;
class Button extends SimpleButton
{

	public function Button(label:String, width:int = 0):void
	{
		var up:Sprite = _buildImage(label, 0x0, width);
		var over:Sprite = _buildImage(label, 0x333333, width);
		var down:Sprite = _buildImage(label, 0x333333, width);
		down.y = 1;
		super(up, over, down, up);
	}
	private static function _buildImage(label:String, color:int, width:int = 0):Sprite
	{
		var text:TextField = new TextField();
		text.defaultTextFormat = new TextFormat('Verdana', 10, 0xffffff, true, null, null, null, null, TextFormatAlign.CENTER);
		text.autoSize = TextFieldAutoSize.LEFT;
		text.selectable = false;
		text.text = label;
		text.x = (width - text.width) >> 1;
		text.y = 5;
		var base:Shape = new Shape();
		var g:Graphics = base.graphics;
		g.beginFill(color);
		g.drawRect(0, 0, width, text.height + 10);
		g.endFill();
		var sp:Sprite = new Sprite();
		sp.addChild(base);
		sp.addChild(text);
		return sp;
	}
}

