/**
 * Copyright yooyke ( http://wonderfl.net/user/yooyke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/omAh
 */

// forked from ProjectNya's PanLight
////////////////////////////////////////////////////////////////////////////////
// PanLight
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.media.SoundLoaderContext;
    import flash.geom.Rectangle;
    import flash.system.Security;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private static var domain:String = "www.project-nya.jp";
        private static var policyPath:String = "http://www.project-nya.jp/crossdomain.xml";
        private static var soundPath:String = "http://www.project-nya.jp/images/flash/robotwarrior.mp3";
        private var sound:Sound;
        private var channel:SoundChannel;
        private var soundTrans:SoundTransform;
        private var position:Number = 0;
        private var angle:Number = 0;
        private static var radian:Number = Math.PI/180;
        private var light:Light;
        private static var radius:uint = 200;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            Security.allowDomain(domain);
            Security.loadPolicyFile(policyPath);
            sound = new Sound();
            sound.addEventListener(Event.COMPLETE, initialize, false, 0, true);
            sound.load(new URLRequest(soundPath), new SoundLoaderContext(5, true));
            soundTrans = new SoundTransform();
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);
            light = new Light(rect);
            addChild(light);
        }
        private function initialize(evt:Event):void {
            evt.target.removeEventListener(Event.COMPLETE, initialize);
            channel = sound.play();
            channel.addEventListener(Event.SOUND_COMPLETE, complete, false, 0, true);
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function complete(evt:Event):void {
            channel = sound.play(0);
        }
        private function update(evt:Event):void {
            angle += 4;
            position = Math.sin(angle*radian);
            soundTrans.pan = position;
            channel.soundTransform = soundTrans;
            light.update(radius*position);
        }
        
    }

}


//////////////////////////////////////////////////
// Lightクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.geom.ColorTransform;
import flash.display.BlendMode;
import flash.filters.BlurFilter;
import frocessing.color.ColorHSV;

class Light extends Sprite {
    private var rect:Rectangle;
    private var cx:uint = 0;
    private var cy:uint = 0;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var light:Sprite;
    private var color:ColorHSV;
    private var colorTrans:ColorTransform;
    private static var blur:BlurFilter;
    private static var point:Point = new Point();
    private var id:uint = 0;

    public function Light(r:Rectangle) {
        rect = r;
        cx = rect.x + uint(rect.width/2);
        cy = rect.y + uint(rect.height/2);
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }
    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        light = new Sprite();
        light.x = cx;
        light.y = cy;
        light.graphics.beginFill(0xFFFFFF);
        light.graphics.drawCircle(0, 0, 10);
        light.graphics.endFill();
        color = new ColorHSV(0);
        colorTrans = new ColorTransform();
        blur = new BlurFilter(8, 8, 3);
    }
    public function update(px:Number):void {
        light.x = cx + px;
        color.h = id;
        colorTrans.color = color.value;
        var matrix:Matrix = new Matrix();
        matrix.translate(light.x, cy);
        bitmapData.lock();
        bitmapData.draw(light, matrix, colorTrans, BlendMode.SCREEN, null, true);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
        id ++;
    }

}
