/**
 * Copyright alexnotkin ( http://wonderfl.net/user/alexnotkin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/oRi7
 */

// forked from MR_WUT4's forked from: brick wave
// forked from MR_WUT4's brick wave
package 
{
    /**
     * @author David Ochmann
     */

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.utils.setTimeout;
    import flash.geom.ColorTransform;
    import net.hires.debug.Stats;
    
    public class BrickWave extends Sprite 
    {    
        private const WAVE_SPEED:Number = 2;

        private const AMPLITUDE:Number = .000006;
    
        private const BRICK_COLOR:uint = 0x000000;
        private const BRICK_WIDTH:uint  = 25;
        private const BRICK_HEIGHT:uint = BRICK_WIDTH;
        private const BRICK_DEPTH:uint  = 1;
        
        private var mGridWidth:uint   = 40;
        private var mGridHeight:uint  = 40;

        private var mContainer:Sprite;
        private var mGridList:Array;
        private var mListLength:uint;
        private var mBitmapData:BitmapData;
        private var mBitmap:Bitmap;
        private var mRectangle:Rectangle;
        private var mPoint:Point;
        private var mOffset:Array;
        private var mFirstBrick:Brick;
        private var mColorTransform:ColorTransform;
        
        private var mIntensity:Number;
        private var mColor:uint;
        private var mDepth:uint;
        private var mBrick:Brick;
        
        
        
        public function BrickWave()
        {
            setTimeout(initialize, 50);
        }
        
        
        
        private function initialize():void
        {
            initVariables();
            initGrid();
            initEnterFrame();
        }
        
        
        
        private function initVariables():void
        {
            mOffset = [new Point(0,0)];
            
            mGridList = new Array();
            
            mPoint = Point(mOffset[0]);
            mRectangle = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
            
            mColorTransform = new ColorTransform(1, 1, 1, 1, -80, -80, -80, 255);
                        
            mGridWidth  = Math.ceil(stage.stageWidth / BRICK_WIDTH);
            mGridHeight = Math.ceil(stage.stageHeight / BRICK_HEIGHT);
            
            mBitmapData = new BitmapData(BRICK_WIDTH * mGridWidth, BRICK_HEIGHT * mGridHeight, false, 0xFFFFFFFF);
            mBitmap = new Bitmap(mBitmapData, PixelSnapping.AUTO, false);
            
            mRectangle = new Rectangle(0, 0, BRICK_WIDTH * mGridWidth, BRICK_HEIGHT * mGridHeight);
            
            mContainer = new Sprite();            
            addChild(mContainer);
            
            
        }

        
        
        private function initGrid():void
        {
            var brick:Brick;
            
            for(var i:int = mGridWidth - 1; i > -1; --i)
            {                
                for(var j:int = 0; j < mGridHeight; ++j)
                {
                    brick = new Brick();
                    
                    brick.mWidth = BRICK_WIDTH;
                    brick.mHeight = BRICK_HEIGHT;
                    brick.mDepth = BRICK_DEPTH;
                    brick.mColor1 = BRICK_COLOR;
                    brick.mColor2 = BRICK_COLOR;
                                        
                    brick.x = i * BRICK_WIDTH;
                    brick.y = j * BRICK_HEIGHT;
                                        
                    mGridList.push(brick);
                    mContainer.addChild(brick);                    
                }
            }
            
            for(var k:int = mGridList.length - 1; k > -1; --k)
            {
                brick = Brick(mGridList[k]);
                brick.mNext = Brick(mGridList[k + 1]);
            }
            
            mFirstBrick = Brick(mGridList[0]);
            mListLength = mGridList.length;
        }

        
        
        private function initEnterFrame():void
        {
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }

        private function enterFrameHandler(e:Event):void
        {
            mPoint.x = mPoint.y -= WAVE_SPEED;
            
            mBitmapData.perlinNoise( 50, 100, 1, 2, true, true, 0, true, mOffset);
            mBitmapData.colorTransform(mRectangle, mColorTransform);
            
            mBrick = mFirstBrick;

            while(mBrick)
            {
                mColor = mBitmapData.getPixel(mBrick.x, mBrick.y);
                mIntensity = (mColor * AMPLITUDE);                
                mDepth = (mIntensity) < 0 ? 0 : mIntensity;
    
                mBrick.draw(mDepth, mColor);
                
                mBrick = mBrick.mNext;
            }
        }
    }
}

import flash.display.Shape;

final class Brick extends Shape
{
    public var mNext:Brick;
    public var mWidth:uint;
    public var mHeight:uint;
    public var mDepth:uint;
    public var mColor1:uint;
    public var mColor2:uint;
    public var mBorder:uint;

    
    public function Brick(){}


    public function draw(pDepth:uint = 5,
                         pColor:uint = 0xFFFFFF):void
    {        
        mDepth = pDepth;
    
        graphics.clear();
        graphics.beginFill(pColor);
        graphics.lineStyle(0, mBorder, 1, false);
        
        graphics.drawRect(pDepth, -pDepth, mWidth, mHeight);
        
        graphics.moveTo(pDepth           , -pDepth               );
        graphics.lineTo(pDepth           , -pDepth + mHeight);
        graphics.lineTo(0               , mHeight               );
        graphics.lineTo(0               , 0                 );
            
        graphics.endFill();
        graphics.beginFill(mColor2);
        
        graphics.moveTo(0               , mHeight               );
        graphics.lineTo(mWidth           , mHeight               );
        graphics.lineTo(mWidth + pDepth , -pDepth + mHeight);
        graphics.lineTo(pDepth           , -pDepth + mHeight);
        graphics.lineTo(0               , mHeight              );
        
        graphics.endFill();
    }
}