/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nsuH
 */

// forked from smirnov48's forked from: Happy new year!!
// forked from smirnov48's Happy new year!!
//Background don't captured in transparent mode
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;

    [SWF(frameRate="60",backgroundColor="0x114189")]
    public class Main extends Sprite 
    {
        private var emiter:Emiter;

        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            var bg:Sprite = new Sprite();
            bg.graphics.lineStyle(0);
            bg.graphics.beginFill(0x114189);
            bg.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            bg.graphics.endFill();
            addChild(bg);

            var star: Star = new Star();
            star.x = stage.stageWidth / 2;
            star.y = 30;
            addChild(star);
            emiter = new Emiter(Star);
            emiter.x = stage.stageWidth / 2;
            emiter.y = 55;
            addChild(emiter);
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function onClick(e:MouseEvent):void 
        {
            emiter.turn();
        }
    }
}

import flash.display.Sprite;
import flash.events.Event;
import flash.utils.getTimer;

internal class Emiter extends Sprite
{
    private const PARTICLES_PER_SECOND:int = 100;
    private const MAX_PARTICLES:int = 500;
    private var particle:Class;
    private var particles:Array = new Array();
    private var time:uint = getTimer();
    private var blink:Boolean = false;

    public function Emiter(particle:Class)
    {
        this.particle = particle;
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    public function turn():void 
    {
        blink = !blink;
    }

    private function onEnterFrame(e:Event):void 
    {
        crateNewParticles();
        updateParticles();
        checkAndRemoveParticles();
    }

    private function updateParticles():void 
    {
        for (var i:int = 0; i < particles.length; i++) {
            var part:Star = particles[i] as Star;
            if (blink) { 
                part.alpha += part.va;
                if (part.alpha >= 1 || part.alpha <= 0) { 
                    part.va = -part.va;
                    part.alpha += part.va;
                }
            } else {
                part.x += part.vx;
                part.y += part.vy;
                part.rotation += part.vr;
            }
        }
    }

    private function crateNewParticles():void 
    {
        if (particles.length > MAX_PARTICLES) {
            return;
        }

        var newTime:uint = getTimer();
        var delta:int = newTime - time;
        time = newTime;

        var countToCreate:int = Math.ceil(delta / 1000 * PARTICLES_PER_SECOND);
        for (var i:int = 0; i < countToCreate; i++) {
            var part:Star = (new particle()) as Star;
            resetSpeedAndSize(part);
            part.alpha = Math.random();
            addChild(part);
            particles.push(part);
        }
    }

    private function resetSpeedAndSize(part:Star):void 
    {
        part.scaleX = part.scaleY = Math.random() * 0.5;
        part.va = part.scaleX  * 0.05 + 0.002;
        part.vr = Math.random() * 2 - 1;
        part.vx = Math.random() * 1.2 - 0.6;
        part.vy = Math.random() * 2 + 1;
    }

    private function checkAndRemoveParticles():void 
    {
        for (var i:int = 0; i < particles.length; i++) {
            var part:Star = particles[i] as Star;
            if (part.y > stage.stageHeight + 30) {
                part.x = 0;
                part.y = 0;
                resetSpeedAndSize(part);
            }
        }
    }
}

internal class Star extends Sprite
{
    public var va:Number = 0;
    public var vr:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;

    public function Star()
    {
        graphics.beginFill(0xFFF123, alpha);
        graphics.lineStyle(0, 0xFFF123, alpha/10);
        graphics.moveTo( 0, -17);
        graphics.lineTo( 8, -7);
        graphics.lineTo( 18, -4);
        graphics.lineTo( 10, 5);
        graphics.lineTo( 10, 16);
        graphics.lineTo( 0, 12);
        graphics.lineTo( -11, 16);
        graphics.lineTo( -11, 4);
        graphics.lineTo( -18, -4);
        graphics.lineTo( -8, -7);
        graphics.lineTo( 0, -17);
        graphics.endFill();
    }
}