/**
 * Copyright Test_Dept ( http://wonderfl.net/user/Test_Dept )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/njVV
 */

package {
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	/**
	 * Aperture
	 * @author Test Dept
	 */
	[SWF(backgroundColor="#ffffff", width="465", height="465")]
	public class Aperture extends Sprite {

		public function Aperture() {
			addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
		}

		private function addedToStageHandler(event : Event) : void {
			
			var w : Number = stage.stageWidth;
			var h : Number = stage.stageHeight;

			var ap : ApertureImpl = new ApertureImpl(w / 2, h / 2, h / 3, 5);
			ap.angle = 0.5;
			addChild(ap);

			stage.addEventListener(MouseEvent.MOUSE_MOVE, function(event : Event) : void {
				ap.angle = 1 - Math.abs( (mouseY - h / 2) / (h / 3) );
			} );
		}
	}
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.events.Event;
import flash.display.GradientType;

class ApertureImpl extends Sprite {

	private var _x : Number;
	private var _y : Number;
	private var _r : Number;

	private var _angle : Number;

	private var _rot : Matrix;

	public function ApertureImpl(
		x : Number, y : Number, r : Number, numPlates : int
	) {
		
		_x = x;
		_y = y;
		_r = r;
		
		_angle = 0;
		
		_rot = new Matrix();
		_rot.rotate(2 * Math.PI / numPlates);

		mask = new Sprite();

		for (var i : int = 0; i < numPlates; i++) {
			var plate : Sprite = new Sprite();
			plate.mask = new Sprite();
			addChild(plate);
		}

		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
	}
	
	public function get angle() : Number { 
		return _angle;
	}

	public function set angle(value : Number) : void {
		value = Math.max(0, Math.min(value, 1) );
		_angle = value;
	}
	
	private function enterFrameHandler(event : Event) : void {

		var colors : Array = [
			0xff0000,
			0xff9900,
			0xffff00,
			0x00ff00,
			0x0000ff
		];

		var t : Number = Math.PI / 3 * _angle;

		var o : Point = new Point(_x, _y);
		var oa : Point = new Point(0, -_r);

		var g : Graphics;

		g = graphics;
		g.clear();
		g.lineStyle(1, 0x666666);
		g.drawCircle(o.x, o.y, _r);

		var mask : Sprite = this.mask as Sprite;
		g = mask.graphics;
		g.clear();
		g.beginFill(0);
		g.drawCircle(o.x, o.y, _r);
		g.endFill();
		
		for (var i : int = 0; i < numChildren; i++) {			
//			var color : uint = colors[i % colors.length];
			var color : uint = 0x333333;
			var plate : Sprite = getChildAt(i) as Sprite;
			drawPlate(plate, o, oa, _r, t, color);
			oa = _rot.transformPoint(oa);
		}
	}
	
	private function drawPlate(
		plate : Sprite,
		o : Point,
		oa : Point,
		r : Number,
		t : Number,
		color : uint
	) : void {

		var ab : Point = new Point(-oa.x, -oa.y);

		var mat : Matrix = new Matrix();
		mat.rotate(t);
		
		ab = mat.transformPoint(ab);

		var a : Point = o.add(oa);
		var b : Point = a.add(ab);

		var g : Graphics;

		// plate

		g = plate.graphics;
		g.clear();
		g.lineStyle(1, color);
		g.beginGradientFill(GradientType.RADIAL,
			[color, 0xffffff], [1, 1], [0, 255],
			new Matrix(r / 500, 0, 0, r / 500, a.x, a.y) );
		g.drawCircle(a.x, a.y, r * 2);
		g.drawCircle(b.x, b.y, r);
		g.endFill();

		// mask

		var oc : Point = _rot.transformPoint(b.subtract(o) );
		var c : Point = o.add(oc);

		var mask : Sprite = plate.mask as Sprite;
		g = mask.graphics;
		g.clear();
		g.beginFill(0);
		g.drawCircle(c.x, c.y, r);
		g.endFill();
	}
}
