/**
 * Copyright h_ike ( http://wonderfl.net/user/h_ike )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nWLN
 */

package {
	import flash.display.*;
	import flash.events.*;
	
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.cameras.*;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.special.Letter3DMaterial;
	import org.papervision3d.typography.Text3D;
	import org.papervision3d.typography.fonts.*;
	
	import caurina.transitions.*;
	import caurina.transitions.properties.*;
	
	public class Main extends Sprite {
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var viewport:Viewport3D;
		private var renderer:BasicRenderEngine;
		private var text3D:Text3D;

		private var stageW:Number;
		private var stageH:Number;
		private var vpX:Number;
		private var vpY:Number;
		private var textString:String = "PV3D Typography";
		
		public function Main() {
			init();
		}
		private function init():void {
			CurveModifiers.init();
			setStage();
			setScene();
			setCamera();
			setDO3D();
			setText3D();
			
			addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
		}
		private function setStage():void {
			stage.quality = StageQuality.MEDIUM;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			stageW = stage.stageWidth;
			stageH = stage.stageHeight;
			vpX = stageW / 2;
			vpY = stageH / 2;
		}
		private function setScene():void {
			renderer = new BasicRenderEngine();
			scene = new Scene3D();
			viewport = new Viewport3D(0, 0, true, true);
			addChild(viewport);
		}
		private function setCamera():void {
			camera = new Camera3D();
			camera.x = 0;
			camera.y = 0;
			camera.z = -500;
			camera.zoom = 30;
			camera.focus = 30;
			camera.target = DisplayObject3D.ZERO;
		}
		private function setDO3D():void {
			var material:WireframeMaterial = new WireframeMaterial(0x777777, 0.5);
			material.oneSide = false;
			var plane:Plane = new Plane(material, 5000, 5000, 8, 8);
			plane.rotationX = 90;
			plane.y = -200;
			scene.addChild(plane);
		}
		private function setText3D():void {
			var material:Letter3DMaterial = new Letter3DMaterial(0x333333, 1);
			material.oneSide = false;
			text3D = new Text3D(textString, new HelveticaLight(), material);
			text3D.x = 0;
			text3D.y = 100;
			text3D.z = 500;
			text3D.scale = 1;
			scene.addChild(text3D);
		}
		private function onEnterFrameHandler(e:Event) :void {
			var angleX:Number = (mouseX - vpX) * 0.0001;
			var angleY:Number = (mouseY -vpY) * 0.0001;
			moveCameraX(angleX);
			moveCameraY(angleY);
			doMotionDO3D();
			renderer.renderScene(scene, camera, viewport);
		}
		private function doMotionDO3D():void {
			var cycle:Number = 3;
			var msec:Number = new Date().getTime();
			
			for (var i:int = 0; i < textString.length;i++ ) {
				var letter:DisplayObject3D = text3D.letters[i];
				letter.rotationX = 45 * Math.cos(i % 6) * Math.sin(msec / 1000 * Math.PI * 2 / cycle);
				letter.y = 90 * Math.cos(i % 6) * Math.sin(msec / 1000 * Math.PI * 2 / cycle);
			}
		}
		private function moveCameraX(angleX:Number):void {
			camera.x = camera.x * Math.cos(angleX) - camera.z * Math.sin(angleX);
		}
		private function moveCameraY(angleY:Number):void {
			camera.y = camera.y * Math.cos(angleY) - camera.z * Math.sin(angleY);
		}
	}
}