/**
 * Copyright hig_an ( http://wonderfl.net/user/hig_an )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/nBnH
 */

package {
	import flash.events.*;
	import flash.utils.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.materials.special.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.typography.fonts.*;
	import org.papervision3d.typography.*;
	import org.papervision3d.view.*;
	
	public class Numwalk extends BasicView {
		private var word:Text3D;
		private var num:int = 28;
		
		private var maxNum:int = 30;
		private var roRate:int = 2;
		private var adRate:int = 10;
		private var letScale:int = 4;
		
		private var strNum:String;
		private var roSpeed:Number;
		private var adSpeed:Number;
		

		public function Numwalk():void {
			var wireMat:WireframeMaterial = new WireframeMaterial(0x00ff00);
			var floor:Plane = new Plane(wireMat, 5000, 5000, 10, 10);
			scene.addChild(floor);
			floor.pitch(90);
			floor.y = -300;
			
			strNum = String(num);
			var letterMat:Letter3DMaterial = new Letter3DMaterial(0x0066cc );
			var font:HelveticaBold = new HelveticaBold();
			letterMat.doubleSided = true;
			word = new Text3D(strNum, font, letterMat);
			
			scene.addChild(word);
			
			camera.y = 600;
			camera.x = -1000;
			camera.z = 0;
			camera.target = word;
			
			init();
			
			startRendering();
			addEventListener(Event.ENTER_FRAME, loop);
		}
		private function init():void {
			word.z = 2500;
			word.scaleX = word.scaleY = letScale;
			roSpeed = num * roRate;
			adSpeed = num * adRate;
		}
		private function reset():void {
			num = Math.ceil(Math.random() * maxNum);
			strNum = String(num);
			word.text = strNum;
			
			init();
		}
		private function loop(e:Event):void {
			word.z -= adSpeed;
			word.rotationY += roSpeed;
			if (word.z <= -2500) {
				reset();
			}
		}
	}
}