/**
 * Copyright _ueueueueue ( http://wonderfl.net/user/_ueueueueue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mki6
 */

package 
{
	/**
	 * RBG ←→ HSV　の変換
	 * 
	 * TODO : HSVへの変換するところは、Mathクラスを使わないで実装したい
	 * TODO : 色相の取得のとこの例外処理ミスってる気がする
	 * 
	 * 参考
	 * http://ja.wikipedia.org/wiki/HSV%E8%89%B2%E7%A9%BA%E9%96%93
	 * http://image-d.isp.jp/commentary/color_cformula/HSV.html
	 * 
	 */
	import com.bit101.components.ColorChooser;
	import com.bit101.components.Label;
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.text.*;
	import flash.ui.*;
	
	[SWF(width=465,height=465,backgroundColor=0xdddddd)]
	
	/**
	 * ...
	 * @author ue
	 */
	
	public class Main extends Sprite 
	{
		private var container:Sprite;
		private var color:uint;
		private var label1:Label;
		private var label2:Label;
		private var label3:Label;
		private var label4:Label;
		private var label5:Label;
		private var label6:Label;
		private var colorChooser:ColorChooser;
		
		public function Main():void 
		{
			container = new Sprite();
			container.graphics.beginFill(0xffffff);
			container.graphics.drawRect(0, 0, 445, 445);
			container.graphics.endFill();
			container.x = 10; container.y = 10;
			addChild(container);
			
			colorChooser = new ColorChooser(container, 20, 20, 0xff0000, selectColor);
			label1 = new Label(container, 20, 45, "H:");
			label2 = new Label(container, 20, 60, "S:");
			label3 = new Label(container, 20, 75, "V:");
			label4 = new Label(container, 20, 100, "R:");
			label5 = new Label(container, 20, 115, "G:");
			label6 = new Label(container, 20, 130, "B:");
		}
		
		private function selectColor(e:Event):void
		{
			var hsv:HSVColor = toHSV(colorChooser.value);
			label1.text = "H:" + hsv.h;
			label2.text = "S:" + hsv.s;
			label3.text = "V:" + hsv.v;
			label4.text = "R:" + (toRGB(hsv) >> 16 & 0xff);
			label5.text = "G:" + (toRGB(hsv) >> 8 & 0xff);
			label6.text = "B:" + (toRGB(hsv) >> 0 & 0xff);
		}
		
		private function toHSV(color:uint):HSVColor
		{
			var r:Number = (color >> 16 & 0xff);
			var g:Number = (color >> 8 & 0xff);
			var b:Number = (color >> 0 & 0xff);
			
			var max:Number = Math.max(r, g, b);
			var min:Number = Math.min(r, g, b);
			
			var v:Number = max / 255;
			if (v == 0)
			{
				var h:Number = 0;
				var s:Number = 0;
			}
			else
			{
				var def:Number = max - min;
				var cr:Number = (max - r) / def;
				var cg:Number = (max - g) / def;
				var cb:Number = (max - b) / def;
				if(max==r)
				{
					h = cb - cg;
				}
				else if(max==g)
				{
					h = 2 + cr - cb;
				}
				else if(max==b)
				{
					h = 4 + cg - cr;
				}
				h *= 60;
				if (h < 0) h += 360;
				s = def / max;
			}
			
			return new HSVColor(h, s, v);
		}
		
		private function toRGB(color:HSVColor):uint
		{
			//彩度sが0の場合はr,g,bは明度vと等しい
			if (color.s == 0) return (color.v * 255) << 16 | (color.v * 255) << 8 | (color.v * 255);
			
			var i:int = int(color.h / 60);
			var f:Number = color.h / 60 - i;
			var p:Number = color.v * (1 - color.s);
			var q:Number = color.v * (1 - color.s * f);
			var t:Number = color.v * (1 - color.s * (1 - f));
			
			switch(i){
				case 0:
					return (color.v *255) << 16 | t * 255 << 8 | q * 255;
					break;
				case 1:
					return  q * 255 << 16 | (color.v * 255) << 8 | p * 255;
					break;
				case 2:
					return  p * 255 << 16 | (color.v * 255) << 8 | t * 255;
					break;
				case 3:
					return  p * 255 << 16 | q * 255 << 8 | (color.v * 255);
					break;
				case 4:
					return  t * 255 << 16 | p * 255 << 8 | (color.v * 255);
					break;
				case 5:
					return  (color.v * 255) << 16 | p * 255 << 8 | q * 255;
					break;
				default:
					break;
			}
			return 0;
		}
	}
}

class HSVColor
{
	private var _h:Number
	private var _s:Number
	private var _v:Number
	
	public function HSVColor(h:Number, s:Number, v:Number )
	{
		_h = h;
		_s = s;
		_v = v;
	}
	
	//色相
	public function get h():Number { return _h; }
	public function set h(value:Number):void 
	{
		_h = value;
	}
	//彩度
	public function get s():Number { return _s; }
	public function set s(value:Number):void 
	{
		_s = value;
	}
	//明度
	public function get v():Number { return _v; }
	public function set v(value:Number):void 
	{
		_v = value;
	}
}

