/**
 * Copyright skyboy ( http://wonderfl.net/user/skyboy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mabh
 */

package {
    import flash.display.*
    import flash.events.*;
    import flash.geom.*
    import flash.globalization.*;
    import flash.media.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.*;
    import flash.utils.*;
    [SWF(width='465', height='465', backgroundColor='#333333', frameRate='60')]
    public class FlashTest extends Sprite {
        public static const WIDTH:Number = 465;
        public static const HEIGHT:Number = 465;
        public static const hw:Number = WIDTH / 2;
        public static const hy:Number = HEIGHT / 2;
        private var logger:TextField;
        private var bytes:ByteArray;
        private const file:FileReference = new FileReference();
        private function log(...args):void {
            logger.appendText(args.join(" ") + "\n");
            logger.scrollV = logger.numLines;
        }
        private function saveFile(e:MouseEvent):void {
            try {
                var a:String;
                try {
                    a = file.name;
                } catch (b:*) {
                    a = "file.swf";
                }
                bytes = loaderInfo.bytes;
                file.save(bytes, a);
            } catch (er:Error) {
                //log(e)
            }
            e.stopImmediatePropagation();
            e.stopPropagation();
            e.preventDefault();
        }
        public function FlashTest() {
            graphics.beginFill(0xEEEEEE);
            graphics.drawRoundRect(0, 0, WIDTH, HEIGHT, 30);
            graphics.endFill();
            logger = new TextField();
            logger.autoSize = TextFieldAutoSize.LEFT;
            logger.defaultTextFormat = new TextFormat("Monaco");
            addChild(logger);
            var b:Sprite = new Sprite;
            var c:Graphics = b.graphics;
            c.beginFill(0x666666);
            c.drawRoundRect(0, 0, 100, 50, 30);
            c.endFill();
            (b.addChild(new TextField) as TextField).appendText("Save");
            var a:SimpleButton = new SimpleButton(b, b, b, b);
            addChild(a).x = WIDTH - 100;
            a.y = HEIGHT - 50;
            a.addEventListener(MouseEvent.CLICK, saveFile);
            if (stage) onAS(null); else addEventListener(Event.ADDED_TO_STAGE, onAS);
        }
        private function onAS(evt:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, onAS);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP;
            log("                                     Click to test.");
            addEventListener(MouseEvent.CLICK, onCC);
        }
        private var test:Test = new Test;
        private function onCC(e:Event):void {
            addChild(test);
            test.runTest(109000001);
        }
    }
}
import flash.display.*;
import flash.system.*;
import flash.text.*;
import flash.utils.*;
internal class Test extends Sprite {
    private var logger:TextField = new TextField();
    public function Test():void {
        logger.y = 20;
        logger.autoSize = TextFieldAutoSize.LEFT;
        logger.defaultTextFormat = new TextFormat("Monaco");
        addChild(logger);
    }
    private function logTest(name:String, time:int, other:int):void {
        logger.appendText(name + ": " + time + " ms; " + other + '\n');
    }
    private function setVersionString():void {
            logger.text = "  ";
            //logger.appendText((Capabilities.supports64BitProcesses ? "64" : Capabilities.supports32BitProcesses ? "32" : "16") + " bit ");
            logger.appendText(Capabilities.os + " ");
            logger.appendText(Capabilities.cpuArchitecture + " ");
            logger.appendText(Capabilities.version.split(",").join(".").split(" ")[1] + " ");
            logger.appendText(Capabilities.isDebugger ? "Debug " : "Release ");
            logger.appendText(Capabilities.playerType);
            logger.appendText("\n");
        }
    public function runTest(tests:int):void {
        setVersionString();
        var i:int = tests, t:int, before:int, after:int;
        var head:Node = new Node, n:Node = head;
        var item:Vector.<int> = new Vector.<int>(tests);
        i = 1e6;
        while (i--) n = n.next = new Node;
        n.next = head;
        i = 0;
        before = getTimer();
        while (i < tests) {
            t &= item[i], ++i;
        }
        after = getTimer();
        logTest("Vector, normal", after - before, t);
        i = 0;
        before = getTimer();
        while((tests - i) % 4) t &= item[i], ++i;
        while (i < tests) {
            t &= item[i], ++i;
            t &= item[i], ++i;
            t &= item[i], ++i;
            t &= item[i], ++i;
        }
        after = getTimer();
        logTest("Vector, Duff", after - before, t);
        before = getTimer();
        n = head;
        i = 0;
        while(i++ < tests) n = n.next, t &= n.data;
        after = getTimer();
        logTest("LinkedList", after - before, t);
        i = 0;
        before = getTimer();
        n = head;
        while((tests - i) % 4) n = n.next, t &= n.data, ++i;
        while (i < tests) {
            n = n.next;
            t &= n.data;
            n = n.next;
            t &= n.data;
            n = n.next; 
            t &= n.data;
            n = n.next;
            t &= n.data;
            i += 4;
        }
        after = getTimer();
        logTest("LinkedList, Duff", after - before, t);
    }
}
internal class Node {
    public var next:Node;
    public var data:int;
}


