/**
 * Copyright atsumo ( http://wonderfl.net/user/atsumo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/mWpi
 */

// forked from atsumo's setterについて
/**
* setterがより
*/
package {
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    
    [SWF(width="465", height="465", backgroundColor="#000000")]
    public class FlashTest extends Sprite {
        
        public function FlashTest() {
            // write as3 code here..
            initialize();
        }
        
        private function initialize():void
        {
            for(var i:int = 0; i < 60; i++)
            {
                var ball:Ball = new Ball(uint(0xFFFFFF*Math.random()), 30);
                ball.x = stage.stageWidth*Math.random();
                ball.y = stage.stageHeight*Math.random();
                ball.addEventListener(MouseEvent.ROLL_OVER, handleRollOver);
                ball.addEventListener(MouseEvent.ROLL_OUT, handleRollOut);
                ball.addEventListener(MouseEvent.CLICK, handleClick);
                ball.buttonMode = true;
                addChild(ball);
            }
        }
        
        private function handleRollOver(e:MouseEvent):void
        {
            var ball:Ball = e.target as Ball;
            ball.scale = 1.5;
        }
        
        private function handleRollOut(e:MouseEvent):void
        {
            var ball:Ball = e.target as Ball;
            ball.scale = 1;
        }
        
        private function handleClick(e:MouseEvent):void
        {
            var ball:Ball = e.target as Ball;
            //ball
            ball.changeColor = uint(Math.random()*0xFFFFFF);
        }
    }
}
import flash.filters.GlowFilter;
import flash.display.Graphics;
import flash.display.Sprite;

import caurina.transitions.*;
import caurina.transitions.properties.*;

class Ball extends Sprite
{
    private var _color:uint;
    private var _radius:int;
    
    public function Ball(color:uint = 0x0, radius:int = 50)
    {
        ColorShortcuts.init();
        _color = color;
        _radius = radius;
        
        draw();
        
        var glow:GlowFilter = new GlowFilter(0xffffff, .5, 10, 10, 1);
        this.blendMode = "add";
        this.filters = [glow];
    }
    
    private function draw():void
    {
        var g:Graphics = this.graphics;
        g.clear();
        g.beginFill(_color);
        g.drawCircle(0,0, _radius);
        g.endFill();
    }
    
    public function set changeColor(value:int):void
    {
        Tweener.addTween(this, {_color:value, time:3, transition:"easeoutelastic"});
    }

    
    public function set color(value:uint):void
    {
        _color = value;
        draw();
    }
    
    public function set radius(value:int):void
    {
        _radius = value;
        draw();
    }
    
    public function set scale(value:Number):void
    {
        trace(value);
        Tweener.addTween(this, {scaleX:value, scaleY:value, time:3,  transition:"easeoutelastic"});
    }

}
