/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lnc4
 */

// forked from shaktool's forked from: flash on 2013-11-26
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	[SWF(width=465, height=465, frameRate=30, backgroundColor=0x000000)]
	public class FlashTest extends Sprite
	{
		private var foreground: Graphics;
		public function FlashTest()
		{
			var sprite: Sprite;
			
			sprite = new Sprite();
			addChild( sprite );
			var background: Graphics = sprite.graphics;
			background.beginFill( 0x000000 );
			background.drawRect( 0, 0, WIDTH, HEIGHT );
			background.endFill();
			
			sprite = new Sprite();
			addChild( sprite );
			foreground = sprite.graphics;
			
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame( event: Event = null ): void
		{
			foreground.clear();
			
			var dt: Number = 0.033333;
			var k: Number = 8.0;
			var speed: Number = k;
			var pos: Number = 100.0;
			var velocity: Number = 0.0;
			var cur: Number = 100.0;
			var prev: Number = 100.0;
			var target: Number = 400.0;
			
			foreground.lineStyle( 2, 0x0000ff );
			foreground.moveTo( 0.0, 250.0 );
			for ( var i: int = 1; i < 100; i++ )
			{
				foreground.lineTo( i * 5.0, 250.0 + 50 * Math.sin( i * 0.1 ) );
			}
			
			foreground.lineStyle( 2, 0xff0000 );
			foreground.moveTo( 0.0, pos );
			for ( var i: int = 1; i < 100; i++ )
			{
				target = 250.0 + 50 * Math.sin( i * 0.1 );
				var springForce: Number = ( target - pos ) * speed * speed;
				var dampingForce: Number = -velocity * 2.0 * speed;
				velocity += ( springForce + dampingForce ) * dt;
				pos += velocity * dt;
				foreground.lineTo( i * 5.0, pos );
			}
			
			foreground.lineStyle( 2, 0x00ff00 );
			foreground.moveTo( 0.0, cur );
			for ( var i: int = 1; i < 100; i++ )
			{
				target = 250.0 + 50 * Math.sin( i * 0.1 );
				var vel: Number = ( cur - prev ) / dt;
				var springForce: Number = ( target - cur ) * speed * speed;
				var newVel: Number = ( vel + springForce * dt ) / ( (1.0 + k * dt) * (1.0 + k * dt) );
				prev = cur;
				cur += newVel * dt;
				foreground.lineTo( i * 5.0, cur );
			}
			
			foreground.lineStyle();
		}
	/*
	inline void CriticallyDampedSpring( T& pos, T& velocity, const T& target, float speed, float dt )
	{
	}
	
	T CriticallyDampedSpring( float dt, float k, const T& cur, const T& prev, const T& target )
	{
	}*/
	}
}

const WIDTH: int = 465;
const HEIGHT: int = 465;

function add( a: Vector.<Number>, b: Vector.<Number> ): Vector.<Number> { return new <Number>[ a[ 0 ] + b[ 0 ], a[ 1 ] + b[ 1 ] ]; }
function subtract( a: Vector.<Number>, b: Vector.<Number> ): Vector.<Number> { return new <Number>[ a[ 0 ] - b[ 0 ], a[ 1 ] - b[ 1 ] ]; }
function multiply( a: Vector.<Number>, b: Number ): Vector.<Number> { return new <Number>[ a[ 0 ] * b, a[ 1 ] * b ]; }
function vecLength( a: Vector.<Number> ): Number { return Math.sqrt( a[ 0 ] * a[ 0 ] + a[ 1 ] * a[ 1 ] ); }
function dot( a: Vector.<Number>, b: Vector.<Number> ): Number { return a[ 0 ] * b[ 0 ] + a[ 1 ] * b[ 1 ]; }
function SafeNormalize( a: Vector.<Number> ): Vector.<Number> { var len: Number = vecLength( a ); return len == 0.0 ? new <Number>[ 0.0, 0.0 ] : new <Number>[ a[ 0 ] / len, a[ 1 ] / len ]; }