/**
 * Copyright hacker_iqf76yye ( http://wonderfl.net/user/hacker_iqf76yye )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ljnA
 */

// forked from alumican_net's [Prototyping] Microphone Study #04 逆再生
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.SampleDataEvent;
    import flash.geom.Point;
    import flash.media.Microphone;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.utils.ByteArray;
    import flash.utils.getTimer;
    import flash.display.Loader;
    import flash.net.URLRequest;
    
    public class Main extends Sprite
    {
        private const ZEROS:Point = new Point();

        private var _mic:Microphone;
        private var _records:Vector.<Number>;
        
        private var url:URLRequest;
        private var InSound:Sound;
        private var OutSound:Sound;
        private var _soundChannel:SoundChannel;

        private var _position:int;
        
        public function Main():void
        {
            _mic = Microphone.getMicrophone();
            _mic.rate = 44;
            _mic.setSilenceLevel(0);
            _mic.setUseEchoSuppression(true);
            url = new URLRequest("tamo.mp3");
            InSound = new Sound(url);
            OutSound = new Sound();            
            _startRecord();
        }
        
        /**
         * 録音開始
         */
        private function _startRecord():void
        {
            trace("_startRecord");
            _position = 0;
            _records = new Vector.<Number>(44100 * 1);
            _mic.addEventListener(SampleDataEvent.SAMPLE_DATA, _micSampleDataHandler);
        }
        
        private function _micSampleDataHandler(e:SampleDataEvent):void
        {
            var datas:ByteArray = e.data;
            while(datas.bytesAvailable)
            {
                var data:Number = _records[_position] = datas.readFloat();
                _position +=1;
                if (_position == _records.length)
                {
                    _mic.removeEventListener(SampleDataEvent.SAMPLE_DATA, _micSampleDataHandler);
                    _startSound();
                    return;
                }
            }
        }
        
        /**
         * 再生開始
         */
        private function _startSound():void
        {            
            //波形データをひっくり返す
            _records = _records.reverse();
            
            _position = 0;
            OutSound.addEventListener(SampleDataEvent.SAMPLE_DATA, _soundSampleDataHandler);
            _soundChannel = OutSound.play();
        }
        
        private function _soundSampleDataHandler(e:SampleDataEvent):void
        {
            for (var i:int = 0; i < 2048; ++i)
            {
                var PickedData:Number = _records[_position];
                e.data.writeFloat(PickedData);
                e.data.writeFloat(PickedData);
                _position = _position + 1;
                
                if (_position == _records.length)
                {
                    OutSound.removeEventListener(SampleDataEvent.SAMPLE_DATA, _soundSampleDataHandler);
                    _startRecord();
                    return;
                }
            }
        }
    }
}