/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/lIbV
 */

package {
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
  
    public class FlashTest extends Sprite {
        public function FlashTest() {
             resetMap();
      
      
          stage.addEventListener(Event.ENTER_FRAME, onEnter);
          stage.addEventListener(MouseEvent.MOUSE_DOWN, mdown);
          stage.addEventListener(MouseEvent.MOUSE_UP, mup);
        }//ctor
        
        public var gameTime:int = 0;
        public var bMdown:Boolean = false;
         
        public function mdown(e:MouseEvent):void { bMdown = true; resetMap(); }
        public function mup(e:MouseEvent):void { bMdown = false; }
        
        public var cx:Number = 225;    public var cy:Number = 225;
        public var ang:Number = 0;
        
        public var vx:Number = 0;    public var vy:Number = 0;
        
        public var vecRect:Vector.<xRect> = new Vector.<xRect>(0, false);
         
        public function resetMap():void
        {
          vecRect = new Vector.<xRect>(0, false);    
          var a:xRect;      var i:int;
          for (i = 0; i < 16; i++)
          {
            a = new xRect();
            a.cx =-128+ Math.random() * 450; a.cy =-128+ Math.random() * 450;
            a.cw = Math.random() * 128 + 8; a.ch = Math.random() * 128 + 8;
            vecRect.push(a);
          }//nexti
        }//resetmap  
    
        public function drawRect():void
        {
          var i:int;      var num:int;      var a:xRect;
          num = vecRect.length;
          for (i = 0; i < num; i++)
          {
            a = vecRect[i];
            graphics.beginFill(0, 0.5);
              graphics.drawRect(a.cx, a.cy, a.cw, a.ch);
            graphics.endFill();
          }//nexti
        }//drawrect
        
    public function isWall2(ax:Number, ay:Number, aw:Number, ah:Number):Boolean
    {
      var i:int;      var num:int;      var a:xRect;
      var ax2:Number; var ay2:Number;
      ax2 = ax + aw; ay2 = ay + ah;
      num = vecRect.length;
      for (i = 0; i < num; i++)
      {
        a = vecRect[i];
        //rect-rect overlap test
        if (a.cx > ax2) { continue; }
        if (a.cy > ay2) { continue; }
        if (a.cx +a.cw < ax) { continue; }
        if (a.cy +a.ch < ay) { continue; }
        return true;
      }//nexti      
      return false;
      
    }//iswall2
    
    
    public function onEnter(e:Event):void
    { 
      graphics.clear();
      graphics.lineStyle(2, 0);
      
      var mx:Number;    var my:Number;
      
      mx = stage.mouseX;    my = stage.mouseY;
      
      //debug -- is wall at mouse coords
      if (isWall2(mx, my,1,1))
      {  graphics.drawCircle(mx, my, 8); }
      
      graphics.drawCircle(cx, cy, 8);

      //get angles for circle to mouse coords      
      var ta:Number;
      ta = getAng(my - cy, mx - cx);
      ang = ta;
      
      graphics.moveTo(cx, cy);
      graphics.lineTo(cx + Math.cos(ang) * 8, cy + Math.sin(ang) * 8);

      //draw all rectangles
        drawRect();

      //draw border       
          graphics.drawRect(0, 0, 450, 450);

      graphics.lineStyle(2,0,0.25);
      graphics.moveTo(cx,cy);
      graphics.lineTo(mx,my);

      //check if circle is leaving the screen on the edge
          var leftEdge:Boolean;
          leftEdge = false;
          if (vx>0 && cx > 450-32) { cx = 64; leftEdge = true; }
          else if (vx < 0 && cx < 32) { cx = 450-64; leftEdge = true; }
          if (vy>0 && cy > 450-32) { cy = 64; leftEdge = true; }
          else if (vy < 0 && cy < 32) { cy = 450-64; leftEdge = true; }
          if (leftEdge) { resetMap(); }
      

    //deccelrate      
       vx *= 0.99;       vy *= 0.99;
       
    
     //only move when mouse is far
      if ( Math.abs(mx-cx)>40 || Math.abs(my-cy) > 40)
      {
          var ms:Number;     ms = 4; //movespeed
          var ax:Number;        var ay:Number;
          ax = Math.cos(ang) * ms;    ay = Math.sin(ang) * ms;
        
          var ws:Number;
          ws = 0.6; //accelration
        
          if (vx < ax) { vx += ws; if (vx > ax) { vx = ax; } } else if (vx > ax) { vx -= ws; if (vx < ax) { vx = ax; } }
          if (vy < ay) { vy += ws; if (vy > ay) { vy = ay; } } else if (vy > ay) { vy -= ws; if (vy < ay) { vy = ay; } }
      } else { vx*=0.8; vy*=0.8; }

      var rad:Number;      rad = 8;  
  
       //wall collisions
       if (isWall2(cx, cy,1,1) == false)    //ignore collisions when stuck in wall
       {
        if (vx > 0 && isWall2(cx + rad-2, cy-4,4,8)) { vx *= -0.5; }  
        if (vx < 0 && isWall2(cx - rad-2, cy-4,4,8)) { vx *= -0.5; }  
        if (vy > 0 && isWall2(cx-4, cy+rad-2,8,4)) { vy *= -0.5; }  
        if (vy < 0 && isWall2(cx-4, cy-rad-2,8,4)) { vy *= -0.5; }  
       }//endif
     
      cx += vx;      cy += vy;
      
      gameTime += 1;
    }//onenter
        
        
    public static function getAng(dy:Number, dx:Number):Number
    {
      if (dy == 0 && dx == 0) { return 0; }
        var a:Number;
        a = dx / ((dy<0?-dy:dy)+(dx<0?-dx:dx));
        if (dy < 0) { return (a-1)*1.57075; }
        return (1-a)*1.57075;
    }//getang
    
     //uses radians 
     //rotate a to b dy d percent (but not faster than max)
      public static function angLerp(a:Number, b:Number, d:Number=0.1, max:Number=6.28):Number
        {
            var c:Number;    var k:Number;
            if ( (a - b) > 3.1415 )
              {    c = b + 6.28;       k = (c - a) * d;
                if (k > max) { k= max;} else { if (k <-max) {k = -max;}}
                 a += k;        if (a > 6.28) a -= 6.28;       
              }
              else
              {  if ( (a - b) < -3.1415 )
                 {    c = b - 6.28;  k = (c - a) * d;
                 if (k > max) { k= max;} else { if (k <-max) {k = -max;}}
                  a += k;     if (a < 0) a += 6.28;        
                 }
                 else
                 {  k = (b - a) * d;  if (k > max) { k= max;} else { if (k <-max) {k = -max;}}    a += k;    }//endif2
              }//endif
            return a;
        }//anglerprad
        
    }//classend
}

import flash.display.Graphics;

internal class xRect
{
  public var cx:Number = 0;
  public var cy:Number = 0;
  public var cw:Number = 0;
  public var ch:Number = 0;
  
}//xrect