/**
 * Copyright _ryotaros ( http://wonderfl.net/user/_ryotaros )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kgM0
 */

package {
	import flash.filters.DisplacementMapFilter;
	import flash.filters.DisplacementMapFilterMode;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.geom.ColorTransform;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapDataChannel;
    import flash.events.MouseEvent;
    import flash.display.BlendMode;
    import flash.filters.BlurFilter;
    
    [SWF(width=465,height=465,backgroundColor=0)]
    public class FlashTest extends Sprite {
        
        public var bmpdata:BitmapData;
    	    public var sprite:Sprite;    
    	    public var matrix:Matrix;
    	    public var colortrans:ColorTransform;
    	    public var bmpcolortrans:ColorTransform;
    	    public var rect:Rectangle;
    	    public var bmp:BitmapData;
    	    public var filter:BlurFilter;
    	    public var filter2:DisplacementMapFilter;
    	    
        public function FlashTest() {
        		
            bmpdata = new BitmapData( 465, 465, false, 0 );
            addChild( new Bitmap(bmpdata));
            
            matrix = new Matrix;
            colortrans = new ColorTransform(); 
            sprite = newFig( 0, 0, 50, 0xFFFFFF);
            rect = new Rectangle(0,0,sprite.width,sprite.height);
            bmp = new BitmapData( sprite.width, sprite.height, true, 0 );
            bmpcolortrans = new ColorTransform( 0.99, 0.99, 0.999 );
            filter = new BlurFilter(2, 2, 1);
            
            var mapBitmap:BitmapData = new BitmapData(465, 465, false, 0);
            var mapPoint:Point = new Point(0,0);
            //mapBitmap.rect.topLeft;
            var componentX:uint = BitmapDataChannel.RED;
            var componentY:uint = BitmapDataChannel.GREEN;
            var scaleX:Number = 256;
            var scaleY:Number = 256;
            var r:uint = 128 + 2;
            var g:uint = 128 + 1; 
            var b:uint = 128;
            var col:uint = r << 16 | g << 8 | b;
            mapBitmap.fillRect( mapBitmap.rect,col);
            filter2 = new DisplacementMapFilter(mapBitmap, mapPoint, componentX, componentY, scaleX, scaleY );
            
            //図形を描画し、bmpdataにdrawする。
            addEventListener( Event.ENTER_FRAME, drawElements );
            
        }
        
        private function drawElements(e:Event):void {
            
            matrix.identity();
            
            colortrans.greenMultiplier = mouseX / 465;
            colortrans.blueMultiplier = mouseY / 465;
            colortrans.alphaMultiplier = Math.random();
           
            
            matrix.rotate(Math.PI * Math.random()); 
            matrix.translate(mouseX,mouseY);    
            
            //copyPixeels用
            //matrix.translate( sprite.width/2, sprite.height/2 );
            //var pt:Point = new Point(mouseX,mouseY);
            //bmp.draw(sprite,matrix);
        		bmpdata.colorTransform(bmpdata.rect,bmpcolortrans);
        		bmpdata.applyFilter(bmpdata, bmpdata.rect, bmpdata.rect.topLeft,filter2 );	                       
            bmpdata.draw( sprite, matrix, colortrans, BlendMode.ADD );
        	    
            //bmpdata.copyPixels( bmp , rect , pt );
           
        }
        
        private function newFig(cx:Number,cy:Number,size:Number,col:uint):Sprite{
        		var shape:Sprite = new Sprite();
        		shape.graphics.lineStyle( 0, 0x000000, 0.3 );
       		shape.graphics.beginFill(col);
       		shape.graphics.drawCircle( cx, cy, size*0.5);
       		shape.graphics.drawCircle( cx, cy, size*0.4);
       		var w:Number = size *0.6 ;
       		var h:Number = size *0.15;
       		shape.graphics.drawRect(cx - w/2,cy - h/2,w,h);
			shape.graphics.endFill();
			return shape;
        }
    }
}