/**
 * Copyright t2421 ( http://wonderfl.net/user/t2421 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/kfMX
 */

// forked from siouxcitizen's Twitter投稿機能の練習
// forked from siouxcitizen's ButtonTest02:　ボタン作成機能をオブジェクトにまとめる
//Twitter投稿機能の練習
//
//↓以下のコードのTwitter投稿機能の部分を参考にさせてもらいました
//なぞり消し
//http://wonderfl.net/c/irRW

package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;

    import flash.net.URLRequest;
    import flash.net.navigateToURL;
    import flash.utils.escapeMultiByte;
    public class ButtonTest extends Sprite {
        
        private var button : SimpleButton;//ボタン 
        private var label : TextField;    //ラベル
        private var comment:String;
        private const HASH_TAG:String = "#wonderfl"; //つけたいハッシュタグ
        private const MY_URL:String = "http://wonderfl.net/c/sDTs/"; //表示したいURL
        
        public function ButtonTest() {
            label = new TextField;
            label.text = "TweetTest!";
            addChild(label);
            
            button = new CustomButton("Tweet");
            button.y = 20;

            button.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
            button.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
            addChild(button);
        }
   
        //マウスダウンイベントの処理
        private function onMouseDown(evt:MouseEvent):void {
            label.text = "Tweet!!!";
            comment = "ここに入る文字列がtweetされます。";
            var post:String = comment + " " + MY_URL + " " + HASH_TAG;
            navigateToURL(new URLRequest("http://twitter.com/home?status=" + escapeMultiByte(post)), "_blank");
        }

        //マウスアップイベントの処理
        private function onMouseUp(evt:MouseEvent):void {
            label.text = "TweetTest!";
        }        
    }
}

import flash.display.*;
import flash.system.*;
import flash.text.*;

//カスタムボタン
class CustomButton extends SimpleButton { 
        //コンストラクタ    
        public function CustomButton(label:String="") {
            //状態
            upState = makeSprite(label,0x00FFFF);
            overState = upState;
            downState = makeSprite(label,0x00FF00);
            hitTestState = upState;
        }

        //ボタン用スプライト作成
        private function makeSprite(text:String,color:uint):Sprite{
            //ボタン用ラベル作成
            var label : TextField = new TextField();
            label.text = text;
            label.autoSize = TextFieldAutoSize.CENTER;
            label.selectable = false;

            //ボタン用スプライト作成
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(color);
            sp.graphics.drawRoundRect(0, 0, 100, 20, 15);
            sp.graphics.endFill();
            sp.alpha = 0.8;            
            sp.addChild(label);
            
            //ラベル用フォーマット設定
            var format:TextFormat=new TextFormat();
            format.font = "Courier New";
            format.bold = true;
            format.size = 13;
            label.setTextFormat(format);

            return sp;
        }    
}
