/**
 * Copyright esukei ( http://wonderfl.net/user/esukei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jxg9
 */

/**
 * FPSとかの実験
 * 赤いの→ タイマーで1000/15ミリ秒毎に+10度
 * 緑の→ タイマーで1000/30ミリ秒毎に+10度
 * 青いの→ タイマーで1000/60ミリ秒毎に+10度
 * 灰色の→エンターフレーム毎に+10度
 * 薄い灰色の→setIntervalで1000/60ミリ秒毎に+10度
 *
 * 画面クリックでFPS変化
 */
package {
    import flash.display.Sprite;
    import flash.utils.Timer;
    import flash.utils.setInterval;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    [SWF(frameRate = "4")]
    public class FlashTest extends Sprite {
        private var timer:Timer;
        private var timer2:Timer;
        private var timer3:Timer;
        private var ball:Sprite;
        private var ball2:Sprite;
        private var ball3:Sprite;
        private var ball4:Sprite;
        private var ball5:Sprite;
        private var textField:TextField;
        private var textFormat:TextFormat;
        public function FlashTest() {
            // write as3 code here..
            
            textField = new TextField();
            textField.selectable = false;
            textField.width = stage.stageWidth;
            textField.height = stage.stageHeight;
            
            textFormat = new TextFormat();
            textFormat.color = 0xDDDDDD;
            textFormat.size = 140;
            textField.defaultTextFormat = textFormat;
            
            textField.text = stage.frameRate.toString();
            addChild(textField);
            
            ball = new Sprite();
            ball.graphics.beginFill(0xffff3300);
            ball.graphics.drawCircle(0,-30,15);
            ball.x = stage.stageWidth / 2;
            ball.y = stage.stageHeight / 2;
            addChild(ball);
            
            timer = new Timer(1000/15);
            timer.addEventListener(TimerEvent.TIMER, function(e:TimerEvent):void{
                ball.rotation += 10;
            });
            timer.start();
            
            ball2 = new Sprite();
            ball2.graphics.beginFill(0xff00ff55);
            ball2.graphics.drawCircle(0,-60,15);
            ball2.x = stage.stageWidth / 2;
            ball2.y = stage.stageHeight / 2;
            addChild(ball2);
            
            timer2 = new Timer(1000/30);
            timer2.addEventListener(TimerEvent.TIMER, function(e:TimerEvent):void{
                ball2.rotation += 10;
            });
            timer2.start();
            
            ball3 = new Sprite();
            ball3.graphics.beginFill(0xff0099ff);
            ball3.graphics.drawCircle(0,-120,15);
            ball3.x = stage.stageWidth / 2;
            ball3.y = stage.stageHeight / 2;
            addChild(ball3);
            
            timer3 = new Timer(1000/60);
            timer3.addEventListener(TimerEvent.TIMER, function(e:TimerEvent):void{
                ball3.rotation += 10;
            });
            timer3.start();
            
            ball4 = new Sprite();
            ball4.graphics.beginFill(0xff999999);
            ball4.graphics.drawCircle(0,-150,15);
            ball4.x = stage.stageWidth / 2;
            ball4.y = stage.stageHeight / 2;
            addChild(ball4);
            
            stage.addEventListener(Event.ENTER_FRAME, function(e:Event):void{
                ball4.rotation += 10;
            });
            
            ball5 = new Sprite();
            ball5.graphics.beginFill(0xffCCCCCC);
            ball5.graphics.drawCircle(0,-180,15);
            ball5.x = stage.stageWidth / 2;
            ball5.y = stage.stageHeight / 2;
            addChild(ball5);
            
            setInterval(function():void{
                ball5.rotation += 10;
            },1000/60);
            
            stage.addEventListener(MouseEvent.CLICK, function(event:MouseEvent):void{
                switch(stage.frameRate)
                {
                    case 4:stage.frameRate = 8;break;
                    case 8:stage.frameRate = 15;break;
                    case 15:stage.frameRate = 24;break;
                    case 24:stage.frameRate = 30;break;
                    case 30:stage.frameRate = 60;break;
                    case 60:stage.frameRate = 120;break;
                    case 120:stage.frameRate = 4;break;
                    default:break;
                }
                textField.text = stage.frameRate.toString();
            });
            
        }
    }
}