/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jviS
 */

package 
{
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.b2Body;
	import com.actionsnippet.qbox.QuickBox2D;
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	/**
	 * クリックで円を追加
	 * @author paq89
	 */
	[SWF(backgroundColor="0xFFFFFF", width=465, height=465, frameRate=60)]
	public class Main extends MovieClip 
	{
		private var _qbox:QuickBox2D;
		private var _fixedPoint:b2Vec2 = new b2Vec2(7.75, 7.75);
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			_qbox = new QuickBox2D(this, { gravityY:0 } );
			_qbox.createStageWalls();
			_qbox.start();
			
			addEventListener(Event.ENTER_FRAME, loop);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
		}
		
		private function onMouseDown(e:MouseEvent):void 
		{
			_qbox.addCircle( { radius:Math.random(), x: mouseX/30, y: mouseY/30 } );
		}
		
		private function loop(e:Event):void 
		{
			//ここ重要----------------------------------------
			for (var body:b2Body = _qbox.w.m_bodyList; body ; body = body.GetNext())
			{
				if (body.IsSleeping())continue;
				
				var f:b2Vec2 = _fixedPoint.Copy();
				f.Subtract(body.GetPosition());
				f.Normalize();
				f.Multiply(5);
				f = f.Negative();
				body.ApplyForce(f, body.GetWorldCenter());
			}
			//----------------------------------------
		}
		
	}
	
}