/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jVmQ
 */

/* 
 * とりあえずbeginBitmapFill()
 */
package{
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;

	public class BitmapScale9Grid_test3 extends Sprite{
		private const URL:String = "http://assets.wonderfl.net/images/related_images/6/65/65fb/65fb02d96036069076e3e206b6b6e1f50679de67";
		private var scale:Number = 0.99;
		
		private var l:Loader;
		private var img:BitmapScale9GridFill;
		
		public function BitmapScale9Grid_test3(){
			l = new Loader();
			l.contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
			l.load( new URLRequest( URL ), new LoaderContext( true ) );
		}
		private function onComp(e:Event):void{
			l.contentLoaderInfo.removeEventListener(Event.COMPLETE, onComp);
			
			var bmp:Bitmap = l.content as Bitmap;
			img = new BitmapScale9GridFill(bmp.bitmapData, 36, 36, 36, 36);
			addChild(img);
			
			//img.width = 300;
			
			addEventListener(Event.ENTER_FRAME, onEnter);
		}
		private function onEnter(e:Event):void{
			//*
			if(img.scaleX >= 1.5) scale = 0.99;
			if(img.scaleX <= 0.5) scale = 1.01;
			img.scaleX *= scale;
			//*/
			
			/*
			if(img.scaleY >= 1.5) scale = 0.99;
			if(img.scaleY <= 0.5) scale = 1.01;
			img.scaleY *= scale;
			//*/
		}
	}
}
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.geom.Rectangle;
	import flash.display.Graphics;
	import flash.geom.Matrix;
	import org.papervision3d.core.render.sort.NullSorter;
	


class BitmapScale9GridBaseClass extends Sprite{
	private var _orig:BitmapData;
	
	private var _sX:Number = 1;
	private var _sY:Number  = 1;
	
	private var _l:int, _t:int, _r:int, _b:int;
	private var _iw:int, _ih:int;
	
	public function BitmapScale9GridBaseClass(	source:BitmapData,
																				left:int, top:int, right:int, bottom:int){
		//
		setBitmapData( source, left, top, right, bottom);
	}
	
	public function setBitmapData(	source:BitmapData,
															left:int, top:int, right:int, bottom:int):void{
		this.source = source;
		this.left = left;
		this.right = right;
		this.top = top;
		this.bottom = bottom;
		this.insideWidth = source.width - ( left + right );
		this.insideHeight = source.height - ( top + bottom);
		
		draw(source.width, source.height);
	}
	
	protected function draw( width:int, height:int):void{
	}
	
	protected function get source():BitmapData{
		return _orig;
	}
	protected function set source( data:BitmapData ):void{
		_orig = data;
	}
	
	protected function get left():int{
		return _l;
	}
	protected function set left( value:int ):void{
		_l = value < 0 ? 0 : value;
	}
	
	protected function get top():int{
		return _t;
	}
	protected function set top( value:int ):void{
		_t = value < 0 ? 0 : value;
	}
	
	protected function get right():int{
		return _r;
	}
	protected function set right( value:int ):void{
		_r = value < 0 ? 0 : value;
	}
	
	protected function get bottom():int{
		return _b;
	}
	protected function set bottom( value:int ):void{
		_b = value < 0 ? 0 : value;
	}
	
	protected function get insideWidth():int{
		return _iw;
	}
	protected function set insideWidth( value:int ):void{
		_iw = value < 0 ? 0 : value;
	}
	
	protected function get insideHeight():int{
		return _ih;
	}
	protected function set insideHeight( value:int ):void{
		_ih = value < 0 ? 0 : value;
	}
	
	public override function get scale9Grid():Rectangle{
		return new Rectangle( left, top, insideWidth, insideHeight);
	}
	public override function set scale9Grid(innerRectangle:Rectangle):void{
		//とりあえずつぶしておく
	}
	public override function get scaleX():Number{
		return _sX;
	}
	public override function set scaleX(value:Number):void{
		_sX = value;
		draw( Math.round( source.width * value ), source.height);
	}
	
	public override function get scaleY():Number{
		return _sY;
	}
	public override function set scaleY(value:Number):void{
		_sY = value;
		draw( source.width, Math.round( source.height*value ) );
	}
	
	public override function set height(value:Number):void{
		draw( source.width, Math.round( value ));
	}
	public override function set width(value:Number):void{
		draw( Math.round( value ), source.height);
	}
}


class BitmapScale9GridFill extends BitmapScale9GridBaseClass{
	public function BitmapScale9GridFill(	source:BitmapData,
																	left:int, top:int, right:int, bottom:int){
		super(source, left, top, right, bottom);
	}
	protected override function draw( width:int, height:int):void{
		var m:Matrix = new Matrix();
		
		var w:int = width -(left + right);
		var iw:Number = w / insideWidth;
		var offsetX1:Number = left - left * iw;
		var offsetX2:int = width % source.width;
		
		var h:int = height - ( top + bottom);
		var ih:Number = h / insideHeight;
		var offsetY1:Number = top - top * ih;
		var offsetY2:int = height % source.height;
		
		var g:Graphics = this.graphics;
		
		
		g.clear();
		
		// debug 1
		//g.lineStyle(0, 0x00FFFF);
		
		// lt
		g.beginBitmapFill( source );
		g.drawRect( 0,0, left, top);
		g.endFill();
		
		// t
		m.scale( iw, 1);
		m.translate( offsetX1, 0);
		g.beginBitmapFill( source ,m);
		g.drawRect( left,0, w, top);
		g.endFill();
		
		// rt
		m = new Matrix();
		m.translate( offsetX2 , 0);
		g.beginBitmapFill( source ,m);
		g.drawRect( width - right, 0, right, top);
		g.endFill();
		
		// l
		m = new Matrix();
		m.scale( 1, ih);
		m.translate(0, offsetY1 );
		g.beginBitmapFill( source, m);
		g.drawRect( 0, top, left, h);
		g.endFill();
		
		// innerRect
		m = new Matrix();
		m.scale( iw, ih);
		m.translate(offsetX1, offsetY1 );
		g.beginBitmapFill( source, m);
		g.drawRect( left, top, w, h);
		g.endFill();
		
		// r
		m = new Matrix();
		m.scale( 1, ih);
		m.translate(offsetX2, offsetY1 );
		g.beginBitmapFill( source, m);
		g.drawRect( width - right, top, right, h);
		g.endFill();
		
		// lb
		m = new Matrix();
		m.translate(0, offsetY2 );
		g.beginBitmapFill( source, m);
		g.drawRect( 0, height - bottom, left, bottom);
		g.endFill();
		
		// bottom
		m = new Matrix();
		m.scale( iw, 1);
		m.translate(offsetX1, offsetY2 );
		g.beginBitmapFill( source, m);
		g.drawRect( left, height - bottom, w, bottom);
		g.endFill();
		
		// rb
		m = new Matrix();
		m.translate(offsetX2, offsetY2 );
		g.beginBitmapFill( source, m);
		g.drawRect( width - right, height - bottom, right, bottom);
		g.endFill();
		
		// debug 2
		/* 
		g.lineStyle(0, 0xFF0000);
		g.drawRect(0,0, width, height );
		
		g.moveTo( width >>1, 0);
		g.lineTo( width >>1, height);
		
		g.moveTo( 0, height >>1);
		g.lineTo( width, height >>1);
		
		//*/
	}
}