/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jLsq
 */

package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    import caurina.transitions.Tweener;
    /*
    座標点をつないで図形を作る
    
    */
    public class FlashTest extends Sprite {
        private var cnt:int = 0;
        private var obj:Object = new Object();//ライン
        private var obj2:Object = new Object();//ポイント
        private var s1:Sprite = new Sprite();
        private var t1:TextField = new TextField();
        private var s2:Sprite = new Sprite();
        public function FlashTest() {
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN,stDrag);
            stage.addEventListener(MouseEvent.MOUSE_UP,endDrag);
            
            addChild(s1);
            addChild(s2);
            addChild(t1);  
            
        }
        
//マウスダウン        
        private function stDrag(e:MouseEvent):void{
            stage.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
            createNode();
            
        }

//ノード生成
        private function createNode():void{
            var s:Sprite = new Sprite();
            obj[cnt] = s;
           
            s.graphics.beginFill(0xff0000);
            s.graphics.drawCircle(0,0,10);
            s.graphics.endFill();
            s.x = mouseX; s.y = mouseY;
            stage.addChild(s);
            
            //    ロールオーバー            
            obj[cnt].addEventListener(MouseEvent.ROLL_OVER,function():void{
                Tweener.addTween(s, {
                time: 0.3,    // アニメーション時間
                scaleX: 2,  // s の scaleX を 指定値 まで遷移
                scaleY: 2,  // s の scaleY を 指定値 まで遷移
                alpha: 0.8,//不透明率
                transition: "liner"
                });
  
            });   

            //    ロールアウト
            obj[cnt].addEventListener(MouseEvent.ROLL_OUT,function():void{
                Tweener.addTween(s, {
                time: 2,    // アニメーション時間
                scaleX: 1,  // s の scaleX を 指定値 まで遷移
                scaleY: 1,  // s の scaleY を 指定値 まで遷移
                alpha: 0,//不透明率
                transition: "liner"
                });
            }); 
            
            //ドラッグ開始
            s.addEventListener(MouseEvent.MOUSE_DOWN,function(e:MouseEvent):void{
                s.startDrag();
                Tweener.addTween(s, {
                    time: 1,    // アニメーション時間
                    scaleX: 3,  // s の scaleX を 指定値 まで遷移
                    scaleY: 3,  // s の scaleY を 指定値 まで遷移
                    alpha: 0,//不透明率
                    transition: "liner"
                });
                
                stage.addEventListener(MouseEvent.MOUSE_MOVE,function():void{
                    draw2();
                });
                
                e.stopPropagation();//イベントの伝播を止める
                });
            //ドラッグ終了
            s.addEventListener(MouseEvent.MOUSE_UP,function(e:MouseEvent):void{
                s.stopDrag();
                
                stage.removeEventListener(MouseEvent.MOUSE_MOVE,function():void{
                    draw2();
                });

                draw2();
                
                e.stopPropagation();//イベントの伝播を止める
                });
            
            cnt++;
        }
//ドラッグ中
        private function onMove(e:MouseEvent):void{
            s1.graphics.clear();
            s1.graphics.lineStyle(2,0xff0000);
            s1.graphics.moveTo(obj[cnt-1].x,obj[cnt-1].y);
            s1.graphics.lineTo(mouseX,mouseY);
            
        }
//ドラッグ終了        
        private function endDrag(e:MouseEvent):void{
            stage.removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
            
            var pos1:Point = new Point(obj[cnt-1].x, obj[cnt-1].y);
            var pos2:Point = new Point(mouseX, mouseY);
            
            if(pos2.equals(pos1) == false)createNode();
            else{
                obj[cnt-1].graphics.clear();
                obj[cnt-1].graphics.beginFill(0x000000);
                obj[cnt-1].graphics.drawCircle(0,0,5);
                obj[cnt-1].graphics.endFill();
                
                
            }
            t1.text = Point.distance(pos1,pos2).toString();
            
            //createNode();
            //draw2();
            s1.graphics.clear();
        }
        

        
//描画２        
        private function draw2():void{
            t1.text = cnt.toString();
            s2.graphics.clear();
            s2.graphics.lineStyle(1,0x000000);
            for(var i:int = 0;i < cnt;i++){
                s2.graphics.moveTo(obj[i].x,obj[i].y);
                i++;
                s2.graphics.lineTo(obj[i].x,obj[i].y);
            }
        }
        

    }
}