/**
 * Copyright fluxus ( http://wonderfl.net/user/fluxus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iW0z
 */

// forked from ProjectNya's forked from: シーン遷移 (3)
// forked from ProjectNya's シーン遷移 (3)
////////////////////////////////////////////////////////////////////////////////
// [AS3.0] シーン遷移に挑戦！ (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1333
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.MouseEvent;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var menus:Array;
        private var scenes:Array;
        private static var max:uint = 5;
        private var sceneId:uint = 0;
        private var transited:uint = 0;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            var labels:Array = new Array();
            labels.push("index");
            labels.push("aqua");
            labels.push("light");
            labels.push("piyo");
            labels.push("fire");
            var bases:Array = new Array();
            bases.push(0x999999);
            bases.push(0x0066CC);
            bases.push(0x669900);
            bases.push(0xFF6600);
            bases.push(0xFF3399);
            var lights:Array = new Array();
            lights.push([0xFFFFFF, 0x999999]);
            lights.push([0x00FFFF, 0x3333FF]);
            lights.push([0x99FF00, 0x33CC00]);
            lights.push([0xFFFF00, 0xFFCC00]);
            lights.push([0xFFCCFF, 0xFF66CC]);
            var colors:Array = new Array();
            colors.push(0xEEEEEE);
            colors.push(0x0066CC);
            colors.push(0x669900);
            colors.push(0xFF6600);
            colors.push(0xFF3399);
            menus = new Array();
            scenes = new Array();
            //
            var container:Sprite = new Sprite();
            addChild(container);
            container.x = 5;
            container.y = 80;
            var overlay:Shape = new Shape();
            //addChild(overlay);
            overlay.graphics.beginFill(0x000000);
            overlay.graphics.drawRect(0, 0, 455, 360);
            overlay.graphics.endFill();
            overlay.x = 5;
            overlay.y = 80;
            container.mask = overlay;
            //
            var scene0:Index = new Index(colors[0], labels[0]);
            container.addChild(scene0);
            scenes.push(scene0);
            var scene1:Scene1 = new Scene1(colors[1], labels[1]);
            container.addChild(scene1);
            scenes.push(scene1);
            var scene2:Scene2 = new Scene2(colors[2], labels[2]);
            container.addChild(scene2);
            scenes.push(scene2);
            var scene3:Scene3 = new Scene3(colors[3], labels[3]);
            container.addChild(scene3);
            scenes.push(scene3);
            var scene4:Scene4 = new Scene4(colors[4], labels[4]);
            container.addChild(scene4);
            scenes.push(scene4);
            //
            for (var n:uint = 0; n < max; n++) {
                var menu:ActionMenu = new ActionMenu();
                menu.x = 50 + 5*uint(n > 0) + 90*n;
                menu.y = 50;
                addChild(menu);
                menu.init({id: n, label: labels[n], width: 80});
                menu.colorize(bases[n], lights[n]);
                menu.addEventListener(MouseEvent.CLICK, select, false, 0, true);
                menus.push(menu);
                var scene:Sprite = scenes[n];
                scene.addEventListener(CompoEvent.CLOSED, closed, false, 0, true);
                scene.addEventListener(CompoEvent.OPENED, opened, false, 0, true);
            }
            manage();
            scene0.start();
        }
        private function select(evt:MouseEvent):void {
            transit(evt.target.id);
        }
        private function transit(id:uint):void {
            if (id == sceneId) return;
            sceneId = id;
            manage();
            transited = 0;
            for (var n:uint = 0; n < max; n++) {
                var scene:IScene = scenes[n];
                scene.close();
            }
        }
        private function closed(evt:CompoEvent):void {
            transited ++;
            if (transited > max - 1) {
                reset();
                var scene:IScene = scenes[sceneId];
                scene.open();
            }
        }
        private function opened(evt:CompoEvent):void {
            var scene:IScene = scenes[evt.value];
            scene.start();
        }
        private function reset():void {
            for (var n:uint = 0; n < max; n++) {
                var scene:IScene = scenes[n];
                scene.reset();
            }
        }
        private function manage():void {
            for (var n:uint = 0; n < max; n++) {
                var menu:ActionMenu = menus[n];
                menu.selected = (n == sceneId);
            }
        }
        
    }

}


//////////////////////////////////////////////////
// ActionMenuクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.geom.ColorTransform;
import flash.events.Event;
import flash.events.MouseEvent;

class ActionMenu extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var base:Shape;
    private var front:Shape;
    private var light:Shape;
    private var overlay:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 32;
    private static var corner:uint = 6;
    private static var tHeight:uint = 17;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var baseColor:uint = 0x0066CC;
    private static var lightColor:uint = 0x00FFFF;
    private static var overColor:uint = 0x3333FF;
    private static var lights:Array = [lightColor, overColor];
    private static var tColor:uint = 0xFFFFFF;
    private static var defaultColorTrans:ColorTransform;
    private static var disableColor:uint = 0xCCCCCC;
    private static var disableColorTrans:ColorTransform;
    private var mode:int;
    private static var unit:Number = 0.1;
    private var _selected:Boolean = false;
    private var _enabled:Boolean = true;

    public function ActionMenu() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        draw();
    }
    private function draw():void {
        defaultColorTrans = new ColorTransform();
        disableColorTrans = new ColorTransform();
        disableColorTrans.color = disableColor;
        shade = new Shape();
        base = new Shape();
        front = new Shape();
        light = new Shape();
        overlay = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(base);
        addChild(front);
        addChild(light);
        addChild(overlay);
        addChild(txt);
        createBase(shade, _width, _height, corner, bColor);
        shade.filters = [new DropShadowFilter(1, 90, sColor, 0.4, 4, 4, 2, 3, false, false)];
        //createBase(base, _width-2, _height-2, corner, baseColor);
        //createFront(front, _width, _height, corner);
        //createLight(light, _width-2, _height-2, corner);
        createOverlay(overlay, _width-2, _height-2, corner);
        txt.x = -_width/2;
        txt.y = -tHeight + _height/4;
        txt.width = _width;
        txt.height = tHeight;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 10;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.textColor = tColor;
        txt.text = label;
        txt.filters = [new DropShadowFilter(0, 90, sColor, 0.5, 2, 2, 2, 3, false, false)];
        light.alpha = 0;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent = null):void {
        mode = 1;
        addEventListener(Event.ENTER_FRAME, action, false, 0, true);
    }
    private function rollOut(evt:MouseEvent = null):void {
        mode = -1;
        addEventListener(Event.ENTER_FRAME, action, false, 0, true);
    }
    private function action(evt:Event):void {
        light.alpha += unit*mode;
        if (light.alpha < 0) {
            light.alpha = 0;
            removeEventListener(Event.ENTER_FRAME, action);
        }
        if (light.alpha > 1) {
            light.alpha = 1;
            removeEventListener(Event.ENTER_FRAME, action);
        }
    }
    private function _up():void {
        base.transform.colorTransform = defaultColorTrans;
        front.transform.colorTransform = defaultColorTrans;
    }
    private function _down():void {
        base.transform.colorTransform = defaultColorTrans;
        front.transform.colorTransform = defaultColorTrans;
        light.alpha = 1;
    }
    private function _disable():void {
        base.transform.colorTransform = disableColorTrans;
        front.transform.colorTransform = disableColorTrans;
    }
    public function get selected():Boolean {
        return _selected;
    }
    public function set selected(param:Boolean):void {
        _selected = param;
        enabled = !_selected;
        if (_selected) {
            _down();
        } else {
            _up();
            rollOut();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
        } else {
            _disable();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
        }
    }
    public function colorize(c:uint, list:Array):void {
        baseColor = c;
        lights = list;
        createBase(base, _width-2, _height-2, corner, baseColor);
        createFront(front, _width, _height, corner);
        createLight(light, _width-2, _height-2, corner);
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createFront(target:Shape, w:uint, h:uint, c:uint):void {
        var colors:Array = [baseColor, baseColor];
        var alphas:Array = [0, 0.5];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w, h, 0.5*Math.PI, -w/2, -h/2);
        target.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createLight(target:Shape, w:uint, h:uint, c:uint):void {
        var colors:Array = lights;
        var alphas:Array = [1, 0];
        var ratios:Array = [40, 160];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w*2, h*3, 0, -w, -h*0.9);
        target.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createOverlay(target:Shape, w:uint, h:uint, c:uint):void {
        target.graphics.beginFill(bColor, 0.3);
        target.graphics.drawEllipse(-w*1.125, -h*4.375, w*2.25, h*4.375);
        target.graphics.endFill();
        var _mask:Shape = new Shape();
        _mask.graphics.beginFill(sColor);
        _mask.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        _mask.graphics.endFill();
        addChild(_mask);
        target.mask = _mask;
    }

}


//////////////////////////////////////////////////
// ISceneインターフェイス
//////////////////////////////////////////////////

interface IScene {

    function start():void;
    function reset():void;
    function open():void;
    function close():void;
    function enable(useful:Boolean):void;

}


//////////////////////////////////////////////////
// Indexクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.*;

class Index extends Sprite implements IScene {
    public var cid:uint = 0;
    private var tweens:Array;
    private var color:uint = 0x000000;
    private var base:Sprite;
    private var label:Label;
    private var txt:String;
    private var logo:Label;

    public function Index(c:uint, t:String = "") {
        color = c;
        txt = t;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        tweens = new Array();
        base = new Sprite();
        addChild(base);
        base.graphics.beginFill(color);
        base.graphics.drawRect(0, 0, 455, 360);
        base.graphics.endFill();
        label = new Label(100, 30, 20, Label.CENTER);
        base.addChild(label);
        label.x = 182;
        label.y = 165;
        label.textColor = 0xFFFFFF;
        label.text = txt;
        logo = new Label(200, 30, 20, Label.CENTER);
        base.addChild(logo);
        logo.x = 132;
        logo.y = 165;
        logo.textColor = 0xFFFFFF;
        logo.text = "www.project-nya.jp";
        base.alpha = 1;
        base.visible = true;
        label.alpha = 1;
        label.visible = true;
        logo.alpha = 0;
        logo.visible = false;
    }
    public function start():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.delay(BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 0.5), 
            BetweenAS3.delay(BetweenAS3.to(logo, {alpha: 1, visible: 1}, 0.4, Linear.easeNone), 0.2)
        );
        itween.addEventListener(TweenEvent.COMPLETE, setup, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function setup(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, setup);
    }
    public function reset():void {
    }
    public function open():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(base, {alpha: 1, visible: 1}, 0.4, Linear.easeNone), 
            BetweenAS3.to(label, {alpha: 1, visible: 1}, 0.4, Linear.easeNone)
        );
        itween.addEventListener(TweenEvent.COMPLETE, opened, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function opened(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, opened);
        dispatchEvent(new CompoEvent(CompoEvent.OPENED, cid));
    }
    public function close():void {
        clear();
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.parallel(
                BetweenAS3.to(logo, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 
                BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone)
            ), 
            BetweenAS3.to(base, {alpha: 0, visible: 0}, 0.3, Linear.easeNone)
        );
        itween.addEventListener(TweenEvent.COMPLETE, closed, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function closed(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, closed);
        dispatchEvent(new CompoEvent(CompoEvent.CLOSED, cid));
    }
    private function clear():void {
        for (var n:uint = 0; n < tweens.length; n++) {
            var itween:ITween = tweens[n];
            itween.stop();
            itween = null;
        }
    }
    public function enable(useful:Boolean):void {
    }

}


//////////////////////////////////////////////////
// Scene1クラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.*;

class Scene1 extends Sprite implements IScene {
    public var cid:uint = 1;
    private var tweens:Array;
    private var color:uint = 0x000000;
    private var base:Sprite;
    private var label:Label;
    private var txt:String;
    private var manager:ColorManager;
    private var ball:WaterBall;

    public function Scene1(c:uint, t:String = "") {
        color = c;
        txt = t;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        tweens = new Array();
        base = new Sprite();
        addChild(base);
        base.graphics.beginFill(color);
        base.graphics.drawRect(0, 0, 455, 360);
        base.graphics.endFill();
        label = new Label(100, 30, 20, Label.CENTER);
        base.addChild(label);
        label.x = 182;
        label.y = 165;
        label.textColor = 0xFFFFFF;
        label.text = txt;
        base.y = - 360;
        label.alpha = 0;
        label.visible = false;
        manager = new ColorManager(base);
        manager.brightOffset = 0;
        ball = new WaterBall();
        addChild(ball);
        ball.x = 227;
        ball.y = 280;
        ball.alpha = 0;
        ball.visible = false;
    }
    public function start():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.delay(BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 0.5), 
            BetweenAS3.parallel(
                BetweenAS3.to(manager, {brightOffset: 100}, 0.8, Linear.easeNone), 
                BetweenAS3.delay(BetweenAS3.to(ball, {alpha: 1, visible: 1}, 0.4, Linear.easeNone), 0.4)
            )
        );
        itween.addEventListener(TweenEvent.COMPLETE, setup, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function setup(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, setup);
        ball.start();
    }
    public function reset():void {
        ball.stop();
    }
    public function open():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(base, {y: 0}, 0.4, Quad.easeOut), 
            BetweenAS3.to(label, {alpha: 1, visible: 1}, 0.4, Linear.easeNone)
        );
        itween.addEventListener(TweenEvent.COMPLETE, opened, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function opened(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, opened);
        dispatchEvent(new CompoEvent(CompoEvent.OPENED, cid));
    }
    public function close():void {
        clear();
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.parallel(
                BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 
                BetweenAS3.to(ball, {alpha: 0, visible: 0}, 0.3, Linear.easeNone)
            ), 
            BetweenAS3.to(manager, {brightOffset: 0}, 0.3, Linear.easeNone), 
            BetweenAS3.to(base, {y: - 360}, 0.3, Quad.easeOut)
        );
        itween.addEventListener(TweenEvent.COMPLETE, closed, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function closed(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, closed);
        dispatchEvent(new CompoEvent(CompoEvent.CLOSED, cid));
    }
    private function clear():void {
        for (var n:uint = 0; n < tweens.length; n++) {
            var itween:ITween = tweens[n];
            itween.stop();
            itween = null;
        }
    }
    public function enable(useful:Boolean):void {
    }

}


//////////////////////////////////////////////////
// Scene2クラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Rectangle;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.*;

class Scene2 extends Sprite implements IScene {
    public var cid:uint = 2;
    private var tweens:Array;
    private var color:uint = 0x000000;
    private var base:Sprite;
    private var label:Label;
    private var txt:String;
    private var manager:ColorManager;
    private var light:EmitLight;

    public function Scene2(c:uint, t:String = "") {
        color = c;
        txt = t;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        tweens = new Array();
        base = new Sprite();
        addChild(base);
        base.graphics.beginFill(color);
        base.graphics.drawRect(0, 0, 455, 360);
        base.graphics.endFill();
        label = new Label(100, 30, 20, Label.CENTER);
        base.addChild(label);
        label.x = 182;
        label.y = 165;
        label.textColor = 0xFFFFFF;
        label.text = txt;
        base.x = - 455;
        label.alpha = 0;
        label.visible = false;
        manager = new ColorManager(base);
        manager.brightOffset = 0;
        var rect:Rectangle = new Rectangle(0, 0, 455, 360);
        light = new EmitLight(rect);
        addChild(light);
        light.x = 0;
        light.y = 0;
        light.alpha = 0;
        light.visible = false;
    }
    public function start():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.delay(BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 0.5), 
            BetweenAS3.parallel(
                BetweenAS3.to(manager, {brightOffset: -100}, 0.8, Linear.easeNone), 
                BetweenAS3.delay(BetweenAS3.to(light, {alpha: 1, visible: 1}, 0.4, Linear.easeNone), 0.4)
            )
        );
        itween.addEventListener(TweenEvent.COMPLETE, setup, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function setup(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, setup);
        light.start();
    }
    public function reset():void {
        light.stop();
    }
    public function open():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(base, {x: 0}, 0.4, Quad.easeOut), 
            BetweenAS3.to(label, {alpha: 1, visible: 1}, 0.4, Linear.easeNone)
        );
        itween.addEventListener(TweenEvent.COMPLETE, opened, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function opened(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, opened);
        dispatchEvent(new CompoEvent(CompoEvent.OPENED, cid));
    }
    public function close():void {
        clear();
        reset();
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.parallel(
                BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 
                BetweenAS3.to(light, {alpha: 0, visible: 0}, 0.3, Linear.easeNone)
            ), 
            BetweenAS3.to(manager, {brightOffset: 0}, 0.3, Linear.easeNone), 
            BetweenAS3.to(base, {x: - 480}, 0.3, Quad.easeOut)
        );
        itween.addEventListener(TweenEvent.COMPLETE, closed, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function closed(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, closed);
        dispatchEvent(new CompoEvent(CompoEvent.CLOSED, cid));
    }
    private function clear():void {
        for (var n:uint = 0; n < tweens.length; n++) {
            var itween:ITween = tweens[n];
            itween.stop();
            itween = null;
        }
    }
    public function enable(useful:Boolean):void {
    }

}


//////////////////////////////////////////////////
// Scene3クラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.display.MovieClip;
import flash.display.Loader;
import flash.net.URLRequest;
import flash.system.Security;
import flash.system.LoaderContext;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.*;

class Scene3 extends Sprite implements IScene {
    public var cid:uint = 3;
    private var tweens:Array;
    private var color:uint = 0x000000;
    private var base:Sprite;
    private var label:Label;
    private var txt:String;
    private var manager:ColorManager;
    private var randomtxt:RandomText;
    private var loader:Loader;
    private static var piyoPath:String = "http://www.project-nya.jp/images/flash/piyo2d.swf";
    private var Piyo:Class;
    private var piyo:MovieClip;

    public function Scene3(c:uint, t:String = "") {
        color = c;
        txt = t;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        tweens = new Array();
        base = new Sprite();
        addChild(base);
        base.graphics.beginFill(color);
        base.graphics.drawRect(0, 0, 455, 360);
        base.graphics.endFill();
        label = new Label(100, 30, 20, Label.CENTER);
        base.addChild(label);
        label.x = 182;
        label.y = 165;
        label.textColor = 0xFFFFFF;
        label.text = txt;
        base.x = 455;
        label.alpha = 0;
        label.visible = false;
        manager = new ColorManager(base);
        manager.brightOffset = 0;
        randomtxt = new RandomText();
        addChild(randomtxt);
        randomtxt.x = 20;
        randomtxt.y = 10;
        var list:Array = new Array();
        list.push("Adobe Flash");
        list.push("ActionScript3.0");
        list.push("www.project-nya.jp");
        randomtxt.setup(list);
        Security.allowDomain("www.project-nya.jp");
        loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete, false, 0, true);
        loader.load(new URLRequest(piyoPath), new LoaderContext(true));
    }
    private function complete(evt:Event):void {
        loader.removeEventListener(Event.COMPLETE, complete);
        var content:MovieClip = MovieClip(evt.target.content);
        Piyo = MovieClip(content.piyo).constructor;
        loader = null;
        piyo = new Piyo();
        addChild(piyo);
        piyo.x = 227;
        piyo.y = 300;
        piyo.scale = 2.5;
        piyo.visible = false;
    }
    public function start():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.delay(BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 0.5), 
            BetweenAS3.parallel(
                BetweenAS3.to(manager, {brightOffset: 100}, 0.8, Linear.easeNone), 
                BetweenAS3.delay(BetweenAS3.to(randomtxt, {alpha: 1, visible: 1}, 0.4, Linear.easeNone), 0.4)
            )
        );
        itween.addEventListener(TweenEvent.COMPLETE, setup, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function setup(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, setup);
        randomtxt.start();
        var itween:ITween = BetweenAS3.to(piyo, {scale: 4, visible: 1}, 2, Elastic.easeOutWith(0.1, 0.5));
        itween.play();
        tweens.push(itween);
    }
    public function reset():void {
        randomtxt.stop();
    }
    public function open():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(base, {x: 0}, 0.4, Quad.easeOut), 
            BetweenAS3.to(label, {alpha: 1, visible: 1}, 0.4, Linear.easeNone)
        );
        itween.addEventListener(TweenEvent.COMPLETE, opened, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function opened(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, opened);
        dispatchEvent(new CompoEvent(CompoEvent.OPENED, cid));
    }
    public function close():void {
        clear();
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.parallel(
                BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 
                BetweenAS3.to(randomtxt, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 
                BetweenAS3.to(piyo, {scale: 2.5, visible: 0}, 0.3, Quad.easeOut)
            ), 
            BetweenAS3.to(manager, {brightOffset: 0}, 0.3, Linear.easeNone), 
            BetweenAS3.to(base, {x: 480}, 0.3, Quad.easeOut)
        );
        itween.addEventListener(TweenEvent.COMPLETE, closed, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function closed(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, closed);
        dispatchEvent(new CompoEvent(CompoEvent.CLOSED, cid));
    }
    private function clear():void {
        for (var n:uint = 0; n < tweens.length; n++) {
            var itween:ITween = tweens[n];
            itween.stop();
            itween = null;
        }
    }
    public function enable(useful:Boolean):void {
    }

}


//////////////////////////////////////////////////
// Scene4クラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.*;

class Scene4 extends Sprite implements IScene {
    public var cid:uint = 4;
    private var tweens:Array;
    private var color:uint = 0x000000;
    private var base:Sprite;
    private var label:Label;
    private var txt:String;
    private var manager:ColorManager;
    private var flare:FlareMap;
    private var detection:DetectPixels;

    public function Scene4(c:uint, t:String = "") {
        color = c;
        txt = t;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        tweens = new Array();
        base = new Sprite();
        addChild(base);
        base.graphics.beginFill(color);
        base.graphics.drawRect(0, 0, 455, 360);
        base.graphics.endFill();
        label = new Label(100, 30, 20, Label.CENTER);
        base.addChild(label);
        label.x = 182;
        label.y = 165;
        label.textColor = 0xFFFFFF;
        label.text = txt;
        base.y = 360;
        label.alpha = 0;
        label.visible = false;
        manager = new ColorManager(base);
        manager.brightOffset = 0;
        var shape:Shape = new Shape();
        shape.graphics.beginFill(0xFFFFFF, 0.5);
        shape.graphics.drawEllipse(0, 0, 240, 40);
        //addChild(shape);
        shape.x = 227 - 120;
        shape.y = 280;
        var rect:Rectangle = new Rectangle(0, 0, 260, 300);
        flare = new FlareMap(rect);
        addChild(flare);
        flare.x = 227;
        flare.y = 280;
        var area:Rectangle = new Rectangle(0, 0, 260, 300);
        detection = new DetectPixels(2);
        detection.search(shape, area, 0x66FFFFFF);
        flare.map = detection.pixels();
        flare.offset = {x: 10, y: 260};
        flare.setup(6, 3, 50);
    }
    public function start():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.delay(BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 0.5), 
            BetweenAS3.to(manager, {brightOffset: - 100}, 0.8, Linear.easeNone)
        );
        itween.addEventListener(TweenEvent.COMPLETE, setup, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function setup(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, setup);
        flare.start();
    }
    public function reset():void {
        flare.stop();
    }
    public function open():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(base, {y: 0}, 0.4, Quad.easeOut), 
            BetweenAS3.to(label, {alpha: 1, visible: 1}, 0.4, Linear.easeNone)
        );
        itween.addEventListener(TweenEvent.COMPLETE, opened, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function opened(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, opened);
        dispatchEvent(new CompoEvent(CompoEvent.OPENED, cid));
    }
    public function close():void {
        clear();
        reset();
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 
            BetweenAS3.to(manager, {brightOffset: 0}, 0.3, Linear.easeNone), 
            BetweenAS3.to(base, {y: 360}, 0.3, Quad.easeOut)
        );
        itween.addEventListener(TweenEvent.COMPLETE, closed, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function closed(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, closed);
        dispatchEvent(new CompoEvent(CompoEvent.CLOSED, cid));
    }
    private function clear():void {
        for (var n:uint = 0; n < tweens.length; n++) {
            var itween:ITween = tweens[n];
            itween.stop();
            itween = null;
        }
    }
    public function enable(useful:Boolean):void {
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
        filters = [new DropShadowFilter(1, 90, 0x000000, 0.4, 4, 4, 1.5, 3, false, false, false)];
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}


//////////////////////////////////////////////////
// CompoEventクラス
//////////////////////////////////////////////////

import flash.events.Event;

class CompoEvent extends Event {
    public static const OPENED:String = "opened";
    public static const CLOSED:String = "closed";
    public static const SELECT:String = "select";
    public static const CHANGE:String = "change";
    public var value:*;

    public function CompoEvent(type:String, value:*) {
        super(type);
        this.value = value;
    }

    override public function clone():Event {
        return new CompoEvent(type, value);
    }

}


//////////////////////////////////////////////////
// ColorManagerクラス
//////////////////////////////////////////////////

import flash.display.DisplayObject;
import flash.geom.ColorTransform;
import flash.filters.ColorMatrixFilter;

class ColorManager {
    private var target:DisplayObject;
    private var _brightness:Number = 0;
    private var _saturation:Number = 100;
    private static var rs:Number = 0.3086;
    private static var gs:Number = 0.6094;
    private static var bs:Number = 0.0820;

    public function ColorManager(tg:DisplayObject) {
        target = tg;
    }

    public function get brightOffset():Number {
        return _brightness;
    }
    public function set brightOffset(param:Number):void {
        _brightness = param;
        target.transform.colorTransform = getBrightOffset(_brightness);
    }
    private function getBrightOffset(param:Number):ColorTransform {
        var percent:Number = 1;
        var offset:Number = param*2.55;
        var colorTrans:ColorTransform = new ColorTransform(0, 0, 0, 1, 0, 0, 0, 0);
        colorTrans.redMultiplier = percent;
        colorTrans.greenMultiplier = percent;
        colorTrans.blueMultiplier = percent;
        colorTrans.redOffset = offset;
        colorTrans.greenOffset = offset;
        colorTrans.blueOffset = offset;
        colorTrans.alphaMultiplier = 1;
        colorTrans.alphaOffset = 0;
        return colorTrans;
    }
    public function get saturation():Number {
        return _saturation;
    }
    public function set saturation(param:Number):void {
        _saturation = param;
        target.filters = [getSaturation(_saturation)];
    }
    private function getSaturation(param:Number):ColorMatrixFilter {
        var colorMatrix:ColorMatrixFilter = new ColorMatrixFilter();
        var p:Number = param*0.01;
        var r:Number = (1 - p)*rs;
        var g:Number = (1 - p)*gs;
        var b:Number = (1 - p)*bs;
        var matrix:Array = [r + p, g, b, 0, 0, r, g + p, b, 0, 0, r, g, b + p, 0, 0, 0, 0, 0, 1, 0];
        colorMatrix.matrix = matrix;
        return colorMatrix;
    }

}


//////////////////////////////////////////////////
// WaterBallクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.display.BlendMode;

class WaterBall extends Sprite {
    private var water:Wave;
    private static var waves:Array = [190, 198, 206, 214];
    private static var segments:uint = 5;
    private static var xOffset:Number = 0.25;
    private static var yOffset:Number = 0.01;
    private var ball:Ball;

    public function WaterBall() {
        init();
    }

    private function init():void {
        var overlay:Shape = new Shape();
        overlay.graphics.beginFill(0x000000);
        overlay.graphics.drawCircle(0, 0, 116);
        overlay.graphics.endFill();
        overlay.x = 150;
        overlay.y = 120;
        water = new Wave(300, 240, 0.2, 0.4);
        water.x = -150;
        water.y = -120;
        water.blendMode = BlendMode.MULTIPLY;
        water.addChild(overlay);
        water.mask = overlay;
        water.initialize(waves, segments, xOffset, yOffset);
        ball = new Ball(0, 120, 0xFFFFFF);
        addChild(ball);
        ball.x = 0;
        ball.y = 20;
        ball.contain(water);
    }
    public function start():void {
        water.start();
    }
    public function stop():void {
        water.stop();
    }

}


//////////////////////////////////////////////////
// Waveクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;
import frocessing.math.PerlinNoise;
import frocessing.color.ColorHSV;

class Wave extends Sprite {
    private var canvas:Sprite;
    private var perlin:PerlinNoise;
    private var color:ColorHSV;
    private var t:Number = 0;
    private var bWidth:uint;
    private var bHeight:uint;
    private var top:Number = 0.2;
    private var bottom:Number = 0.6;
    private var amplitude:Number = bottom - top;
    private var waves:Array = [190, 198, 206, 214];
    private var segments:uint = 5;
    private var ratio:Number = 1/segments;
    private var xOffset:Number = 0.25;
    private var yOffset:Number = 0.01;
    private static var tightness:uint = 40;

    public function Wave(w:uint, h:uint, t:Number = 0.2, b:Number = 0.6) {
        bWidth = w;
        bHeight = h;
        top = t;
        bottom = b;
        amplitude = bottom - top;
        init();
    }

    private function init():void {
        canvas = new Sprite();
        addChild(canvas);
        perlin = new PerlinNoise();
        color = new ColorHSV();
    }
    public function initialize(w:Array = null, s:uint = 5, xo:Number = 0.25, yo:Number = 0.01):void {
        waves = w;
        if (waves == null) waves = [190, 198, 206, 214];
        segments = s;
        xOffset = xo;
        yOffset = yo;
        ratio = 1/segments;
        draw();
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, draw, false, 0, true);
    }
    public function stop():void {
        removeEventListener(Event.ENTER_FRAME, draw);
    }
    private function draw(evt:Event = null):void {
        canvas.graphics.clear();
        for (var d:uint = 0; d < waves.length; d++) {
            var points:Array = new Array();
            points.push(new Point(-bWidth*ratio, bHeight*amplitude));
            for (var n:uint = 1; n <= segments+1; n++) {
                var xPos:Number = n*bWidth*ratio;
                var yPos:Number = perlin.noise(n*xOffset*d, t)*bHeight*amplitude + bHeight*top;
                points.push(new Point(xPos-bWidth*ratio, yPos));
            }
            t += yOffset;
            points.push(new Point(bWidth*(1+ratio), bHeight*amplitude));
            points.unshift(points[0]);
            points.push(points[points.length-1]);
            color.h = waves[d];
            canvas.graphics.beginFill(color.value, 0.2);
            canvas.graphics.moveTo(points[0].x, points[0].y);
            for (var p:uint = 0; p < points.length-3; p++) {
                var p0:Point = points[p];
                var p1:Point = points[p+1];
                var p2:Point = points[p+2];
                var p3:Point = points[p+3];
                for (var s:uint = 1; s < tightness+1; s++) {
                    var px:Number = GeomUtil.spline(p0.x, p1.x, p2.x, p3.x, s/tightness);
                    var py:Number = GeomUtil.spline(p0.y, p1.y, p2.y, p3.y, s/tightness);
                    canvas.graphics.lineTo(px, py);
                }
            }
            canvas.graphics.lineTo(bWidth*(1+ratio), bHeight);
            canvas.graphics.lineTo(-bWidth*ratio, bHeight);
            canvas.graphics.endFill();
        }
    }

}


//////////////////////////////////////////////////
// Ballクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.display.DisplayObject;
import flash.filters.DropShadowFilter;
import flash.filters.GlowFilter;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import frocessing.color.ColorHSV;

class Ball extends Sprite {
    public var id:uint;
    private var radius:uint;
    private var color:uint;
    private var hsv:ColorHSV;
    private var ball:Sprite;
    private var base:Shape;
    private var inside:Sprite;
    private var light:Shape;
    private var shade:Shape;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private var shaded:Boolean;

    public function Ball(n:uint, r:uint, c:uint, a:Number = 1, s:Boolean = true) {
        id = n;
        radius = r;
        shaded = s;
        color = c;
        hsv = new ColorHSV(0, 1, 1);
        hsv.value = color;
        draw();
        ball.alpha = a;
    }

    public function init(hue:uint):void {
        hsv.h = hue;
        color = hsv.value;
        createBase();
    }
    public function contain(obj:DisplayObject):void {
        inside.addChild(obj);
    }
    private function draw():void {
        if (shaded) {
            shade = new Shape();
            addChild(shade);
            createShade();
        }
        ball = new Sprite();
        addChild(ball);
        ball.y = -radius;
        base = new Shape();
        ball.addChild(base);
        inside = new Sprite();
        ball.addChild(inside);
        light = new Shape();
        ball.addChild(light);
        createBase();
        createLight();
    }
    private function createBase():void {
        base.graphics.clear();
        base.graphics.beginFill(color);
        base.graphics.drawCircle(0, 0, radius);
        base.graphics.endFill();
        hsv.v = 0.8;
        var darken:uint = hsv.value;
        var glow:GlowFilter = new GlowFilter(darken, 1, radius*0.5, radius*0.5, 2, 3, true, false);
        base.filters = [glow];
    }
    private function createLight():void {
        var colors:Array = [bColor, bColor];
        var alphas:Array = [0.7, 0];
        var ratios:Array = [0, 191];
        var matrix:Matrix = new Matrix();
        var w:Number = radius*1.44;
        var h:Number = radius*1.35;
        var yOffset:Number = radius*0.95;
        matrix.createGradientBox(w, h, 0.5*Math.PI, -w*0.5, -yOffset);
        light.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        light.graphics.drawEllipse(-w*0.5, -yOffset, w, h);
        light.graphics.endFill();
    }
    private function createShade():void {
        shade.graphics.beginFill(sColor);
        shade.graphics.drawEllipse(-radius*0.75, -radius*0.1775, radius*1.5, radius*0.375);
        shade.graphics.endFill();
        var shadow:DropShadowFilter = new DropShadowFilter(0, 90, sColor, 0.5, radius*0.15, radius*0.15, 1, 3, false, false, true);
        shade.filters = [shadow];
    }

}


//////////////////////////////////////////////////
// GeomUtilクラス
//////////////////////////////////////////////////

class GeomUtil {

    public function GeomUtil() {
    }

    public static function spline(p0:Number, p1:Number, p2:Number, p3:Number, t:Number):Number {
        var v0:Number = (p2 - p0) * 0.5;
        var v1:Number = (p3 - p1) * 0.5;
        var t2:Number = t * t;
        var t3:Number = t2 * t;
        return (2 * p1 - 2 * p2 + v0 + v1) * t3 + ( -3 * p1 + 3 * p2 - 2 * v0 - v1) * t2 + v0 * t + p1;
    }

}


//////////////////////////////////////////////////
// EmitLightクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.ColorTransform;
import flash.display.BlendMode;
import flash.filters.BlurFilter;

class EmitLight extends Sprite {
    private var rect:Rectangle;
    private var cx:uint = 0;
    private var cy:uint = 0;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var container:Sprite;
    private var particles:Array;
    private var color:uint;
    private var colorTrans:ColorTransform;
    private static var yellow:uint = 0xFFCC00;
    private static var green:uint = 0x008800;
    private static var red:uint = 0xCC0000;
    private static var gold:uint = 0xFFCC66;
    private static var colors:Array = [yellow, green, red, gold];
    private static var blur:BlurFilter;
    private static var point:Point = new Point();
    private var id:uint = 0;

    public function EmitLight(r:Rectangle) {
        rect = r;
        cx = rect.x + rect.width/2;
        cy = rect.y + rect.height/2;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        container = new Sprite();
        addChild(container);
        particles = new Array();
        colorTrans = new ColorTransform();
        colorTrans.color = 0xFFFFFF;
        blur = new BlurFilter(8, 8, 3);
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    public function stop():void {
        removeEventListener(Event.ENTER_FRAME, update);
    }
    private function update(evt:Event):void {
        create();
        bitmapData.lock();
        for (var n:uint = 0; n < particles.length; n++) {
            var particle:ParticleLight = particles[n];
            particle.update();
            particle.scale = particle.alpha = particle.power;
            if (particle.power < 0) {
                container.removeChild(particle);
                particles.splice(n, 1);
                particle = null;
            }
        }
        color = colors[uint(id/40)%colors.length];
        colorTrans.color = color;
        bitmapData.draw(container, null, colorTrans, BlendMode.SCREEN, null, true);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
        id ++;
    }
    private function create():void {
        var particle:ParticleLight = new ParticleLight(10, 0xFFFFFF);
        particle.x = cx + (Math.random() - 0.5)*60;
        particle.y = cy + (Math.random() - 0.5)*40;
        particle.angle = Math.random()*360;
        particle.speed = Math.random()*2 + 4;
        particle.power = 1;
        particle.setup();
        particle.blendMode = BlendMode.ADD;
        container.addChild(particle);
        particles.push(particle);
    }

}


//////////////////////////////////////////////////
// ParticleLightクラス
//////////////////////////////////////////////////

import flash.display.Shape;

class ParticleLight extends Shape {
    private var radius:uint = 10;
    private var color:uint = 0xFFFFFF;
    public var angle:Number = 0;
    public var speed:Number = 0;
    private var vx:Number = 0;
    private var vy:Number = 0;
    public var power:Number = 0;
    private static var radian:Number = Math.PI/180;
    private static var friction:Number = 0.96;
    private static var deceleration:Number = 0.025;
    private var _scale:Number = 1;

    public function ParticleLight(r:uint = 10, c:uint = 0xFFFFFF) {
        radius = r;
        color = c;
        draw();
    }

    private function draw():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
    public function setup():void {
        vx = speed*Math.cos(angle*radian);
        vy = speed*Math.sin(angle*radian);
    }
    public function update():void {
        x += vx;
        y += vy;
        vx *= friction;
        vy *= friction;
        power -= deceleration;
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }

}


//////////////////////////////////////////////////
// RandomTextクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.filters.DropShadowFilter;

class RandomText extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var msgs:Array;
    private var msg:String;
    private var turns:uint;
    private var turn:uint = 0;
    private var position:int = 0;
    private var display:String = "";
    private var source:String = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!?#$%&/+-=;_:";
    private var timer:Timer;
    private static var interval:uint = 15;
    private static var changes:uint = 5;
    private static var waitTime:uint = 1000;
    private static var tColor:uint = 0xFFFFFF;
    public static const COMPLETE:String = Event.COMPLETE;

    public function RandomText() {
        init();
    }
    private function init():void {
        txt = new TextField();
        txt.width = 200;
        addChild(txt);
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        txt.autoSize = TextFieldAutoSize.LEFT;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 18;
        tf.align = TextFormatAlign.LEFT;
        txt.defaultTextFormat = tf;
        txt.textColor = tColor;
        filters = [new DropShadowFilter(1, 90, 0x000000, 0.4, 4, 4, 2, 3, false, false)];
    }
    public function setup(list:Array):void {
        stop();
        msgs = list;
        turns = msgs.length;
        turn = 0;
        msg = msgs[turn];
        position = 0;
        txt.text = "";
        display = "";
        //visible = true;
    }
    public function start():void {
        startin();
    }
    public function stop():void {
        //visible = false;
        if (timer) {
            stopin();
            stopout();
            timer.stop();
            timer.removeEventListener(TimerEvent.TIMER_COMPLETE, wait);
        }
        turn = 0;
        if (msgs) msg = msgs[turn];
        position = 0;
        txt.text = "";
        display = "";
    }
    private function startin():void {
        timer = new Timer(interval, changes);
        timer.addEventListener(TimerEvent.TIMER, search, false, 0, true);
        timer.addEventListener(TimerEvent.TIMER_COMPLETE, show, false, 0, true);
        timer.start();
    }
    private function stopin():void {
        timer.stop();
        timer.removeEventListener(TimerEvent.TIMER, search);
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, show);
    }
    private function startout():void {
        timer = new Timer(interval, changes);
        timer.addEventListener(TimerEvent.TIMER, search, false, 0, true);
        timer.addEventListener(TimerEvent.TIMER_COMPLETE, hide, false, 0, true);
        timer.start();
    }
    private function stopout():void {
        timer.stop();
        timer.removeEventListener(TimerEvent.TIMER, search);
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, hide);
    }
    private function search(evt:TimerEvent):void {
        txt.text = display + source.charAt(Math.floor(Math.random()*source.length));
    }
    private function show(evt:TimerEvent):void {
        display = msg.substr(0, position + 1);
        txt.text = display;
        if (position < msg.length - 1) {
            position ++;
            startin();
        } else {
            stopin();
            if (turn < turns - 1) {
                timer = new Timer(waitTime, 1);
                timer.addEventListener(TimerEvent.TIMER_COMPLETE, wait, false, 0, true);
                timer.start();
            } else {
                dispatchEvent(new Event(RandomText.COMPLETE));
            }
        }
    }
    private function hide(evt:TimerEvent):void {
        display = msg.substr(0, position + 1);
        txt.text = display;
        if (turn < turns - 1) {
            if (position >= 0) {
                position --;
                startout();
            } else {
                exchange();
            }
        }
    }
    private function wait(evt:TimerEvent):void {
        timer.stop();
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, wait);
        startout();
    }
    private function exchange():void {
        turn ++;
        msg = msgs[turn];
        position = 0;
        startin();
    }

}


//////////////////////////////////////////////////
// Piyoクラス
//////////////////////////////////////////////////

//////////////////////////////////////////////////
// FlareMapクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.filters.BlurFilter;
import flash.display.BlendMode;

class FlareMap extends Sprite {
    private var rect:Rectangle;
    private var fire:Rectangle;
    private var flare:BitmapData;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var rPalette:Array;
    private var gPalette:Array;
    private var bPalette:Array;
    private static var point:Point = new Point(0, 0);
    private var speed:Point = new Point(0, -6);
    private var unit:uint = 8;
    private var segments:uint = 8;
    private var blur:BlurFilter;
    private var mapList:Array;
    public var offset:Object = {x: 0, y: 0};
    private var faded:uint = 0;
    public static const COMPLETE:String = Event.COMPLETE;

    public function FlareMap(r:Rectangle) {
        rect = r;
        initialize();
        draw();
    }

    public function setup(s:uint = 6, u:uint = 8, seg:uint = 8):void {
        speed.y = - s;
        unit = u;
        segments = seg;
    }
    public function set map(list:Array):void {
        mapList = list;
    }
    private function initialize():void {
        rPalette = new Array();
        gPalette = new Array();
        bPalette = new Array();
        for (var n:uint = 0; n < 256; n++) {
            var luminance:uint = (n < 128) ? n*2 : 0;
            var rgb:Object = ColorUtil.HLS2RGB(n*360/256, luminance, 100);
            var color:uint = rgb.r << 16 | rgb.g << 8 | rgb.b;
            rPalette[n] = color;
            gPalette[n] = 0;
            bPalette[n] = 0;
        }
        blur = new BlurFilter(2, 8, 3);
        blendMode = BlendMode.ADD;
    }
    private function draw():void {
        fire = new Rectangle(0, 0, rect.width, rect.height + 10);
        flare = new BitmapData(fire.width, fire.height, false, 0xFF000000);
        bitmapData = new BitmapData(rect.width, rect.height, false, 0xFF000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        bitmap.x = - rect.width*0.5;
        bitmap.y = - rect.height;
        bitmap.cacheAsBitmap = true;
        cacheAsBitmap = true;
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, apply, false, 0, true);
    }
    public function stop():void {
        removeEventListener(Event.ENTER_FRAME, apply);
        faded = 0;
        addEventListener(Event.ENTER_FRAME, clear, false, 0, true);
    }
    private function apply(evt:Event):void {
        if (!mapList) return;
        flare.lock();
        bitmapData.lock();
        for (var n:uint = 0; n < segments; n++) {
            var id:uint = Math.random()*mapList.length;
            var px:int = mapList[id].x + offset.x;
            var py:int = mapList[id].y + offset.y;
            var range:Rectangle = new Rectangle(px, py, unit, 2)
            flare.fillRect(range, 0xFFFFFF);
        }
        flare.applyFilter(flare, fire, speed, blur);
        bitmapData.paletteMap(flare, rect, point, rPalette, gPalette, bPalette);
        flare.unlock();
        bitmapData.unlock();
    }
    private function clear(evt:Event):void {
        faded ++;
        flare.lock();
        bitmapData.lock();
        flare.applyFilter(flare, fire, speed, blur);
        bitmapData.paletteMap(flare, rect, point, rPalette, gPalette, bPalette);
        if (faded > 20) {
            bitmapData.fillRect(rect, 0x000000);
            removeEventListener(Event.ENTER_FRAME, clear);
            dispatchEvent(new Event(FlareMap.COMPLETE));
        }
        flare.unlock();
        bitmapData.unlock();
    }
    private function createEggMask(target:Shape):void {
        var w:Number = rect.width;
        var h:Number = rect.height*1.5;
        target.graphics.beginFill(0xFFFFFF);
        target.graphics.moveTo(-w*0.5, -h*0.2);
        target.graphics.curveTo(-w*0.4, -h, 0, -h);
        target.graphics.curveTo(w*0.4, -h, w*0.5, -h*0.2);
        target.graphics.curveTo(w*0.5, 0, 0, 0);
        target.graphics.curveTo(-w*0.5, 0, -w*0.5, -h*0.2);
        target.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// DetectPixelsクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.IBitmapDrawable;

class DetectPixels {
    private var bd:IBitmapDrawable;
    private var rect:Rectangle;
    private var map:BitmapData;
    private var mapList:Array;
    private var accuracy:uint;
    private var threshold:uint = 0x80FFFFFF;
    private var offset:Object = {x: 0, y: 0};

    public function DetectPixels(a:uint = 1) {
        accuracy = a;
    }

    public function search(t:IBitmapDrawable, r:Rectangle, th:uint = 0x80FFFFFF, o:Object = null):void {
        bd = t;
        rect = r;
        threshold = th;
        if (o) offset = o;
        var w:uint = rect.width/accuracy;
        var h:uint = rect.height/accuracy;
        detect(w, h);
    }
    private function detect(w:uint, h:uint):void {
        map = new BitmapData(w, h, true, 0x00000000);
        var matrix:Matrix = new Matrix();
        matrix.translate(-rect.x, -rect.y);
        matrix.scale(1/accuracy, 1/accuracy);
        map.lock();
        map.draw(bd, matrix);
        map.unlock();
        mapList = new Array();
        for (var x:uint = 0; x < w; x++) {
            for (var y:uint = 0; y < h; y++) {
                var color:uint = map.getPixel32(x, y);
                if (color >= threshold) {
                    var px:int = x*accuracy + rect.x + offset.x;
                    var py:int = y*accuracy + rect.y + offset.y;
                    var point:Point = new Point(px, py);
                    mapList.push(point);
                }
            }
        }
    }
    public function pixels():Array {
        return mapList;
    }

}


//////////////////////////////////////////////////
// ColorUtilクラス
//////////////////////////////////////////////////

class ColorUtil {

    public function ColorUtil(){
    }

    public static function HLS2RGB(h:Number, l:Number, s:Number):Object{
        var max:Number, min:Number;
        
        h = (h<0)? h % 360+360 : (h>=360)? h%360: h;
        l = (l<0)? 0 : (l>100)? 100: l;
        s = (s<0)? 0 : (s>100)? 100: s;
        
        l *= 0.01;
        s *= 0.01;
        
        if(s==0){
            var val:Number = l * 255;
            return {r:val, g:val, b:val};
        }
        
        if( l < 0.5){
            max = l * (1+s) * 255
        }else{
            max = (l * (1-s) + s)*255
        }
        min = (2 * l)*255 - max;
        
        return _hMinMax2RGB(h, min, max);    //HSBとHLSの共通部分
    }
    private static function _hMinMax2RGB(h:Number, min:Number, max:Number):Object{
        var r:Number,g:Number,b:Number;
        var area:Number = Math.floor(h / 60);
                              
        switch( area){
            case 0:
                r = max
                //0 - 0, 60-255
                g = min+h * (max-min)/ 60;
                b = min
                break;
            case 1:
                r = max-(h-60) * (max-min)/60;
                g = max
                b = min
                break;
            case 2:
                r = min 
                g = max
                b = min+(h-120) * (max-min)/60;
                break;
            case 3:
                r = min
                g = max-(h-180) * (max-min)/60;
                b =max
                break;
            case 4:
                r = min+(h-240) * (max-min)/60;
                g = min
                b = max
                break;
            case 5:
                r = max
                g = min
                b = max-(h-300) * (max-min)/60;
                break;
            case 6:
                r = max
                //0 - 0, 60-255
                g = min+h  * (max-min)/ 60;
                b = min
                break;
        }
        
        r = Math.min(255, Math.max(0, Math.round(r)))
        g = Math.min(255, Math.max(0, Math.round(g)))
        b = Math.min(255, Math.max(0, Math.round(b)))
        
        return {r:r, g:g, b:b}
    }

}