/**
 * Copyright szbzs2004 ( http://wonderfl.net/user/szbzs2004 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iMo8
 */

// http://forum.prog.hu/tudastar/174102/SetInterval+vagy+Timer.html
package {
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.TimerEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.utils.Timer;

    public class LogoRotation extends Sprite {

        private static const FRAMERATE:int = 50;
        private static const ANIMATION_FRAMES:int = 100;
        private static const STILL_FRAMES:int = 50;
        
        private var logo:Sprite;
        private var timer:Timer;
        
        public function LogoRotation():void {
            graphics.beginFill(0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            logo = makeLogo();
            logo.x = stage.stageWidth / 2;
            logo.y = stage.stageHeight / 2;
            addChild(logo);
            timer = new Timer(1000 / FRAMERATE);
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
        }

        private function timerHandler(e:TimerEvent):void {
            var relativeFrameCount:int = e.currentTarget.currentCount % (ANIMATION_FRAMES + STILL_FRAMES);
            if (relativeFrameCount <= ANIMATION_FRAMES) {
                var alpha:Number = relativeFrameCount * 180 / ANIMATION_FRAMES;
                if (alpha > 90)
                    alpha += 180;
                logo.rotationY = alpha;
            }
            e.updateAfterEvent();
        }
        
        private function makeLogo():Sprite {
            var s:Sprite = new Sprite();
            s.graphics.beginFill(0x800000);
            s.graphics.drawRect(-100, -80, 200, 160);
            s.graphics.endFill();
            var t:TextField = new TextField();
            t.autoSize = TextFieldAutoSize.CENTER;
            t.text = "LOGO";
            t.textColor = 0xffffff;
            t.scaleX = t.scaleY = 3;
            t.x = -t.width / 2;
            t.y = -t.height / 2;
            s.addChild(t);
            return s;
        }

    }
}