/**
 * Copyright Takayuki_Fukatsu ( http://wonderfl.net/user/Takayuki_Fukatsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iDUH
 */

package {
	import flash.events.ErrorEvent;
	import flash.events.MouseEvent;
	import flash.events.Event;
	import flash.display.ShaderPrecision;
	import flash.display.Graphics;
	import flash.geom.Point;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
    		public var sprites:Array;
        public function FlashTest() {
        		//initialize interface
        		sprites = [];
        		for(var i:int=0; i<4; i++)
        		{
        			var sp:Sprite = new Sprite();
        			sp.x = 100 * i+90;
        			sp.y = 100 * i+90;
        			sp.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
        			var g:Graphics = sp.graphics;
        			g.beginFill(0x000000,1);
        			g.drawCircle(0,0,5);
        			addChild(sp);
        			sprites.push(sp);
        		}
            updateView()
        }
        
        protected function mouseDownHandler(e:Event):void
        {
        		e.currentTarget.startDrag();
        		e.currentTarget.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
        		e.currentTarget.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
        }
        
        protected function mouseMoveHandler(e:Event):void
        {
        		updateView()
        }
        
        protected function mouseUpHandler(e:Event):void
        {
        		e.currentTarget.stopDrag();
        }
        
        protected function updateView():void
        {
        		// write as3 code here..
        	    var pt0:Point = new Point(sprites[0].x,sprites[0].y);
        	    var pt1:Point = new Point(sprites[1].x,sprites[1].y);
        	    var pt2:Point = new Point(sprites[2].x,sprites[2].y);
        	    var pt3:Point = new Point(sprites[3].x,sprites[3].y);
        	    var g:Graphics = this.graphics
        	    g.clear();
        	   
        	   	//line
        	   	g.lineStyle(0,0x999999,1);
        	   	g.moveTo(pt0.x, pt0.y);
        	   	g.lineTo(pt3.x, pt3.y);
        	   	
        	   	//anchor 1
        	   	g.lineStyle(0,0xcccccc,1);
        	   	g.moveTo(pt0.x, pt0.y);
        	   	g.lineTo(pt1.x, pt1.y);
        	   	
        	   	//anchor 2
        	   	g.moveTo(pt2.x, pt2.y);
        	   	g.lineTo(pt3.x, pt3.y);
        	   	g.endFill();
        	   
        	   	//draw curve
        	   	g.lineStyle(0,0x990000,1);
        	   	var division:Number = 20;
        	   	var diff:Number = 1/division;
        	   	var n:Number= 1+diff;
        	    for(var i:Number=0; i<=n; i+=diff){
        			var pt:Point = pointOnBezeir3d(pt0,pt1,pt2,pt3, i);
        			trace(i);
        			if(i==0){
        				g.moveTo(pt.x, pt.y);
        			}else{
        				g.lineTo(pt.x, pt.y);
        			}
        	    }
        }
        
        /**
        * 3次ベジェ曲線上の点を求める
        * 始点、アンカー１、アンカー２、終点、位置(0-1.0)
        */
        public function pointOnBezeir3d(pt0:Point, pt1:Point, pt2:Point, pt3:Point, position:Number):Point{
        		var t:Number = position;
        		var nt:Number = 1.0-position;
        		var pt:Point = new Point()	
        		pt.x = pt0.x * Math.pow(nt, 3) + 3 * pt1.x * t *Math.pow(nt, 2) + 3 * pt2.x * Math.pow(t, 2) * nt + pt3.x * Math.pow(t, 3);
        		pt.y = pt0.y * Math.pow(nt, 3) + 3 * pt1.y * t *Math.pow(nt, 2) + 3 * pt2.y * Math.pow(t, 2) * nt + pt3.y * Math.pow(t, 3);            
			return pt
        }
    }
}