/**
 * Copyright TTI ( http://wonderfl.net/user/TTI )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/iDC3
 */

//displayObjectを指定したサイズのドット絵に変換テスト

package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.net.*;
    import flash.system.Security;
    
    [SWF(backgroundColor = 0x000000, width = 465, height = 465, frameRate = 1)]
    
    public class Main extends Sprite
    {
        private var  dotSize:int = 4;
        private var tf2:TextField = new TextField();
        private var loader:Loader;
        private var dotImage:CreateDotBmp;
        
        public function Main()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        public function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.BEST;
            
            //上部のインターフェースを作成
            var tfBg:Sprite = new Sprite();
            tfBg.graphics.beginFill(0x333333, 1);
            tfBg.graphics.drawRect(0, 0, stage.stageWidth, 38);
            stage.addChild(tfBg);
            
            var tf1:TextField = new TextField();
            stage.addChild(tf1);
            tf1.autoSize = TextFieldAutoSize.LEFT;
            tf1.text = "ドットのサイズ(1~20を入力)";
            tf1.x = 20;
            tf1.y = 9;
            
            var tfm1:TextFormat = new TextFormat(null, 12, 0xffffff);
            tf1.defaultTextFormat = tfm1;
            tf1.setTextFormat(tfm1);
            
            stage.addChild(tf2);
            tf2.border = true;
            tf2.background = true;
            tf2.backgroundColor = 0xffffff;
            tf2.maxChars = 2;
            tf2.restrict = "0-9";
            tf2.type = TextFieldType.INPUT;
            tf2.text = String(dotSize);
            tf2.width = 20;
            tf2.height = 20;
            tf2.x = tf1.x + tf1.width + 10;
            tf2.y = tf1.y;
            
            var tfm2:TextFormat = new TextFormat(null, 12, 0x333333);
            tf2.defaultTextFormat = tfm2;
            tf2.setTextFormat(tfm2);
            
            var btn:NormalBtn = new NormalBtn(60, 20, "描写する");
            stage.addChild(btn);
            btn.x = tf2.x + tf2.width + 20;
            btn.y = tf2.y;
            btn.addEventListener(MouseEvent.CLICK, drawDotImage);
            
            
            
            //読み込んだ画像のプロパティにアクセスするためにcrossdomainを読みこむ
            Security.allowDomain("assets.wonderfl.net");
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
            
            //画像のURL
            var url:String = "http://assets.wonderfl.net/static/tmp/related_images/69bd2e803b44cbf506ee264983fd1a4f327db804m";
            
            //画像をロード
            var urlReq:URLRequest = new URLRequest(url);
            loader = new Loader();
            loader.load(urlReq);
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onComplete);
            stage.addChild(loader);
            loader.x = 20;
            loader.y = 130;
            
            
            //画像の説明テキスト
            var tf_img1:TextField = new TextField();
            stage.addChild(tf_img1);
            tf_img1.x = loader.x;
            tf_img1.y = loader.y + 205;
            tf_img1.text = "元の画像";
            tf_img1.defaultTextFormat = tfm1;
            tf_img1.setTextFormat(tfm1);
            tf_img1.autoSize = TextFieldAutoSize.LEFT;
            
            var tf_img2:TextField = new TextField();
            stage.addChild(tf_img2);
            tf_img2.x = tf_img1.x + 220;
            tf_img2.y = tf_img1.y;
            tf_img2.text = "変換後の画像";
            tf_img2.defaultTextFormat = tfm1;
            tf_img2.setTextFormat(tfm1);
            tf_img2.autoSize = TextFieldAutoSize.LEFT;
        }
        
        
        /**
         * 元画像のロードが終了すると、ドット変換を実行
         * @param    $e
         */
        private function onComplete($e:Event):void
        {
            drawDotImage();
        }
        
        /**
         * 元画像をドットに変換
         * @param    $e
         */
        private function drawDotImage($e:MouseEvent = null):void
        {
            dotSize = int(tf2.text);
            if (dotSize < 1) dotSize = 1;
            else if (dotSize > 10) dotSize = 10;
            tf2.text = String(dotSize);
            
            if ($e != null) stage.removeChildAt(stage.numChildren-1);
            
            var dotImage:CreateDotBmp = new CreateDotBmp(loader, dotSize);
            stage.addChild(dotImage);
            dotImage.x = loader.x + loader.width + 20;
            dotImage.y = loader.y;
        }
        
    }
}


//-----------------------------------
// ドット画像作成用クラス
//-----------------------------------
import flash.display.*;
import flash.events.*;
import flash.geom.Matrix;
import flash.geom.Rectangle;
class CreateDotBmp extends Bitmap
{
   /**
     * ドット画像作成用クラス
     * @param    $obj 元の画像
     * @param    $size ドットのサイズ
     * @param    $centerFlag リターンするbitamapの基準点を真ん中にするか
     */
    public function CreateDotBmp($obj:DisplayObject, $size:int, $centerFlag:Boolean = false)
    {
        //受け取ったobjをbitmapdataにする
        var bmd : BitmapData = new BitmapData( $obj.width , $obj.height , true , 0x00000000);
        
        var moveX:int = ($centerFlag)? int($obj.width / 2) : 0;
        var moveY:int = ($centerFlag)? int($obj.height / 2) : 0;
        bmd.draw($obj, new Matrix(1,0,0,1,moveX,moveY));
        
        //縦横のドット数
        var dotNumW:int = Math.ceil($obj.width / $size);
        var dotNumH:int = Math.ceil($obj.height / $size);
        
        //ドットを書くbitmapdata
        var bmd2 : BitmapData = new BitmapData( $obj.width , $obj.height , true , 0x00000000);
        
        //ドットの描写
        bmd2.lock();
        for(var i:int=0; i<dotNumH; i++)
        {
            for(var k:int=0; k<dotNumW; k++)
            {
                //ドットとなる中心の色を取得
                var dotColor:uint = bmd.getPixel32(int($size * k + int($size / 2)), int($size * i + int($size / 2)));
                
                //ドット描写
                var rect:Rectangle = new Rectangle(int($size * k), int($size * i), $size, $size);
                bmd2.fillRect(rect , dotColor);
            }
        }
        bmd2.unlock();
        
        this.bitmapData = bmd2;
    }
    
    
    /**
     * ステージからremoveされると全てのイベントリスナーと要素を削除。
     * @param    $e
     */
    private function destroy(e:Event):void
    {
        //イベントリスナーの削除
        removeEventListener(Event.REMOVED_FROM_STAGE, destroy );
        
        //メモリ開放
        this.bitmapData.dispose();
    }
}




//-----------------------------------
// ボタン作成用クラス
//-----------------------------------
import flash.display.*;
import flash.text.*;
class NormalBtn extends Sprite
{
    public function NormalBtn($w:Number, $h:Number, $label:String):void
    {
        this.graphics.lineStyle(1, 0x777777, 1);
        this.graphics.beginFill(0xdddddd, 1);
        this.graphics.drawRect(0, 0, $w, $h);
        this.graphics.endFill();
        
        var tf:TextField = new TextField();
        addChild(tf);
        tf.text = $label;
        tf.autoSize = TextFieldAutoSize.LEFT;
        tf.x = int(($w - tf.width ) / 2);
        
        var cover:Sprite = new Sprite();
        cover.graphics.beginFill(0xffffff, 0);
        cover.graphics.drawRect(0, 0, $w, $h);
        cover.graphics.endFill();
        addChild(cover);
        
        this.buttonMode = true;
    }
}