/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/hpfE
 */

// forked from ProjectNya's candle + fire + TwinkleEffect [Christmas]
////////////////////////////////////////////////////////////////////////////////
// candle + fire + TwinkleEffect [Christmas]
//
// [AS3.0] DetectPixelsクラスに挑戦！ (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1135
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private static var basePath:String = "http://assets.wonderfl.net/images/related_images/";
        private static var candlePath:String = "e/ed/edac/edacc14dd5fdd2d007f924c08230d2f2360ce50c";
        private static var filePath:String = "0/0d/0d7d/0d7d9691c1752968ea72c63754a739b6370d4d83";
        private var loader:Loader;
        private var detection:DetectPixels;
        private static var accuracy:uint = 2;
        private var threshold:uint = 0xFF808080;
        private var twinkle:TwinkleEffect;

        public function Main() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.INIT, initialize, false, 0, true);
            loader.load(new URLRequest(basePath + filePath), new LoaderContext(true));
            addChild(loader);
            loader.x = 32;
            loader.y = 32;
            loader.alpha = 0.2;
        }
        private function initialize(evt:Event):void {
            evt.target.removeEventListener(Event.INIT, initialize);
            var content:Bitmap = Bitmap(evt.target.content);
            detection = new DetectPixels(accuracy);
            var area1:Rectangle = new Rectangle(20, 60, 360, 100);
            detection.search(content, area1, threshold);
            var map1:Array = detection.pixels();
            var area2:Rectangle = new Rectangle(20, 160, 360, 90);
            detection.search(content, area2, threshold);
            var map2:Array = detection.pixels();
            var area3:Rectangle = new Rectangle(150, 280, 100, 50);
            detection.search(content, area3, threshold);
            var map3:Array = detection.pixels();
            //
            var map:Array = map2.concat(map1).concat(map3);
            //
            var rect:Rectangle = new Rectangle(0, 0, 400, 400);
            twinkle = new TwinkleEffect(rect, map);
            addChild(twinkle);
            twinkle.x = 32;
            twinkle.y = 32;
            twinkle.setup(100, 10);
            draw();
        }
        private function draw():void {
            var loader:PhotoLoader = new PhotoLoader();
            loader.addEventListener(PhotoLoader.INIT, loaded, false, 0, true);
            loader.load(basePath + candlePath);
        }
        private function loaded(evt:Event):void {
            evt.target.removeEventListener(PhotoLoader.INIT, loaded);
            var candle:Bitmap = Bitmap(evt.target.content);
            addChild(candle);
            candle.x = 172;
            candle.y = 345;
            //
            var fire:Fire = new Fire();
            addChild(fire);
            fire.x = 232;
            fire.y = 390;
        }

    }

}


//////////////////////////////////////////////////
// TwinkleEffectクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Rectangle;
import flash.geom.Matrix;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundLoaderContext;
import flash.media.SoundMixer;
import flash.utils.ByteArray;
import flash.net.URLRequest;
import flash.system.Security;

class TwinkleEffect extends Sprite {
    private var rect:Rectangle;
    private var map:Array;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private static var radius:uint = 10;
    private var interval:uint = 100;
    private var life:uint = 10;
    private var particles:Array;
    private static var white:uint = 0xFFFFFF;
    private static var green:uint = 0x00CC00;
    private static var red:uint = 0xFF0033;
    private static var gold:uint = 0xFFCC33;
    private static var sliver:uint = 0xCCCCCC;
    private static var colors:Array = [white, white, green, red, gold, gold, sliver, sliver];
    private var units:Array = [30, 30, 45, 45, 45, 60];
    private static var radian:Number = Math.PI/180;
    private var timer:Timer;
    private static var policyPath:String = "";
    private var sound:Sound;
    private var channel:SoundChannel;
    private static var soundPath:String = "";
    private var byteArray:ByteArray;
    private static var channels:uint = 256;
    private var factors:uint = 0;

    public function TwinkleEffect(r:Rectangle, m:Array) {
        rect = r;
        map = m;
        init();
    }

    private function init():void {
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        particles = new Array();
        //
        Security.loadPolicyFile(policyPath);
        sound = new Sound();
        sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
        sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
        byteArray = new ByteArray();
    }
    public function setup(i:uint = 100, l:uint = 10):void {
        interval = i;
        life = l;
    }
    private function complete(evt:Event):void {
        evt.target.removeEventListener(Event.COMPLETE, complete);
        start();
    }
    private function start():void {
        timer = new Timer(interval);
        timer.addEventListener(TimerEvent.TIMER, tick, false, 0, true);
        timer.start();
        channel = sound.play(0, 1000);
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function stop():void {
        timer.stop();
        removeEventListener(Event.ENTER_FRAME, update);
    }
    private function tick(evt:TimerEvent):void {
        SoundMixer.computeSpectrum(byteArray, true, factors);
        for (var c:uint = 0; c < 2; c++) {
            for (var t:uint = 0; t < channels; t++) {
                var p:Number = byteArray.readFloat();
                if (p > 0) create(p);
            }
        }
    }
    private function create(p:Number):void {
        //var id:uint = uint(Math.random()*map.length);
        var id:uint = uint(map.length*p)%map.length;
        var px:Number = map[id].x;
        var py:Number = map[id].y;
        plot(px, py);
    }
    private function plot(px:Number, py:Number):void {
        var matrix:Matrix = new Matrix();
        matrix.translate(px - radius, py - radius);
        var color:uint = colors[uint(Math.random()*colors.length)];
        var particle:TwinkleParticle = new TwinkleParticle();
        particle.x = px;
        particle.y = py;
        particle.life = (Math.random()*0.5 + 0.5)*life;
        particle.matrix = matrix;
        particle.color = color;
        particle.unit = units[uint(Math.random()*units.length)];
        particles.push(particle);
        bitmapData.lock();
        draw(px, py, 0xFFFFFF, particle.life/life, particle.unit);
        bitmapData.unlock();
    }
    private function update(evt:Event):void {
        bitmapData.lock();
        bitmapData.fillRect(rect, 0x00000000);
        for (var n:uint = 0; n < particles.length; n++) {
            var particle:TwinkleParticle = particles[n];
            draw(particle.x, particle.y, particle.color, particle.life/life, particle.unit);
            particle.life --;
            if (particle.life < 0) {
                particles.splice(n, 1);
                particle = null;
            }
        }
        bitmapData.unlock();
    }
    private function draw(px:uint, py:uint, color:uint, percent:Number, unit:uint):void {
        var length:uint = uint(radius*percent);
        var argb:uint = 0xFF << 24 | color;
        for (var n:uint = 0; n < length; n++) {
            for (var a:uint = 0; a < 360; a+=unit) {
                var dx:Number = px + n*Math.cos(a*radian);
                var dy:Number = py + n*Math.sin(a*radian);
                bitmapData.setPixel32(dx, dy, argb);
            }
        }
    }

}


//////////////////////////////////////////////////
// TwinkleParticleクラス
//////////////////////////////////////////////////

import flash.geom.Matrix;

class TwinkleParticle {
    public var x:uint;
    public var y:uint;
    public var life:int;
    public var matrix:Matrix;
    public var color:uint;
    public var unit:uint;

    public function TwinkleParticle() {
    }

}


//////////////////////////////////////////////////
//    DetectPixelsクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.display.IBitmapDrawable;

class DetectPixels {
    private var bd:IBitmapDrawable;
    private var rect:Rectangle;
    private var map:BitmapData;
    private var mapList:Array;
    private var accuracy:uint;
    private var threshold:uint = 0x80FFFFFF;
    private var offset:Object = {x: 0, y: 0};

    public function DetectPixels(a:uint = 1) {
        accuracy = a;
    }

    public function search(t:IBitmapDrawable, r:Rectangle, th:uint = 0x80FFFFFF, o:Object = null):void {
        bd = t;
        rect = r;
        threshold = th;
        if (o) offset = o;
        var w:uint = rect.width/accuracy;
        var h:uint = rect.height/accuracy;
        detect(w, h);
    }
    private function detect(w:uint, h:uint):void {
        map = new BitmapData(w, h, true, 0x00000000);
        var matrix:Matrix = new Matrix();
        matrix.translate(-rect.x, -rect.y);
        matrix.scale(1/accuracy, 1/accuracy);
        map.lock();
        map.draw(bd, matrix);
        map.unlock();
        mapList = new Array();
        for (var y:uint = 0; y < h; y++) {
            for (var x:uint = 0; x < w; x++) {
                var color:uint = map.getPixel32(x, y);
                if (color >= threshold) {
                    var px:int = x*accuracy + rect.x + offset.x;
                    var py:int = y*accuracy + rect.y + offset.y;
                    var point:Point = new Point(px, py);
                    mapList.push(point);
                }
            }
        }
    }
    public function pixels():Array {
        return mapList;
    }

}


//////////////////////////////////////////////////
// Fireクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.events.Event;
import flash.filters.GradientGlowFilter;
import flash.filters.BitmapFilterType;
import flash.display.BlendMode;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;

class Fire extends Sprite {
    private var fire:Shape;
    private static var colors:Array = [0xFF0000, 0xFFFF00, 0xFFFFFF];
    private static var alphas:Array = [0, 0.75, 1];
    private static var ratios:Array = [0, 192, 255];
    private var light:Shape;

    public function Fire() {
        init();
    }

    private function init():void {
        draw();
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function update(evt:Event):void {
        var angle:Number = 265 + Math.floor(Math.random()*10);
        var blurX:Number = 16 + Math.floor(Math.random()*4);
        var blurY:Number = 48 + Math.floor(Math.random()*8);
        var gradientGlowFilter:GradientGlowFilter = new GradientGlowFilter(16, angle, colors, alphas, ratios, blurX, blurY, 2, 3, BitmapFilterType.FULL, true);
        fire.filters = [gradientGlowFilter];
    }
    private function draw():void {
        createLight();
        createFire();
    }
    private function createLight():void {
        light = new Shape();
        addChild(light);
        light.y = -60;
        var _colors:Array = [0xFFFFFF, 0xFFFF00];
        var _alphas:Array = [0.6, 0];
        var _ratios:Array = [0, 255];
        var radius:uint = 200;
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(radius*2, radius*2, 0, -radius, -radius);
        light.graphics.beginGradientFill(GradientType.RADIAL, _colors, _alphas, _ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        light.graphics.drawCircle(0, 0, radius);
        light.graphics.endFill();
    }
    private function createFire():void {
        fire = new Shape();
        addChild(fire);
        var w:uint = 30;
        var h:uint = 90;
        fire.graphics.beginFill(0xFFFFFF);
        fire.graphics.moveTo(-w*0.5, -h*0.2);
        fire.graphics.curveTo(-w*0.4, -h, 0, -h);
        fire.graphics.curveTo(w*0.4, -h, w*0.5, -h*0.2);
        fire.graphics.curveTo(w*0.5, 0, 0, 0);
        fire.graphics.curveTo(-w*0.5, 0, -w*0.5, -h*0.2);
        fire.graphics.endFill();
        fire.blendMode = BlendMode.SCREEN;
        var gradientGlowFilter:GradientGlowFilter = new GradientGlowFilter(16, 270, colors, alphas, ratios, 18, 52, 2, 3, BitmapFilterType.FULL, true);
        fire.filters = [gradientGlowFilter];
    }

}


//////////////////////////////////////////////////
// PhotoLoaderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.LoaderContext;

class PhotoLoader extends Sprite {
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:*;
    private var smoothing:Boolean;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function PhotoLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file), new LoaderContext(true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(PhotoLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(PhotoLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(PhotoLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        if (smoothing) {
            content = Bitmap(info.content);
            content.smoothing = true;
        } else {
            content = info.content;
        }
        dispatchEvent(new Event(PhotoLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        addChild(loader);
        dispatchEvent(new Event(PhotoLoader.COMPLETE));
    }

}
