/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/h9At
 */

package {
    import flash.utils.ByteArray;
    import flash.display.Sprite;
    import flash.net.*;
    import flash.events.*;
    import flash.text.*;
    import flash.media.*;
    public class FlashTest extends Sprite {
        private var sampling:int = 2048;
        private var sound_obj:Sound;
        private var ch:SoundChannel;
        private var bytes:ByteArray;
        private var outSnd:Sound;
        public function FlashTest() {
            // write as3 code here..
            var s:Sprite = new Sprite();
            addChild(s);
            s.graphics.beginFill(0x0);
            s.graphics.drawRect(0,0,200,200);
            s.graphics.endFill();
            stage.addEventListener(KeyboardEvent.KEY_DOWN,onkey);
            // サウンドファイルのURL
            var url : URLRequest = new URLRequest("http://192.168.11.7/sound/a.mp3");
            sound_obj.addEventListener(Event.COMPLETE,onComplete);
            // サウンドオブジェクトの作成
            sound_obj = new Sound(url);
            // サウンドの再生
            ch = sound_obj.play();
            
            outSnd = new Sound();
            outSnd.addEventListener(SampleDataEvent.SAMPLE_DATA,onSample);
            
            
        }
        //サンプリングイベント
        private function onSample(e:SampleDataEvent):void{
            var i:int;
            var srcBuf:ByteArray = new ByteArray();
            var outBuf:ByteArray = e.data;
            
            var len:int = sound_obj.extract(srcBuf,sampling);
            // サウンドバッファが足りない場合は空白を埋める
            for(i=len;i < sampling;i++){
                srcBuf.writeFloat(0.0);
                srcBuf.writeFloat(0.0);
            }
            
            // サウンドデータを出力バッファにコピー
            var data:Number;
            srcBuf.position = 0;
            for(i=0;i < sampling;i++){
                // 左チャンネル
                data = srcBuf.readFloat();
                outBuf.writeFloat(data);            
                // 右チャンネル
                data = srcBuf.readFloat();
                outBuf.writeFloat(data);
            }
        }

        private function onComplete(e:Event):void{
            bytes = new ByteArray();
            var len:Number = sound_obj.extract(bytes,8192); 
            outSnd = new Sound();
            outSnd.addEventListener(SampleDataEvent.SAMPLE_DATA,onSample);
        }

        private function onkey(e:KeyboardEvent):void{
            ch = sound_obj.play(0);
        }

    }
}