/**
 * Copyright mchang ( http://wonderfl.net/user/mchang )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gdA2
 */

// forked from mchang's BitmapData の練習
/**
 * BitmapData と BlendMode の練習
 * マスク的な。
 * 透明な BitmapData を作成。
 */
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;

    [SWF(width="465", height="465", backgroundColor="#ffcccc", frameRate="60")]

    public class BitmapDataDraw2 extends Sprite
    {
        private var _circleBitmapData:BitmapData;
        private var _bitmapData:BitmapData;
        private var _bitmap:Bitmap;
        private var _shape:Shape;
        private var _radius:int = 10;

        public function BitmapDataDraw2()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        }
        
        private function addedToStageHandler(e:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            var circle:Shape = new Shape();
            circle.graphics.beginFill(0x000000);
            circle.graphics.drawCircle(200, 200, 200);
            circle.graphics.endFill();
            
            _circleBitmapData = new BitmapData(465, 465, true, 0x000000);    
            _circleBitmapData.draw(circle);

            // 描画先
            _bitmapData = new BitmapData(465, 465, true, 0x000000);    
            _bitmapData.copyChannel(_circleBitmapData, _circleBitmapData.rect, new Point(0,0), BitmapDataChannel.ALPHA, BitmapDataChannel.ALPHA);
            _bitmap = new Bitmap(_bitmapData);
            addChild(_bitmap);

            // ペン
            _shape = new Shape();
            _shape.graphics.beginFill(0xff0000);
            _shape.graphics.drawCircle(0, 0, _radius);
            _shape.graphics.endFill();
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
        }
        
        private function mouseDownHandler(e:MouseEvent):void
        {
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
        }
        private function mouseMoveHandler(e:MouseEvent):void
        {
            var matrix:Matrix = new Matrix(1, 0, 0, 1, _bitmap.mouseX, _bitmap.mouseY);
            var rectangle:Rectangle = new Rectangle(_bitmap.mouseX - _radius, _bitmap.mouseY - _radius, _radius * 2, _radius * 2);
            _bitmapData.draw(_shape, matrix, null, null, rectangle);
            _bitmapData.copyChannel(_circleBitmapData, _circleBitmapData.rect, new Point(0,0), BitmapDataChannel.ALPHA, BitmapDataChannel.ALPHA);
        }
        private function mouseUpHandler(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
        }
    }
}
