/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gLP9
 */

package {
    import flash.geom.Rectangle;
    import flash.geom.Matrix;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            floor = new BitmapData(1024, 1024, false, 0x808080);
            floor.perlinNoise(24,12, 6, 2, true, true);
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var floor:BitmapData;
        public var mat:Matrix = new Matrix();
        
        public var rendw:Number = 465 *0.5;
        
        public var camx:Number = 0;
        public var camy:Number = 0;
        
        public var wmx:Number = 0;
        public var wmy:Number = 0;
        
        public function onEnter(e:Event):void
        {
           var mx:Number; var my:Number;
           mx = stage.mouseX; my = stage.mouseY;
          // camx = mx-256; camy =my-256;
            
           if (mx < 40) { camx -= 16; }           if (mx > 400) { camx += 16; }
           if (my < 40) { camy -= 16; }           if (my > 400) { camy += 16; }
             
           if (camx < 0) { camx = 0;} if (camy < 0) { camy = 0;}  
           if (camx > 512) { camx = 512;} if (camy > 512) { camy = 512;} 
            
           mx -= rendw;
           wmy = (2*my - mx) * 0.5;
           wmx = mx + wmy; 
           wmx += camx; wmy += camy;
           
           var ax:Number; var ay:Number; var aw:Number;
           aw = 16;
           ax = Math.floor(wmx/aw)*aw;
           ay = Math.floor(wmy/aw)*aw;
           floor.fillRect(new Rectangle(ax,ay,aw,aw), Math.random()*0xffFFff);
            
           graphics.clear();
           graphics.lineStyle(2, 0);
           
           mat.identity();
           mat.a = 1;           mat.b = 0.5;
           mat.c = -1;          mat.d = 0.5;
           
           mat.tx = (camx-camy)*-1+rendw;
           mat.ty = ((camx*0.5)+(camy*0.5))*-1;
           
           graphics.beginBitmapFill(floor, mat, false, false);
            graphics.drawRect(0,0, 465, 465);
           graphics.endFill();
           
           drawVert(0,0, 0, 8);
           drawVert(wmx, wmy, 0, 8);
           
           drawVert(256,0, 0, 8);
           drawVert(0,256, 0, 8);
           drawVert(256,256, 0, 8);

        }//onenter
        
        public function drawVert(ax:Number, ay:Number,  az:Number, r:Number):void
        {
          var sx:Number; var sy:Number;
          ax -= camx; ay -= camy;
          
          sx = (ax - ay) + rendw;
          sy = (ax*0.5)+(ay*0.5) - az;
           
          graphics.drawCircle(sx, sy, r); 
            
        }//drawvert
        
        
        
    }//classend
}