/**
 * Copyright n0wri ( http://wonderfl.net/user/n0wri )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/gIW7
 */

// forked from n0wri's 【読み込み用】RayEffect(@see http://wonderfl.net/c/NspJ)
/**
 * @package inn.nowri.ka.rayeffect
 */
package {
	import flash.net.URLRequest;
	import net.wonderfl.utils.WonderflAPI;
	import flash.display.Sprite;
	import flash.utils.Dictionary;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.DisplayObjectContainer;
	import flash.geom.Point;
	import flash.geom.Rectangle;

	public class RayEffect extends Sprite
	{
		// ---------------------------------------------------------------------------------------------------------------------------------------------
		// Public Properties
		// ---------------------------------------------------------------------------------------------------------------------------------------------
		// ---------------------------------------------------------------------------------------------------------------------------------------------
		// Internal Properties
		// ---------------------------------------------------------------------------------------------------------------------------------------------
		private static const LEFT : String = "left";
		private static const RIGHT : String = "right";
		private static const UP : String = "up";
		private static const DOWN : String = "down";
		private static var childObj : Dictionary;
		// 新しい Dictionary オブジェクトを作成します。Dictionary オブジェクトからキーを削除するには、delete 演算子を使用します。
		{
		childObj = new Dictionary();
		}
		// ---------------------------------------------------------------------------------------------------------------------------------------------
		// Public Methods
		// ---------------------------------------------------------------------------------------------------------------------------------------------
		public function RayEffect(/*dum : DummyClass*/)
		{
			
			
		}

		public static function doContainer(targ : DisplayObjectContainer, obj : Object) : RaySprite
		{
			if (childObj[targ.name])
			{
				throw new Error("error");
			}
			;

			var prt : DisplayObjectContainer;
			var index : uint;

			if (targ.parent)
			{
				prt = targ.parent as DisplayObjectContainer;
				index = prt.getChildIndex(targ);
			}
			;

			var dummy : Sprite = new Sprite();
			dummy.addChild(targ);

			var rect : Rectangle = dummy.getRect(dummy.getChildAt(0));
			var bmd : BitmapData = ScreenCapture.capture(dummy.getChildAt(0), true, rect);

			dummy.removeChild(targ);
			dummy = null;

			if (prt)
			{
				prt.addChildAt(targ, index);
			}
			;

			var bmp : Bitmap = new Bitmap(bmd);
			var msk : Sprite = createMask(rect.width, rect.height);
			var raySprite : RaySprite = new RaySprite(rect, setBmdAr(bmd, obj, rect), bmp, msk);
			raySprite.name = "raysprite1";

			var len : uint = targ.numChildren;
			for (var i : uint = 0;i < len;i++)
			{
				targ.getChildAt(i).visible = false;
			}
			;
			targ.addChild(raySprite);
			raySprite.x = rect.x;
			raySprite.y = rect.y;

			return childObj[targ.name] = raySprite;
		}

		public static function bmData(targ : BitmapData, obj : Object = null) : RaySprite
		{
			var rect : Rectangle = new Rectangle(0, 0, targ.width, targ.height);

			var bmp : Bitmap = new Bitmap(targ);
			bmp.x = rect.x;
			bmp.y = rect.y;

			var msk : Sprite = createMask(rect.width, rect.height);
			msk.x = rect.x;
			msk.y = rect.y;

			return new RaySprite(rect, setBmdAr(targ, obj, rect), bmp, msk);
		}

		public static function returnContainer(targ : DisplayObjectContainer) : void
		{
			if (!childObj[targ.name])
			{
				throw new Error("error");
			}
			;
			var rs : RaySprite = targ.getChildByName("raysprite1") as RaySprite;
			returnBmData(rs);
			targ.removeChild(targ.getChildByName("raysprite1"));
			delete childObj[targ.name];
		}

		public static function returnBmData(targ : RaySprite) : void
		{
			targ.destroy();
		}

		// ---------------------------------------------------------------------------------------------------------------------------------------------
		// Internal Methods
		// ---------------------------------------------------------------------------------------------------------------------------------------------
		private static function setBmdAr(_bmd : BitmapData, obj : Object, rect : Rectangle) : Vector.<RayBmdObj>
		{
			var w : int = rect.width;
			var h : int = rect.height;

			var bmd2 : BitmapData;
			var bmdObj : RayBmdObj;

			var ww : int;
			var hh : int;
			var isReverse : Boolean;
			var isYoko : Boolean;
			var targetSize : int;

			var objW : int;
			var objH : int;
			var objX : int;
			var objY : int;
			var mskX : int;
			var mskY : int;

			if (!obj)
			{
				obj = {};
			}
			;

			var direction : String = (obj.direction) ? obj.direction : RIGHT;
			var offset : int = (obj.offset) ? obj.offset : 0;
			var random : Number = (obj.random) ? obj.random : 0;

			switch(direction)
			{
				case UP:
					ww = w;
					hh = 1;
					targetSize = h;
					isReverse = true;
					isYoko = false;
					break;
				case DOWN:
					ww = w;
					hh = 1;
					isReverse = false;
					isYoko = false;
					targetSize = h;
					break;
				case LEFT:
					ww = 1;
					hh = h;
					targetSize = w;
					isReverse = true;
					isYoko = true;
					break;
				case RIGHT:
					ww = 1;
					hh = h;
					isReverse = false;
					targetSize = w;
					isYoko = true;
					break;
			}
			;

			var j : uint;
			var k : uint;
			var ar : Vector.<RayBmdObj> = new Vector.<RayBmdObj>();
			var offs : int;
			for (var i : uint = 0;i < targetSize;i++)
			{
				if (isYoko)
				{
					if (isReverse)
					{
						j = (w - 1) - i;
						k = 0;

						offs = offset - int((offset * ((targetSize - j) / targetSize) ));
						objW = j + offs;
						objH = h;
						objX = 0 - offs;
						objY = 0;

						mskX = j;
						mskY = 0;
					}
					else
					{
						j = i;
						k = 0;
						offs = int((offset * ((targetSize - j) / targetSize) ));
						objW = (w - j) + offs;
						objH = h;
						objX = j;
						objY = 0;

						mskX = -w + objX;
						mskY = 0;
					}
				}
				else
				{
					if (isReverse)
					{
						j = 0;
						k = (h - 1) - i;

						objW = w;
						offs = offset - int((offset * ((targetSize - k) / targetSize) ));
						objH = k + offs;
						objX = j;
						objY = 0 - offs;

						mskX = 0;
						mskY = k;
					}
					else
					{
						j = 0;
						k = i;
						objW = w - j;
						offs = int((offset * ((targetSize - k) / targetSize) ));
						objH = (h - k) + offs;
						objX = j;
						objY = k;

						mskX = 0;
						mskY = -h + objY;
					}
				}

				bmd2 = new BitmapData(ww, hh, true, 0x00fff);
				bmd2.copyPixels(_bmd, new Rectangle(j, k, ww, hh), new Point(0, 0));
				bmdObj = new RayBmdObj(bmd2, objX, objY, objW, objH, mskX, mskY);
				var len : uint = ar.length;
				ar[len] = bmdObj;
			}
			ar.push(new RayBmdObj(null, 0, 0, 0, 0, 0, 0));
			return ar;
		}

		private static function createMask(w : Number, h : Number) : Sprite
		{
			var spr : Sprite = new Sprite();
			spr.graphics.beginFill(0xffffff);
			spr.graphics.drawRect(0, 0, w, h);
			return spr;
		}
	}
}


import flash.display.Sprite;
import flash.display.DisplayObject;
import flash.display.BitmapData;
import flash.events.Event;
import flash.geom.Matrix;
import flash.display.Bitmap;
//	import flash.display.BitmapData;
//	import flash.display.DisplayObjectContainer;
//	import flash.geom.Point;
	import flash.geom.Rectangle;
/***
 * 
 * @package inn.nowri.ka.rayeffect
 */
class DummyClass
{
}


/***
 * 
 * @package inn.nowri.ka.rayeffect.core
 */
class RayBmdObj
{
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	// Public Properties
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	// Internal Properties
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	private var _bmd : BitmapData;
	private var _x : Number;
	private var _y : Number;
	private var _w : Number;
	private var _h : Number;
	private var _mx : Number;
	private var _my : Number;

	// ---------------------------------------------------------------------------------------------------------------------------------------------
	// Public Methods
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	function RayBmdObj(bmd : BitmapData, xx : Number, yy : Number, w : Number, h : Number, mx : Number, my : Number)
	{
		_bmd = bmd;
		_x = xx;
		_y = yy;
		_w = w;
		_h = h;
		_mx = mx;
		_my = my;
	}

	public function destroy() : void
	{
		_bmd = null;
		_x = undefined;
		_y = undefined;
		_w = undefined;
		_h = undefined;
		_mx = undefined;
		_my = undefined;
	}

	//
	// getter setter
	//
	public function get bmd() : BitmapData
	{
		return _bmd;
	}

	public function get x() : Number
	{
		return _x;
	}

	public function get y() : Number
	{
		return _y;
	}

	public function get w() : Number
	{
		return _w;
	}

	public function get h() : Number
	{
		return _h;
	}

	public function get mx() : Number
	{
		return _mx;
	}

	public function get my() : Number
	{
		return _my;
	}
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	// Internal Methods
	// ---------------------------------------------------------------------------------------------------------------------------------------------
}

class RayEvent extends Event
{
	public static const UPDATE_PIXEL : String = "update_pixel";
	public static const UPDATE_RATE : String = "update_rate";

	public function RayEvent(type : String)
	{
		super(type);
	}

	public override function clone() : Event
	{
		return new RayEvent(type);
	}
}


class RaySprite extends Sprite
{
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	// Public Properties
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	// Internal Properties
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	private var _rect : Rectangle;
	/**
	 * ターゲットピクセル数最大
	 */
	private var _maxPixel : uint;
	private var _pixel : uint;
	private var _rate : Number;
	private var _bmdAr : Vector.<RayBmdObj>;
	private var efBmp : Bitmap;
	private var msk : Sprite;
	private var _isComplete : Boolean;

	// ---------------------------------------------------------------------------------------------------------------------------------------------
	// Public Methods
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	public function RaySprite(rect : Rectangle, bmdAr : Vector.<RayBmdObj>, captureBmp : Bitmap, _msk : Sprite)
	{
		init(rect, bmdAr, captureBmp, _msk);
	}

	public function destroy() : void
	{
		removeEventListener(RayEvent.UPDATE_RATE, updateRate);
		removeEventListener(RayEvent.UPDATE_PIXEL, updatePixel);
		_maxPixel = undefined;
		_pixel = undefined;
		_rate = undefined;
		efBmp.bitmapData = null;
		efBmp = null;
		msk = null;
		var len : uint = _bmdAr.length;
		for (var i : uint = 0;i < len;i++)
		{
			_bmdAr[i].destroy();
			_bmdAr[i] = null;
		}
		;
		_bmdAr = null;
	}

	//
	// getter setter
	//
	public function get maxPixel() : uint
	{
		return _maxPixel;
	}

	public function get pixel() : uint
	{
		return _pixel;
	}

	public function set pixel(pixel : uint) : void
	{
		_pixel = pixel;
		dispatchEvent(new RayEvent(RayEvent.UPDATE_PIXEL));
	}

	public function get rate() : Number
	{
		return _rate;
	}

	public function set rate(rate : Number) : void
	{
		_rate = rate;
		dispatchEvent(new RayEvent(RayEvent.UPDATE_RATE));
	}

	public function get isComplete() : Boolean
	{
		return _isComplete;
	}

	// ---------------------------------------------------------------------------------------------------------------------------------------------
	// Internal Methods
	// ---------------------------------------------------------------------------------------------------------------------------------------------
	private function init(rect : Rectangle, bmdAr : Vector.<RayBmdObj>, captureBmp : Bitmap, _msk : Sprite) : void
	{
		_rect = rect;
		_bmdAr = bmdAr;
		efBmp = new Bitmap();
		msk = _msk;
		_maxPixel = _bmdAr.length;

		addChild(captureBmp);
		addChild(msk);
		addChild(efBmp);
		captureBmp.mask = msk;
		addEventListener(RayEvent.UPDATE_RATE, updateRate);
		addEventListener(RayEvent.UPDATE_PIXEL, updatePixel);

		rate = 0;
	}

	private function updateRate(e : RayEvent) : void
	{
		var targetAr : int = int((_maxPixel - 1) * _rate);
		try
		{
			efBmp.bitmapData = _bmdAr[targetAr]["bmd"];
			efBmp.x = _bmdAr[targetAr]["x"];
			efBmp.y = _bmdAr[targetAr]["y"];
			efBmp.width = _bmdAr[targetAr]["w"];
			efBmp.height = _bmdAr[targetAr]["h"];
			msk.x = _bmdAr[targetAr]["mx"];
			msk.y = _bmdAr[targetAr]["my"];
		}
		catch(e : Error)
		{
		}
	}

	private function updatePixel(e : RayEvent) : void
	{
	}
}
/***
 * 
 * @package inn.nowri.ka.rayeffect.ext
 */
class ScreenCapture
{
	/**
	 * Captures the specified display object as bitmap data. If the <code>area</code> is not specified, the whole
	 * object is capture.
	 * 
	 * @param displayObject The display object to capture as bitmap data.
	 * @param transparent Whether the bitmap data returned should contain transparency if present in the original object.
	 *                    If this is false, the transparent pixels in the original object will be rendered as white.
	 * @param area The rectangular area of the display object to capture. If this is null, the whole object will be captured.
	 * 
	 * @return The bitmap data containing the specified region of the display object.
	 * 
	 * @example
	 * <pre>
	 * // the following captures the top left corner of the stage
	 * 
	 * var region:Rectangle = new Rectangle(0, 0, 100, 100);
	 * var capture:BitmapData = ScreenCapture.capture(stage, false, region);
	 * </pre>
	 */
	static public function capture(displayObject : DisplayObject, transparent : Boolean = true, area : Rectangle = null) : BitmapData
	{
		if (area == null)
		{
			area = new Rectangle(0, 0, displayObject.width, displayObject.height);
		}
		var color : uint = transparent ? 0x00FFFFFF : 0xFFFFFFFF;
		var image : BitmapData = new BitmapData(area.width, area.height, true, color);
		var matrix : Matrix = new Matrix();
		matrix.translate(-area.x, -area.y);
		image.draw(displayObject, matrix);
		return image;
	}

	/**
	 * Performs a <code>BitmapData.draw()</code> command, drawing the specified display object into new bitmap data.
	 * This simply handles the creation of the bitmap data and the call to <code>draw()</code>.
	 * 
	 * @param displayObject The display object to capture as bitmap data.
	 * 
	 * @return The bitmap data containing the pixel data of the display object.
	 * 
	 * @example
	 * <pre>
	 * // the following draws a sprite into new bitmap data
	 * 
	 * var capture:BitmapData = ScreenCapture.drawFromObject(sprite);
	 * </pre>
	 */
	static public function drawFromObject(displayObject : DisplayObject) : BitmapData
	{
		var bitmapData : BitmapData = new BitmapData(displayObject.width, displayObject.height, true, 0x00000000);
		bitmapData.draw(displayObject);
		return bitmapData;
	}
}
