/**
 * Copyright vasari ( http://wonderfl.net/user/vasari )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eTbh
 */

// forked from vasari's forked from: forked from: forked from: 3D Carousel
// forked from hacker_ya5pqi1m's forked from: forked from: 3D Carousel
// forked from hacker_ie_66xq7's forked from: 3D Carousel
// forked from clockmaker's 3D Carousel
// Flash 10 で被写界深度ネタ Z-sortつき
package{
  import flash.display.*
  import flash.events.*
  import flash.filters.BlurFilter;
  import flash.geom.*;
  
  [SWF(frameRate="60", width="465", height="465")]
  public class Main extends Sprite {

  public function Main() {
      
      var main :Sprite = Sprite(addChild(new Sprite()))
      main.x = stage.stageWidth / 2
      main.y = stage.stageHeight / 2
      var wrap :Sprite = Sprite(main.addChild(new Sprite()))
      
      var pp:PerspectiveProjection = root.transform.perspectiveProjection; 
      
      var objs:Array = []
      var objsNumber:int = 128
      for(var i:int=0; i<objsNumber; i++)
      {
        var sp: Sprite = Sprite(wrap.addChild(new Sprite()))
        sp.graphics.beginFill(0xFFFFFF * Math.random())
        sp.graphics.drawRect(-25, -25, 50, 50)
        sp.x = 200 * Math.sin( i * 360 / objsNumber * Math.PI / 180)
        sp.z = 200 * Math.cos( i * 360 / objsNumber * Math.PI / 180)
        
        objs.push(sp)
        
      }
      
      
      //precalcuting path coordinates
      var steps:int = 1024
      var stepX:Vector.<Number> = new Vector.<Number>(steps, false)
      var stepZ:Vector.<Number> = new Vector.<Number>(steps, false)

      var useObj:Sprite = objs[0] as Sprite
                      
      for(var s:int = 0; s < steps; s++)
	 {
                wrap.rotationY = s*360/steps
                var mtx:Matrix3D = useObj.transform.getRelativeMatrix3D(main)
           
                stepX[s] = mtx.position.x;
                stepZ[s] = mtx.position.z;
         }	
                        
      var depth:Number = stepZ[steps/2]
      var head:int = 0
      var stepFactor:Number = steps/objs.length

      
      stage.addEventListener(Event.ENTER_FRAME, function(e:Event):void
      {
        pp.projectionCenter = new Point(mouseX, mouseY)
        
        head = head + mouseX%16
        var ciclingHead:int
        
        var arr:Array = []
        for (var i:int=0; i<objs.length; i++) {
          var ele:Sprite = objs[i] as Sprite
          
          ciclingHead = (head + i*stepFactor) % steps
          ele.x = stepX[ciclingHead] 
          ele.z = stepZ[ciclingHead]
          
          arr.push( { ele:ele, z:Math.round(ele.z) } )
        
        }

        arr.sortOn("z", Array.NUMERIC | Array.DESCENDING)
        for (i=0; i<arr.length; i++) {
           ele = arr[i].ele as Sprite
           
           wrap.setChildIndex(ele, i)

        }
      })
    }
  }
}