/**
 * Copyright shaktool ( http://wonderfl.net/user/shaktool )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eOZm
 */

package {
    import flash.display.*;
    import flash.events.*;
    public class Proportions extends Sprite {
    	
    	public static const WIDTH: Number = 465;
    	public static const HEIGHT: Number = 465;
    	
        public function Proportions() {
            render(0.5);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
        
        private function onMouseMove(event: MouseEvent): void {
        	render(mouseX / WIDTH);
        }
        
        private function render(female: Number): void {
        	graphics.clear();
        	
        	var male: Number = 1 - female;
        	
        	var center: Number = WIDTH / 2;
        	
        	var width: Number;
        	var height: Number;
        	var offsetX: Number;
        	var offsetY: Number;
        	
        	width = 120 + female * 10;
        	height = 140 + female * 40;
        	offsetX = 0;
        	offsetY = -10 + female * 15;
        	graphics.beginFill(0xcc7744);
        	graphics.drawEllipse(center - width * 0.5 + offsetX, center - height * 0.5 + offsetY, width, height);
        	graphics.endFill();
        	
        	width = 105 + male * 15;
        	height = 105 + male * 35;
        	offsetX = 0;
        	offsetY = 0;
        	graphics.beginFill(0xeeccaa);
        	graphics.drawEllipse(center - width * 0.5 + offsetX, center - height * 0.5 + offsetY, width, height);
        	graphics.endFill();
        	
        	width = 10;
        	height = 10;
        	offsetX = 30;
        	offsetY = -5;
        	graphics.beginFill(0x000000);
        	graphics.drawEllipse(center - width * 0.5 + offsetX, center - height * 0.5 + offsetY, width, height);
        	graphics.drawEllipse(center - width * 0.5 - offsetX, center - height * 0.5 + offsetY, width, height);
        	graphics.endFill();
        	
        	offsetY = 30 + male * 5;
        	graphics.lineStyle(0);
        	graphics.moveTo(center - 20, center + offsetY);
        	graphics.lineTo(center + 20, center + offsetY);
        	graphics.lineStyle();
        }
    }
}
