/**
 * Copyright kinescript ( http://wonderfl.net/user/kinescript )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eI64
 */

// forked from Mae_ITR's forked from: forked from: OilPainting
// forked from zigxzag's forked from: OilPainting
// forked from k3lab's OilPainting

package {
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import flash.text.TextField;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.display.CapsStyle;
    import flash.display.LineScaleMode;

    import flash.filters.DropShadowFilter;
    
    import funnel.*;
    import funnel.ui.*;

    public class FlashTest extends Sprite {
        private var targetLayer:Sprite;
        private var layers:Array;
        private var layerNum:int = 4;
        private var currentLayerNum:int = 1;
        
        private var prevX:int;
        private var prevY:int;
        private var startPosX:int;
        private var startPosY:int;
        private var disX:Number;
        private var disY:Number;
        private var colors:Array = [0x000000,0x999999,0xCCCCCC,0xFFFFFF];
        private var color:uint = 0x000000;
        
        private var gio:Gainer;
        private var pinX:Pin;
        private var pinY:Pin;
        private var pinZ:Pin;
        
        public function FlashTest() {
            var filter:DropShadowFilter = new DropShadowFilter(0, 90);
	        layers = new Array();
    	    for (var i:int = 0; i < layerNum;i++ ) {
    	        layers[i] = new Sprite;
        		layers[i].filters = [filter];
        		layers[i].doubleClickEnabled = true;
        		addChild(layers[i]);
    	    }			
            targetLayer = layers[0];
            
            gio = new Gainer();	
            pinX = gio.analogInput(0);
            pinX.addFilter(new Scaler(0.3, 0.7, -stage.stageWidth/2, stage.stageWidth/2, Scaler.LINEAR, true));
            pinX.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            pinY = gio.analogInput(1);
            pinY.addFilter(new Scaler(0.3, 0.7, -stage.stageHeight/2, stage.stageHeight/2, Scaler.LINEAR, true));
            pinY.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            pinZ = gio.analogInput(2);
            pinZ.addFilter(new Scaler(0.3, 0.7, -90, 90, Scaler.LINEAR, true));
            pinZ.addFilter(new Convolution(Convolution.MOVING_AVERAGE));       			
            
            gio.button.addEventListener(ButtonEvent.PRESS, initialize);
            gio.button.addEventListener(ButtonEvent.LONG_PRESS, buttonLongPressed);
            
            
            /*
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, _move);
            stage.addEventListener(MouseEvent.DOUBLE_CLICK,onMouseDoubleClick);
            */
        }
        
        private function pinValueChangeDetected(e:PinEvent):void{
        		var distance:Number = Math.sqrt(Math.pow(prevX - startPosX, 2) + Math.pow(prevY - startPosY, 2))
            var a:Number = distance * 10 * (Math.pow(Math.random(), 2) - 0.5)
            var r:Number = Math.random() - 0.5
            var size:Number = Math.random() * 18 / distance
			
            disX = (prevX - startPosX) * Math.sin(0.5) + startPosX;
            disY = (prevY - startPosY) * Math.cos(0.5) + startPosY;
            startPosX = stage.stageWidth/2;
            startPosY = stage.stageHeight/2;
            prevX = pinX.value;
            prevY = pinY.value;
            
            targetLayer.graphics.moveTo(startPosX, startPosY);
            targetLayer.graphics.curveTo(disX,disY,prevX,prevY)
            targetLayer.graphics.lineStyle(((Math.random()+20/10-0.5)*size+(1-Math.random()+30/20-0.5)*size), color,1, false, LineScaleMode.NONE, CapsStyle.ROUND);	
            targetLayer.graphics.moveTo(startPosX + a, startPosY + a);
            targetLayer.graphics.lineTo(startPosX+r+a, startPosY+r+a);
            targetLayer.graphics.endFill();
        }
        
        private function initialize(e:ButtonEvent):void{
        		var timer:Timer = new Timer(5000, 1);
        		timer.addEventListener(TimerEvent.TIMER_COMPLETE, initHandler);
        		
        		pinX.addEventListener(PinEvent.CHANGE, pinValueChangeDetected);
        	
        		var txt:TextField = new TextField();
        		txt.x = 10;
        		txt.y = 10;
        		txt.width = 200;
        		txt.text = "Initializing.\nBrandish your gainer strongly.";
        		addChild(txt);
        		
        		gio.button.removeEventListener(ButtonEvent.PRESS, initialize);
        		gio.button.addEventListener(ButtonEvent.PRESS, buttonPressed);
        }
        
        private function initHandler(e:TimerEvent):void{
        		
        }
        
        private function buttonPressed(e:ButtonEvent):void{
            color = colors[currentLayerNum]
    			targetLayer = layers[currentLayerNum];
    		if (currentLayerNum >= layerNum - 1) {
    			currentLayerNum = 0;
    		}else {
    			currentLayerNum++;
    		}
        }
        
        private function buttonLongPressed(e:ButtonEvent):void{
            for (var i:int = 0; i < layerNum;i++ ) {
    		    layers[i].graphics.clear();
    	    }
        }

        private function _move(e:MouseEvent):void {
            
            
        }
    }
}