/**
 * Copyright chimanaco ( http://wonderfl.net/user/chimanaco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dvwy
 */

/**
* 何回かクリックしていたらそんな風に見えてきました。
*/
package 
{
	import flash.display.*;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import caurina.transitions.properties.CurveModifiers;
	import caurina.transitions.Tweener;
	
	[SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#000000")]
	public class Circle extends Sprite {
		private var _num:int = 360;
		private var _centerX:Number = stage.stageWidth/2;
		private var _centerY:Number = stage.stageHeight / 2;
		private var _r:uint = 200;
		private var _angle:Number = 0;
		private var _radians:Number;
		private var _speed:Number = 1;
		
		
		[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "0")]
		public function Circle() {
			CurveModifiers.init();
			moveCircle();
			stage.addEventListener(MouseEvent.CLICK, onClickHandler);
		}
		
		private function moveCircle():void {
			var sp:Sprite;
			for (var i:int = 0; i < _num; i++ ) {
				var color:ColorTransform = new ColorTransform();
				color.redMultiplier = 0.4;
				color.greenMultiplier = 0.3;
				color.blueMultiplier = 0;
				
				_radians = _angle * Math.PI / 180;
				
				sp = makeCircle();
				sp.transform.colorTransform = color;
				sp.x = -100;
				sp.y = -100;
				sp.scaleX = sp.scaleY = 0.1;
				
				_angle += _speed;
				
				Tweener.addTween(sp,
					{
						x : _centerX + Math.cos(_radians) * _r * Math.random(),
						y : _centerY + Math.sin(_radians) * _r * Math.random(),
						scaleY :1,
						scaleX :1,
						_bezier : [ { x : 950 * Math.random(), y : 300 * Math.random()
						} ],
						time : 2,
						transition : "easeInOutExpo",
						delay : i* 0.015
				});
			}
		}
		
		private function onClickHandler(e:MouseEvent):void {
			moveCircle();
		}
		
		private function makeCircle():Sprite {
			var color:int = 0xFFFFFF * Math.random();
			var r:Number = Math.floor(Math.random() * 10);
			var circle:Sprite = new Sprite;
			circle.graphics.beginFill(color);
			circle.graphics.drawCircle(0, 0, r);
			circle.graphics.endFill();
			addChild(circle);
			return circle;
		}
	}	
}