/**
 * Copyright hacker_lra4mj5w ( http://wonderfl.net/user/hacker_lra4mj5w )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cncm
 */

// forked from clockmaker's Box2D for Android Flash Player 10.1
package {
    import Box2D.Collision.Shapes.b2CircleDef;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.Joints.b2MouseJoint;
    import Box2D.Dynamics.Joints.b2MouseJointDef;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2World;
    
    import flash.display.Sprite;
    import flash.display.StageDisplayState;
    import flash.events.AccelerometerEvent;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.sensors.Accelerometer;
    
    import net.hires.debug.Stats;
    
    [SWF(width="800", height="480", frameRate="60", backgroundColor="0x808080")]
    public class Main extends Sprite {
        public static const OBJ_NUM:uint = 50;
        public static const OBJ_SIZE:int = 50;
        
        public function Main() {
            stage.frameRate = 60;
            // BackGround
            graphics.beginFill(0xFFFFFF);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            // for Fullscreen
            stage.fullScreenSourceRect = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
            scrollRect = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
            _container = new Sprite();
            addChildAt(_container, 0);
            // create Fullscreen Button
            cerateFullScreenBtn();
            // for performance check
            var stats:Stats = new Stats();
            stats.x = stage.stageWidth - 70;
            addChild(stats);
            // init Box2D World
            createBox2dWorld()
            // add Objects
            for (var i:int = 0; i < OBJ_NUM; i++) {
                addObjectAtContainer();
                addObjectAtBox2dWorld();
            }
            // init vars for drag
            arrayIndex = -1;
            isMouseDown = false;
            // for android
            if (Accelerometer.isSupported) {
                accel = new Accelerometer();
                accel.setRequestedUpdateInterval(100);
                accel.addEventListener(AccelerometerEvent.UPDATE, accelerometer_updateHandler);
            }
            // addEvent
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, stage_mouseDownHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, stage_mouseUpHandler);
        }
        private var _container:Sprite;
        private var accel:Accelerometer;
        private var arrayIndex:int;
        private var box3dSpapesArr:Vector.<b2Body> = new Vector.<b2Body>();
        private var count:int = 0;
        private var gravity:b2Vec2;
        private var isMouseDown:Boolean;
        private var m_draggedBody:b2Body;
        private var m_iterations:int;
        private var m_mouseJoint:b2MouseJoint;
        private var m_physScale:Number;
        private var m_timeStep:Number;
        private var m_wallHeight:Number;
        private var m_wallWidth:Number;
        private var m_world:b2World;
        private var mouseXWorldPhys:Number;
        private var mouseYWorldPhys:Number;
        private var objs:Vector.<Obj> = new Vector.<Obj>();
        private var worldHeight:Number;
        private var worldWidth:Number;
        
        private function accelerometer_updateHandler(event:AccelerometerEvent):void {
//            text.text = event.accelerationX + "\n" + event.accelerationY + "\n" + event.accelerationZ;
            gravity.x = event.accelerationX * -1 * 100;
            gravity.y = event.accelerationY * +1 * 100;
        }
        
        /**
         * Create Box2D World
         */
        private function createBox2dWorld():void {
            // init Box2D
            worldWidth = stage.stageWidth;
            worldHeight = stage.stageHeight;
            m_iterations = 2;
            m_timeStep = 1 / 30;
            m_timeStep = 1 / stage.frameRate;
            m_physScale = 60;
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-1000, -1000);
            worldAABB.upperBound.Set(1000, 1000);
            gravity = new b2Vec2(0, 30);
            m_world = new b2World(worldAABB, gravity, true);
            // craete wall for Box2D
            var wallShapeDef:b2PolygonDef = new b2PolygonDef();
            var wallBodyDef:b2BodyDef = new b2BodyDef();
            var wall:b2Body;
            m_wallWidth = stage.stageWidth;
            m_wallHeight = stage.stageHeight;
            // left wall
            wallShapeDef.SetAsBox(1 / m_physScale, m_wallHeight / m_physScale);
            wallBodyDef.position.Set(0, m_wallHeight / 2 / m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            // right wall
            wallBodyDef.position.Set(m_wallWidth / m_physScale, m_wallHeight / 2 / m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            // upper wall
            wallShapeDef.SetAsBox(m_wallWidth / 2 / m_physScale, 1 / m_physScale);
            wallBodyDef.position.Set(m_wallWidth / 2 / m_physScale, 0);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            // bottom wall
            wallBodyDef.position.Set(m_wallWidth / 2 / m_physScale, m_wallHeight / m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            wall.SetMassFromShapes();
        }
        
        /**
         * AddItem at Papervision3D World
         */
        private function addObjectAtContainer():void {
            var size:Number = OBJ_SIZE * Math.random() * 3 / 4 + OBJ_SIZE / 4;
            var obj:Obj = new Obj();
            obj.graphics.beginFill(0x0);
            obj.graphics.drawCircle(0, 0, size);
            obj.graphics.endFill();
            obj.graphics.beginFill(0x990000);
            obj.graphics.drawCircle(0, -size * 3 / 4, 3);
            obj.graphics.drawCircle(0, size * 3 / 4, 3);
            _container.addChild(obj);
            objs.push(obj);
            obj.extra = { radius: size, arrayPos: objs.length - 1 };
            obj.x = -50 * Math.random() + 100;
            obj.y = Math.random() * -200;
            obj.addEventListener(MouseEvent.MOUSE_DOWN, obj_mousePressHandler);
        }
        
        private function addObjectAtBox2dWorld():void {
            var obj:Obj = objs[ objs.length - 1 ];
            var circleShape:b2CircleDef = new b2CircleDef();
            circleShape.radius = obj.extra.radius / m_physScale;
            circleShape.density = 1;
            circleShape.friction = 0.9;
            circleShape.restitution = 0.7;
            var bodyDef:b2BodyDef = new b2BodyDef();
            bodyDef.position.Set((obj.x + worldWidth / 2) / m_physScale, (obj.y + worldHeight / 2) / m_physScale);
            var body:b2Body = m_world.CreateBody(bodyDef);
            body.CreateShape(circleShape);
            body.SetUserData(obj);
            body.SetMassFromShapes();
            box3dSpapesArr.push(body);
        }
        
        /**
         * get mouse position, and convert box2d scale
         */
        private function updateMouseWorld():void {
            var mx:Number = mouseX;
            var my:Number = mouseY;
            mx = mx > 0 ? mx > 800 ? 800 : mx : 0;
            my = my > 0 ? my > 480 ? 480 : my : 0;
            mouseXWorldPhys = mx / m_physScale;
            mouseYWorldPhys = my / m_physScale;
        }
        
        /**
         * Enter Frame
         * @param    event
         */
        private function enterFrameHandler(event:Event):void {
            count++;
            // update Box2D step
            if (count % 3 == 0)
                updateMouseWorld(); // for android performance
            mouseDrag();
            m_world.Step(m_timeStep, m_iterations);
            // sync position from Box2D
            for (var bb:b2Body = m_world.GetBodyList(); bb; bb = bb.GetNext()) {
                if (bb.GetUserData() is Obj) {
                    bb.GetUserData().x = bb.GetPosition().x * m_physScale;
                    bb.GetUserData().y = bb.GetPosition().y * m_physScale;
                    bb.GetUserData().rotationZ = -bb.GetAngle() * (180 / Math.PI);
                }
            }
        }
        
        /**
         * Drag And Drop
         */
        private function mouseDrag():void {
            if (isMouseDown && !m_mouseJoint) {
                m_draggedBody = null;
                if (arrayIndex > -1)
                    m_draggedBody = box3dSpapesArr[ arrayIndex ];
                if (m_draggedBody) {
                    var md:b2MouseJointDef = new b2MouseJointDef();
                    md.body1 = m_world.GetGroundBody();
                    md.body2 = m_draggedBody;
                    md.target.Set(mouseXWorldPhys, mouseYWorldPhys);
                    md.maxForce = 100000 * m_draggedBody.GetMass();
                    md.timeStep = m_timeStep;
                    m_mouseJoint = m_world.CreateJoint(md) as b2MouseJoint;
                    m_draggedBody.WakeUp();
                }
            }
            if (!isMouseDown) {
                if (m_mouseJoint) {
                    m_world.DestroyJoint(m_mouseJoint);
                    m_mouseJoint = null;
                }
            }
            if (m_mouseJoint) {
                var p2:b2Vec2 = new b2Vec2(mouseXWorldPhys, mouseYWorldPhys);
                m_mouseJoint.SetTarget(p2);
            }
        }
        
        private function stage_mouseDownHandler(event:MouseEvent):void {
            isMouseDown = true;
        }
        
        private function stage_mouseUpHandler(event:MouseEvent):void {
            isMouseDown = false;
            arrayIndex = -1;
        }
        
        private function obj_mousePressHandler(e:MouseEvent):void {
            arrayIndex = (e.target as Obj).extra.arrayPos;
        }
        
        private function cerateFullScreenBtn():void {
            var btn:Sprite = new Sprite();
            btn.buttonMode = true;
            btn.graphics.beginFill(0x808080, 0);
            btn.graphics.drawRect(0, 0, 60, 40);
            btn.graphics.endFill();
            btn.graphics.beginFill(0x808080, 0.5);
            btn.graphics.drawRect(6, 6, 49, 29);
            btn.graphics.endFill();
            btn.graphics.lineStyle(1, 0x808080, 0.5);
            btn.graphics.drawRect(0.5, 0.5, 60, 40);
            btn.x = 5;
            btn.y = 5;
            btn.addEventListener(MouseEvent.CLICK, btn_clickHandler);
            addChild(btn);
        }
        
        private function btn_clickHandler(event:MouseEvent):void {
            stage.displayState = stage.displayState == StageDisplayState.FULL_SCREEN
                ? StageDisplayState.NORMAL
                : stage.displayState = StageDisplayState.FULL_SCREEN;
        }
    }
}
import flash.display.Sprite;

class Obj extends Sprite {
    public var extra:Object;
}