/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/cOST
 */

// forked from ProjectNya's GANTZ球
////////////////////////////////////////////////////////////////////////////////
// GANTZ球
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;

    [SWF(backgroundColor="#EEEEEE", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private static var radius:uint = 160;
        private static var sentence1:String = "public function main( ):void { ";
        private static var sentence2:String = "    init( );";
        private static var sentence3:String = "}";
        private static var sentence4:String = "private function init( ):void {";
        private var txt1:TextEffect;
        private var txt2:TextEffect;
        private var txt3:TextEffect;
        private var txt4:TextEffect;
 
        public function Main() {
            init();
        }

        private function init():void {
            var ball:Ball = new Ball(radius, 0x000000);
            addChild(ball);
            ball.x = 232;
            ball.y = 232;
            //
            txt1 = new TextEffect(200, 20, 13);
            ball.contain(txt1);
            //addChild(txt1);
            txt1.x = - 100;
            txt1.y = - 100;
            txt1.textColor = 0xFFffFF;
            txt1.setup(sentence1);
            
            txt2 = new TextEffect(200, 40, 13);
            ball.contain(txt2);
            //addChild(txt2);
            txt2.x = - 100;
            txt2.y = - 80;
            txt2.textColor = 0xFFFFFF;
            txt2.setup(sentence2);
            
            txt3 = new TextEffect(200, 40, 13);
            ball.contain(txt3);
            txt3.x = - 100;
            txt3.y = - 60;
            txt3.textColor = 0xFFFFFF;
            txt3.setup(sentence3);
            
            txt4 = new TextEffect(200, 40, 13);
            ball.contain(txt4);
            txt4.x = - 100;
            txt4.y = - 40;
            txt4.textColor = 0xFFFFFF;
            txt4.setup(sentence4);
            //
            txt1.addEventListener(TextEffect.COMPLETE, initialize, false, 0, true);
            txt2.addEventListener(TextEffect.COMPLETE, next, false, 0, true);
            txt3.addEventListener(TextEffect.COMPLETE, complete, false, 0, true);
            //

            txt1.start();
        }
 
        private function initialize(evt:Event):void {
            txt1.removeEventListener(TextEffect.COMPLETE, initialize);    
            txt2.start();
        }
        private function next(evt:Event):void {
            txt2.removeEventListener(TextEffect.COMPLETE, next);    
            txt3.start();
        }
        private function complete(evt:Event):void {
            txt3.removeEventListener(TextEffect.COMPLETE, complete);    
            txt4.start();
            //loader.visible = true;
        }

    }

}


//////////////////////////////////////////////////
// Ballクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.display.DisplayObject;
import flash.filters.DropShadowFilter;
import flash.filters.GlowFilter;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.display.BlendMode;

class Ball extends Sprite {
    private var radius:uint;
    private var color:uint;
    private var ball:Sprite;
    private var base:Shape;
    private var shadow:Shape;
    private var light:Shape;
    private var inside:Sprite;
    private var reflection:Shape;
    private var shade:Shape;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;

    public function Ball(r:uint, c:uint) {
        radius = r;
        color = c;
        draw();
    }

    public function contain(object:DisplayObject):void {
        inside.addChild(object);
    }
    private function draw():void {
        shade = new Shape();
        addChild(shade);
        shade.y = radius;
        createShade();
        ball = new Sprite();
        addChild(ball);
        base = new Shape();
        ball.addChild(base);
        shadow = new Shape();
        ball.addChild(shadow);
        light = new Shape();
        ball.addChild(light);
        inside = new Sprite();
        ball.addChild(inside);
        reflection = new Shape();
        ball.addChild(reflection);
        createBase();
        createShadow();
        createLight();
        createReflect();
    }
    private function createBase():void {
        base.graphics.clear();
        base.graphics.beginFill(color, 0.8);
        base.graphics.drawCircle(0, 0, radius);
        base.graphics.endFill();
    }
    private function createShadow():void {
        var colors:Array = [sColor, sColor, sColor];
        var alphas:Array = [0, 0.2, 0.3];
        var ratios:Array = [0, 191, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(radius*3.2, radius*3.2, 0, -radius*2, -radius*2);
        shadow.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        shadow.graphics.drawCircle(0, 0, radius);
        shadow.graphics.endFill();
        shadow.blendMode = BlendMode.HARDLIGHT;
    }
    private function createLight():void {
        var colors:Array = [bColor, bColor, bColor];
        var alphas:Array = [1, 0.2, 0];
        var ratios:Array = [0, 191, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(radius*3.2, radius*3.2, 0, -radius*2, -radius*2);
        light.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        light.graphics.drawCircle(0, 0, radius);
        light.graphics.endFill();
        light.blendMode = BlendMode.OVERLAY;
    }
    private function createReflect():void {
        var colors:Array = [bColor, bColor];
        var alphas:Array = [0.7, 0];
        var ratios:Array = [0, 191];
        var matrix:Matrix = new Matrix();
        var w:Number = radius*1.44;
        var h:Number = radius*1.35;
        var yOffset:Number = radius*0.95;
        matrix.createGradientBox(w, h, 0.5*Math.PI, -w*0.5, -yOffset);
        reflection.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        reflection.graphics.drawEllipse(-w*0.5, -yOffset, w, h);
        reflection.graphics.endFill();
    }
    private function createShade():void {
        shade.graphics.beginFill(sColor, 0.6);
        shade.graphics.drawEllipse(-radius*0.75, -radius*0.1775, radius*1.5, radius*0.375);
        shade.graphics.endFill();
        var shadow:DropShadowFilter = new DropShadowFilter(0, 90, sColor, 0.5, radius*0.15, radius*0.15, 1, 3, false, false, true);
        shade.filters = [shadow];
    }

}


//////////////////////////////////////////////////
// TextEffectクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.GlowFilter;

class TextEffect extends Sprite {
    private var timer:Timer;
    private static var interval:uint = 100;
    private var list:Array;
    private var times:uint;
    public static const COMPLETE:String = Event.COMPLETE;
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function TextEffect(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    public function setup(str:String):void {
        list = str.split("");
        times = list.length;
    }
    public function start():void {
        timer = new Timer(interval, times);
        timer.addEventListener(TimerEvent.TIMER, update, false, 0, true);
        timer.addEventListener(TimerEvent.TIMER_COMPLETE, complete, false, 0, true);
        timer.start();
    }
    public function stop():void {
        if (timer) {
            timer.stop();
            timer.removeEventListener(TimerEvent.TIMER, update);
            timer.removeEventListener(TimerEvent.TIMER_COMPLETE, complete);
        }
    }
    private function update(evt:TimerEvent):void {
        var count:uint = evt.target.currentCount;
        txt.appendText(list[count - 1]);
    }
    private function complete(evt:TimerEvent):void {
        timer.removeEventListener(TimerEvent.TIMER, update);
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, complete);
        dispatchEvent(new Event(COMPLETE));
    }
    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        txt.multiline = true;
        txt.wordWrap = true;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
        //
        var glow:GlowFilter = new GlowFilter(0x00FF66, 1, 16, 16, 2, 3, false, false);
        filters = [glow];
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
