/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/b1tJ
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=100
   
    public class Euler100 extends Sprite {
        private var _tf : TextField;
  
        public function Euler100() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            _tf.appendText(solve().toString() + "\n");
            var g : int = getTimer();
            _tf.appendText((g - s).toString() + " ms\n");
        }
        
        // 2p(p-1)=q(q-1) を満たす(p,q) (q>=10^12)のうち、qが最小となる組のpを求める。
        // pの2次方程式と見なして解くと、p=(1+√(q^2+(q-1)^2))/2
        // ピタゴラス数の生成より、
        // (m,n)=1なるm>nについて
        // q,q-1 = 2mn or m^2 - n^2
        // qを消去して m^2 - n^2 = 2mn±1
        // n=√(2m^2±1)-m
        // nはmについて単調増加なので、2mnもmについて単調増加、つまりqが最小⇔mが最小とみなしてよい
        // よってm=10^6からインクリメントしていってnが整数となって(m,n)=1であればそれが正解
        
        // p=(1+(m^2+n^2))/2
        private function solve() : int
        {
            for(var m : Number = 1000000;m < 2000000;m++){
                var f : Boolean = false;
                var n : Number;
                n = Math.sqrt(2 * m * m - 1) - m;
                if(n == n << 0){
                    if(check(m, n))f = true;
                }
                n = Math.sqrt(2 * m * m + 1) - m;
                if(n == n << 0){
                    if(check(m, n))f = true;
                }
                if(f)break;
            }
            return 0;
        }
        
        private function check(m : Number, n : Number) : Boolean
        {
            if(GCD(m, n) != 1)return false;
            var a : Number = m * m - n * n;
            var b : Number = 2 * m * n;
            var q : Number = Math.max(a, b);
            var p : Number = (1 + (m * m + n * n)) / 2;
            _tf.appendText("" + m + "\n" + n + "\n" + q + "\n" + p + "\n");
            
            return q >= 1000000000000; 
        }
        
	private static function GCD(a : int, b : int) : int
	{
		return b == 0 ? a : GCD(b, a % b);
	}    }
}