/**
 * Copyright jmbyh521 ( http://wonderfl.net/user/jmbyh521 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aVY2
 */

// forked from mutantleg's  Movement on Terrain
package {
    import flash.ui.Keyboard;
    import flash.geom.*;
    import flash.display.*;
    import flash.utils.ByteArray;
    import flash.events.*;
    import flash.text.TextField;
    import com.adobe.utils.AGALMiniAssembler;
    import flash.display3D.*;
    import flash.display3D.textures.Texture;
    public class FlashTest extends Sprite {
        
        public static var deb:TextField;
        public static var deb2:Sprite = new Sprite();
        
        public function FlashTest() {
 
            deb = new TextField();
            addChild(deb);
            deb.width = 400;
            deb.text = " debug ";
            deb.y = 250;
            
            addChild(deb2);
            
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }//ctor
        
        public function init(e:Event=null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            

            stage.stage3Ds[0].addEventListener(Event.CONTEXT3D_CREATE, contReady);
            stage.stage3Ds[0].addEventListener(ErrorEvent.ERROR, onError);
            stage.stage3Ds[0].requestContext3D(Context3DRenderMode.AUTO);
            

        }//init
    
        private var context:Context3D;
        
        public function onError(e:ErrorEvent):void
        {
            deb.text = e.text;
            deb.textColor = 0xFF0000FF;
        }//onerror
        
        public function contReady(e:Event):void
        {
            deb.text = "context ready ";
            
            context = stage.stage3Ds[0].context3D;
            deb.text = context.driverInfo;
            //deb.textColor = 0xFFffFFff;
            
            context.addEventListener(ErrorEvent.ERROR, onError);
            
        
            context.configureBackBuffer(400, 400, 2, true);
        
        
            initProgram(context);    
            
            myTex = new wTex();       
                myTex.genTex(myTex.getXor(64,64,false,true,false), context);
           
            plTex = new wTex();
                plTex.genTex(plTex.getXor(64,64,true,false,false),context);
           
           
           mter = new wTerra();
           mter.initGrid(64,64,2,2);
           
           px = mter.mwidth * mter.cw * 0.5;
           pz = mter.mheight * mter.ch * 0.5;
           
            geo = new wGeo();
       //     geo.makeSprite();                        
       //     geo.makeCube();
      // geo.makePlane(256,256,64,64);
      // geo.makeTerra(8,8, 2,2);
       geo.makeTerra(mter.mwidth, mter.mheight, mter.cw, mter.ch, mter.vecHeight);
            geo.upload(context);
            
          
          pgeo = new wGeo();
          pgeo.makeCube();
          pgeo.upload(context);

/*
            var pic:Bitmap;
            pic = new Bitmap(new BitmapData(200,200,false,0));
            context.clear();
            draw(context);
            context.drawToBitmapData(pic.bitmapData);
            //context.present();            
            addChild(pic);
            pic.x = 200;
            pic.y =100;
 */       
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, kup);
        }//contready
 
        public function screenShot():void
        {
            var pic:Bitmap;
            pic = new Bitmap(new BitmapData(400,400,false,0));
            context.clear();
            draw(context);
            context.drawToBitmapData(pic.bitmapData);
            addChild(pic);
        }//shot
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);
        public function kdown(e:KeyboardEvent):void 
        {
             vecKey[e.keyCode] = true;
 
             if (e.keyCode == Keyboard.TAB) { screenShot(); }
        }//kdown
        
        public function kup(e:KeyboardEvent):void { vecKey[e.keyCode] = false; }
        
        
        public var prog:Program3D;
        public var myTex:wTex;
        public var plTex:wTex;
        
        public var geo:wGeo;
        public var pgeo:wGeo;
        
        public var mter:wTerra;
        
        public var pyaw:Number = -1.57;
        public var px:Number = 6;
        public var py:Number = 1;
        public var pz:Number = 6;
        public var vx:Number = 0;
        public var vy:Number = 0;
        public var vz:Number = 0;
        
        public function initProgram(c:Context3D):void
        { 
            prog = c.createProgram();
                       
            var vert:ByteArray;
            var frag:ByteArray;
            var assembler:AGALMiniAssembler = new AGALMiniAssembler();
            
            var code:String;
                code = "";
                code += "m44 op, va0, vc0\n";
               // code += "m44 v0, va1, vc4\n";
                //code += "move v0, va1\n";
                code += "m44 v0, va1, vc4\n"
              //  code += "move v1, va2\n";
                
                    vert = assembler.assemble(Context3DProgramType.VERTEX, code);
                
                code = "";
                code += "tex ft0 v0, fs0 <2d, linear, miplinear, wrap>\n";
                //code += "move oc, v0\n";
                code += "mov oc, ft0\n";
                //code += "mul oc, ft0, v0\n";
                //code += "mul oc, v0, fc0\n";
                //code += "move oc, fc0\n";
                
                    frag = assembler.assemble(Context3DProgramType.FRAGMENT, code);

            prog.upload(vert, frag);
 
        }//initprogram;
        
        
        public function onEnter(e:Event):void
        {
            vy -= 0.01;
            vx *= 0.92;
            vz *= 0.92;
            
           px += vx;
           py += vy;
           pz += vz;
           if (vy < 0 &&  py <0.5) { py =0.5; vy = 0;}           
           
           
           //debug
           py = mter.getHeight(px, pz) + 0.5;
           
           if (vecKey[Keyboard.UP]) { vx+= Math.cos(pyaw)*0.02; vz+=Math.sin(pyaw)*0.02; }
           if (vecKey[Keyboard.DOWN]) { vx-= Math.cos(pyaw)*0.02; vz-=Math.sin(pyaw)*0.02; }
           if (vecKey[Keyboard.LEFT]) { pyaw -= 0.2; }
           if (vecKey[Keyboard.RIGHT]) { pyaw += 0.2; }
           
           
           render();
        }//onenter
        
        public function render():void
        {
            context.clear();
            draw(context);                    
            context.present();
        }//render
        
        public var camx:Number = 0;
        public var camy:Number = 0;
        public var camz:Number = 0;
        
        public var projmat:Matrix3D = new Matrix3D();
        public var cammat:Matrix3D = new Matrix3D();
        public var mat:Matrix3D = new Matrix3D();
        public var texMat:Matrix3D = new Matrix3D();
        public var ang:Number = 0;
        public var spin:Number = 0;
        public function draw(c:Context3D):void
        {
            var color:Vector.<Number> = Vector.<Number>([1.0,1.0,1.0,1.0]);
            
            c.setCulling(Context3DTriangleFace.BACK);
            c.setProgram(prog);
           
           spin += 5;
           
           mat.identity();
           mat.appendTranslation(0,0,0);
          // mat.appendRotation(spin, Vector3D.Y_AXIS);
          // mat.appendRotation(spin, Vector3D.X_AXIS);
           
           var tx:Number;
           var ty:Number;
           var tz:Number;
           
           tx = px - Math.cos(pyaw)*4;
           tz = pz - Math.sin(pyaw)*4;
           
           camy = 3 + py;
           camx = camx+(tx-camx)*0.5;
           camz = camz +(tz-camz)*0.5;
           
           var th:Number;
           th = mter.getHeight(camx,camz);
           if (camy < th) { camy = th+1;}
           
          // camx -= Math.cos(pyaw) *0.5;
          // camz -= Math.sin(pyaw) *0.5;
           
           
           cammat.identity();
        //   cammat.appendTranslation(0,-1,-5);// + Math.cos(ang)-1);
           cammat.appendTranslation(-camx,-camy,-camz);
           cammat.appendRotation((pyaw+1.57)*(180.0/3.1415), Vector3D.Y_AXIS);
           cammat.appendRotation(20, Vector3D.X_AXIS);
           
           setProjectionMatrix(projmat,90,1,0.1,1000);
           
            
            mat.append(cammat);
            mat.append(projmat);
            
            ang += 0.03;
            
            var vec:Vector.<Number>;
            var s:Number;
            
            texMat.identity();
            /*
            texMat.appendTranslation(-0.5,-0.5,0);
         
            
            texMat.appendRotation(Math.cos(ang)*180.0, Vector3D.Z_AXIS);
              s = Math.sin(ang)+2;
            //texMat.appendScale(s,s,s);  
              
            texMat.appendTranslation(0.5,0.5,0);
            */
      
            
           //draw ground
            c.setTextureAt(0, myTex.tex);
            
            c.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 0, mat, true); 
            c.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 4, texMat, true);
            c.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 0, color);

            c.setVertexBufferAt(0, geo.bufVert, 0, Context3DVertexBufferFormat.FLOAT_3);    
            c.setVertexBufferAt(1, geo.bufUv, 0, Context3DVertexBufferFormat.FLOAT_2);
            
            c.drawTriangles(geo.bufFace, 0, geo.numFace);


            //draw player
            c.setTextureAt(0, plTex.tex);
 
            mat.identity();
            mat.appendScale(1.2,1,1);
            mat.appendRotation(-pyaw*(180.0/3.1415),Vector3D.Y_AXIS);
            mat.appendTranslation(px,py,pz);
         //   mat.appendRotation(pyaw*(180.0/3.1415),Vector3D.Y_AXIS);
            mat.append(cammat);
            mat.append(projmat);
    
            c.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 0, mat, true); 
          
           c.setVertexBufferAt(0, pgeo.bufVert, 0, Context3DVertexBufferFormat.FLOAT_3);    
            c.setVertexBufferAt(1, pgeo.bufUv, 0, Context3DVertexBufferFormat.FLOAT_2);
            
            c.drawTriangles(pgeo.bufFace, 0, pgeo.numFace);
            
        }//draw
        
        
        
        
      public function setProjectionMatrix(m:Matrix3D,
        fovdeg:Number = 90.0, aspect:Number=1.0, nearp:Number = 0.1, farp:Number=1000.0):void
        {
            var vec:Vector.<Number> = m.rawData;
            var f:Number;
            var i:int;

            for (i = 0; i < 16; i++) { vec[i] = 0.0;  } 

            f = 1.0 / Math.tan( (fovdeg * (3.1415 / 180.0)) * 0.5 );

            if (nearp == 0) { nearp = 0.0001; }
            if (farp == 0) { farp = 0.0001; }

            vec[0] = f / aspect;
            vec[5] = f;
            vec[10] = (farp + nearp) / (nearp - farp);
            vec[14] = (2.0 * farp * nearp) / (nearp - farp);
            vec[11] = -1.0;
            vec[15] = 0.0;

            m.rawData = vec;
        }//projmatrix
               
        
        
        
    }//classend
}
import flash.display.BitmapDataChannel;
import flash.display.Bitmap;



import flash.events.ErrorEvent;
import flash.geom.Matrix;
import flash.display.BitmapData;

  import flash.display3D.textures.Texture;
  import flash.display3D.*;

internal class wTex
{
    public var tex:Texture = null;
    
    
    public function wTex() {}
    
    public function getXor(w:int, h:int, red:Boolean=true,green:Boolean=true,blue:Boolean=true):BitmapData
    {
        var bm:BitmapData;
        var k:int;
        var i:int;
        
        bm = new BitmapData(w,h,false,0);
        
        for (i = 0; i < h; i++)
        {
            for (k = 0; k < w; k++)
            {
                bm.setPixel(k,i, (red ? ((i^k)<<16):0) | (green ? ((i ^ k) << 8):0) | (blue ? (i^k):0));
                
            }//nextk
        }//nexti
        
        return bm;
    }//getxor
   
    
    public function genTex(bm:BitmapData, c:Context3D):void
    {
      var s:int; //scale
      var m:int; //miplevel
            
                      
      if (bm.width % 2 != 0 || bm.height %2 != 0 || bm.width != bm.height) 
      {
           bm = getResized(bm, 64, 64);   
      }//endif
      
      tex = c.createTexture(bm.width, bm.height, Context3DTextureFormat.BGRA, false);
      
    
      tex.uploadFromBitmapData( bm , 0);
      
   
       m = 1;
       s = bm.width*0.5;

      while (s > 0)
      {
            tex.uploadFromBitmapData(getResized(bm, s, s), m);
            m += 1;
            s *= 0.5;
      }//wend
        
    }//gentex
    
    private var tempMat:Matrix = new Matrix();

    private function getResized(bm:BitmapData, w:int, h:int):BitmapData
        {
            var ret:BitmapData;
            var mat:Matrix;
            
            mat = tempMat;
            //mat.identity();
            mat.a = w / bm.width;
            mat.d = h / bm.height;

            ret = new BitmapData(w, h, bm.transparent, 0);
            ret.draw(bm, mat, null, null, null, true);

            return ret;
        }//getresized
    
};//classend

internal class wGeo
{
    public var vecVert:Vector.<Number> ;
    public var vecUv:Vector.<Number> ;
    public var vecFace:Vector.<uint> ;
    
    public var bufVert:VertexBuffer3D;
    public var bufUv:VertexBuffer3D;
    public var bufFace:IndexBuffer3D;
    
    public var numFace:int = 0;
    
    public function wGeo()
    {}//ctor
    
    public function upload(c:Context3D):void
    {
        if (bufVert != null) { bufVert.dispose(); }
        if (bufUv != null) { bufUv.dispose(); }
        if (bufFace != null) { bufFace.dispose(); }
        
        var numVert:int;
       // var numFace:int;
        
        numVert = Math.floor( vecVert.length / 3);
        numFace = Math.floor( vecFace.length / 3);
        
        bufVert = c.createVertexBuffer(numVert, 3);
        bufUv = c.createVertexBuffer(numVert, 2);
        bufFace = c.createIndexBuffer(numFace*3);
      
        bufVert.uploadFromVector(vecVert, 0, numVert);
        bufFace.uploadFromVector(vecFace, 0, numFace * 3);
     
        bufUv.uploadFromVector(vecUv, 0, numVert);
        
    }//upload

    //make quad (2 tris)
    public function makeSprite():void
    {
            var p:Number;
            var n:Number;
            var scale:Number;
                      
            scale = 1.0;

            p = 0.5 * scale;
            n = -0.5 * scale;
            
            vecFace  = Vector.<uint>([1, 0, 2, 1, 2, 3]);

            vecVert  = Vector.<Number>([
             n, n, 0.0,
             p, n, 0.0,
             n, p, 0.0,
             p, p, 0.0 ]);
             
            vecUv =  Vector.<Number>([
            0.0, 0.0,
            1.0, 0.0,
            0.0, 1.0,
            1.0, 1.0  ]);
            
    }//makesprite
    
    public function makePlane(w:Number=1.0, h:Number=1.0,
    tw:Number=1.0, th:Number=1.0):void
    {
        vecFace = new Vector.<uint>;
        vecVert = new Vector.<Number>;
        vecUv = new Vector.<Number>;
        
        var nw:Number;
        var nh:Number;
        var pw:Number;
        var ph:Number;
        
        nw = -0.5 * w;
        pw = 0.5 * w;
        nh = -0.5 * h;
        ph = 0.5 * h;
        
        addQuad(
        [nw,0,nh, 0,0],
        [pw,0,nh, tw,0], 
        [nw,0,ph, 0,th],
        [pw,0,ph, tw,th]);      
        
    }//makeplane
    
    public function makeCube():void
    {
        vecFace = new Vector.<uint>;
        vecVert = new Vector.<Number>;
        vecUv = new Vector.<Number>;
        
        var n:Number;
        var p:Number;
        
        n = -0.5;
        p = 0.5;
        
        addQuad([n,n,n, 0,0],[p,n,n, 1,0],  [n,p,n, 0,1],        [p,p,n, 1,1]);      
        addQuad(        [n,n,p, 0,0],       [n,p,p, 1,0],        [p,n,p, 0,1],        [p,p,p, 1,1]);            
        addQuad(         [n,n,n, 0,0],        [n,n,p, 1,0],        [p,n,n, 0,1],        [p,n,p, 1,1]);       
        addQuad(         [n,p,n, 0,0],        [p,p,n, 1,0],        [n,p,p, 0,1],        [p,p,p, 1,1]);    
        addQuad(         [n,n,n, 0,0],        [n,p,n, 1,0],        [n,n,p, 0,1],        [n,p,p, 1,1]);       
        addQuad(         [p,n,n, 0,0],        [p,n,p, 1,0],        [p,p,n, 0,1],        [p,p,p, 1,1]);
                
    }//makecube
    
    
    public function addTri(v1:Array, v2:Array, v3:Array):void
    {
        if (v1.length < 5) { return; }
        if (v2.length < 5) { return; }
        if (v3.length < 5) { return; }
        
       // var numFace:int;
       // numFace = vecFace.length;
        var numVert:int;
        numVert = vecVert.length / 3;
        
        
       vecVert.push(v1[0]); vecVert.push(v1[1]); vecVert.push(v1[2]);
       vecUv.push(v1[3]); vecUv.push(v1[4]);
     
       vecVert.push(v2[0]); vecVert.push(v2[1]); vecVert.push(v2[2]);
       vecUv.push(v2[3]); vecUv.push(v2[4]);
     
       vecVert.push(v3[0]); vecVert.push(v3[1]); vecVert.push(v3[2]);
       vecUv.push(v3[3]); vecUv.push(v3[4]);
        
       vecFace.push(numVert+0); vecFace.push(numVert+1); vecFace.push(numVert+2);
        
        
    }//addface
    
    public function addQuad(v1:Array, v2:Array, v3:Array, v4:Array):void
    {
        if (v1.length < 5) { return; }
        if (v2.length < 5) { return; }
        if (v3.length < 5) { return; }
        if (v4.length < 5) { return; }
        
        //var numFace:int;
        //numFace = vecFace.length;
        
        var numVert:int;
        numVert = vecVert.length / 3;
        
       vecVert.push(v1[0]); vecVert.push(v1[1]); vecVert.push(v1[2]);
       vecUv.push(v1[3]); vecUv.push(v1[4]);
     
       vecVert.push(v2[0]); vecVert.push(v2[1]); vecVert.push(v2[2]);
       vecUv.push(v2[3]); vecUv.push(v2[4]);
     
       vecVert.push(v3[0]); vecVert.push(v3[1]); vecVert.push(v3[2]);
       vecUv.push(v3[3]); vecUv.push(v3[4]);
       
       vecVert.push(v4[0]); vecVert.push(v4[1]); vecVert.push(v4[2]);
       vecUv.push(v4[3]); vecUv.push(v4[4]);
        
        
        
       vecFace.push(numVert+0); vecFace.push(numVert+1); vecFace.push(numVert+2);
       vecFace.push(numVert+1); vecFace.push(numVert+3); vecFace.push(numVert+2);
    }//addquad
    
    
    public function makeTerra(mw:int, mh:int, cw:Number, ch:Number, vec:Vector.<Number> = null):void
    {
        var i:int;
        var k:int;
        var ei:int;
        var ek:int;
        var num:int;
        var yt:int;
        
        vecFace = new Vector.<uint>;
        vecVert = new Vector.<Number>;
        vecUv = new Vector.<Number>;
        
          for (i = 0; i <mh; i++)
          {    
              for (k = 0; k < mw; k++)
              {
                  vecVert.push(k*cw);

                  if (vec == null)
                  {    
                      vecVert.push(Math.random()*2);
                  }
                  else
                  {
                     vecVert.push(vec[k+(i*mh)]); 
                  }
                  
                  vecVert.push(i*cw);
                  vecUv.push((k+1)/mw);
                  vecUv.push((i+1)/mh);
              }//nextk
          }//nexti
                ek = mw - 1;
        ei = mh - 1;
        
          for (i = 0; i < ei; i++)
          {
              yt = i *mw;
          

              for (k = 0; k < ek; k++)
              {
                  vecFace.push(0+k+yt);
                  vecFace.push(1+k+yt);
                  vecFace.push(0+k+mw+yt);
                  
                  vecFace.push(1+k+yt);
                  vecFace.push(1+k+mw+yt);
                  vecFace.push(0+k+mw+yt);
                  
                  
              }//nextk
          
          }//nexti
        
        
    }//maketerra

    
};//classend

internal class wTerra
{
    public var cx:Number = 0;
    public var cz:Number = 0;
    
    public var mwidth:int = 0;
    public var mheight:int = 0;
    
    public var cw:Number = 1;
    public var ch:Number = 1;
    
    public var vecHeight:Vector.<Number>;
    
    public function wTerra() {}
    
    public function getHeight(wx:Number, wy:Number):Number
    {
        var tx:int;
        var ty:int;
        
        tx = Math.floor(wx / cw);
        ty = Math.floor(wy / ch);
        
        if (tx < 0) { return 0;}
        if (ty < 0) { return 0;}
        if (tx >= mwidth-2) {return 0; }
        if (ty >= mheight-2) { return 0; }
        
        //FlashTest.deb.textColor = 0x00FF00;
        //FlashTest.deb.text = " reach " +tx + " " + ty;
        
        
        var a:Number;
        var b:Number;
        var c:Number;
        var d:Number;
        var h:Number;
        var v:Number;
        var yt:int;
        
        yt = ty * mwidth;
       
        a = vecHeight[tx+yt]; //x y
        b = vecHeight[tx+1+yt]; //x+1 y
        c = vecHeight[tx+yt+mwidth]; //x y+1
        d = vecHeight[tx+1+yt+mwidth]; //x+1 y+1
        
        //FlashTest.deb.text = " reach2 ";
        
        /*
         a b
         c d
        */
        
        h = (wx/cw) - tx;
        v = (wy/ch) - ty;

        var h1:Number;
        var h2:Number;
        var h3:Number;
        
        h1 = a + (b-a) * h;
        h2 = c + (d-c) * h;
        h3 = h1 + (h2-h1) * v;
        
        
                /*
        FlashTest.deb.textColor = 0x00FF00;
        FlashTest.deb.text = " h " + h + " v " + v        
        + "\n wx " + wx + " wy " + wy        
        + "\n tx " + tx + " ty " + ty 
        + "\n abcd " +a +" " + b + " " + c + " " + d 
        + "\n h1 " + h1 + " h2 " + h2 + "  h3  " + h3;        
        */
                
                
        return h3;
    }//getheight
    
    public function initGrid(mw_:int=8, mh_:int=8, cw_:Number=8, ch_:Number=8):void
    {
        mwidth = mw_;
        mheight = mh_;
        cw = cw_;
        ch = ch_;
        
        var num:int;
        var i:int;
        var bm:BitmapData;
        
        bm = new BitmapData(mwidth, mheight, false, 0);
        bm.perlinNoise(mwidth,mheight,3,4,true,false,7,true);
        
        //bm.fillRect(bm.rect, 0xFF0000);
        
        var dp:Bitmap;
        dp = new Bitmap(bm);
        FlashTest.deb2.addChild(dp);
        
       // bm.noise(1,0,4);
       // bm.fillRect(bm.rect, 0xFF000000);
        
        num = mwidth * mheight;
        vecHeight = new Vector.<Number>(num, false);
        
        var k:int;
        var yt:int;
        
        for (i = 0; i <mheight; i++)
        {
            yt = i *mwidth;
            for (k = 0; k < mwidth; k++)
            {
                vecHeight[k+yt] = (Number(bm.getPixel(k,i)>>16)) / 4; 
                
            }//nextk
        }//nexti
        
        /*
        for (i = 0; i < num; i++)
        {
          vecHeight[i] = Math.random()*3;  
          
        }//nexti
        */
    }//initterra
    
};//classend


