/**
 * Copyright keno42 ( http://wonderfl.net/user/keno42 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/aPmW
 */

// forked from kazy's ROTATE ARROW
package {
	import flash.display.Sprite;
	import flash.events.Event;
	public class Main extends Sprite {
		private var arrow:Sprite;
		public function Main() {
			init();
		}
		private function init():void {
			arrow = makeArrow();
			addChild(arrow);
			arrow.x = stage.stageWidth / 2;
			arrow.y = stage.stageHeight / 2;
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		public function onEnterFrame(event:Event):void {
			var dx:Number = mouseX - arrow.x;
			var dy:Number = mouseY - arrow.y;
			var radians:Number = Math.atan2(dy, dx);
                        var d:Number = Math.sqrt(dx*dx+dy*dy);
			arrow.rotation = radians * 180 / Math.PI;
                        arrow.rotationY = 90-180*Math.atan(d/40)/Math.PI;
		}
		public function makeArrow():Sprite {
			var newArrow:Sprite = new Sprite();
			newArrow.graphics.lineStyle(1, 0, 1);
			newArrow.graphics.beginFill(0x990033);
			newArrow.graphics.moveTo(-50, -25);
			newArrow.graphics.lineTo(0, -25);
			newArrow.graphics.lineTo(0, -50);
			newArrow.graphics.lineTo(50, 0);
			newArrow.graphics.lineTo(0, 50);
			newArrow.graphics.lineTo(0, 25);
			newArrow.graphics.lineTo(-50, 25);
			newArrow.graphics.lineTo(-50, -25);
			newArrow.graphics.endFill();
			return newArrow;
		}
	}
}