/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/YIhp
 */

package {
    import away3d.cameras.Camera3D;
    import away3d.containers.Scene3D;
    import away3d.containers.View3D;
    import away3d.controllers.HoverController;
    import away3d.debug.AwayStats;
    import away3d.entities.Mesh;
    import away3d.lights.DirectionalLight;
    import away3d.materials.ColorMaterial;
    import away3d.materials.lightpickers.StaticLightPicker;
    import away3d.primitives.CubeGeometry;
    import flash.display.*;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    public class FlashTest extends Sprite {
        
        public var view:View3D;
        public var scene:Scene3D;
        public var camera:Camera3D;
        public var awayStats:AwayStats;
        
        public var cameraController:HoverController;
        
        public var light:DirectionalLight;
        public var lightPicker:StaticLightPicker;
        
        //navigation variables
        private var move:Boolean = false;
        private var lastPanAngle:Number;
        private var lastTiltAngle:Number;
        private var lastMouseX:Number;
        private var lastMouseY:Number;
        
        public var rowNum:int = 25;
        public var colNum:int = 25;
        public var blockWidth:int = 20;
        
        public var wallArray:Array;
        public var wallData:Array;
        
        
        public var nowX:int;
        public var nowY:int;
        
        public var stack:Array = [];
        //private var source:BitmapData = new BitmapData(465, 465, false, 0x000000);       
        
        public var cursor:Mesh;
        
        public function FlashTest() {
            // write as3 code here..
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            Wonderfl.disable_capture();
            
            //addChild(new Bitmap(source));
            
            initEngine();
            initLight();
            initObject();
            initListener();
            
            wallData[0][0] = 1;
            wallArray[1][1].visible = false;
            nowX = 0;
            nowY = 0;
            
            stack.push(new Point(0, 0));
            
            
        }
        
        private function dfs(row:int, col:int):void
        {
            var path:String = "";
            
            if (row > 0 && wallData[row - 1][col] == 0)
            {
                path += "N";
            }
            if (row < int(rowNum / 2) - 1 && wallData[row + 1][col] == 0)
            {
                path += "S";
            }
            if (col > 0 && wallData[row][col - 1] == 0)
            {
                path += "W";
            }
            if (col < int(colNum / 2) - 1 && wallData[row][col + 1] == 0)
            {
                path += "E";
            }
            
            if (path == "")
            {
                stack.pop();
            }
            
            //while (path != "")
            {
                var randIndex:int;
                randIndex = Math.random() * path.length;
                
                var randDirection:String;
                randDirection = path.substr(randIndex, 1);
                path = path.replace(randDirection, '');
                
                //trace(row, col, randDirection);
                
                switch (randDirection)
                {
                    case "N":
                        
                        if (wallData[row - 1][col] == 0)
                        {
                            wallData[row - 1][col] = 1;
                            wallArray[(row - 1) * 2 + 2][col * 2 + 1].visible = false;
                            wallArray[(row - 1) * 2 + 1][col * 2 + 1].visible = false;
                            
                            //dfs(row - 1, col);
                            nowY = row - 1;
                            nowX = col;
                            
                            stack.push(new Point(nowY, nowX));
                            
                        }
                        
                        break;
                    case "S":
                        
                        if (wallData[row + 1][col] == 0)
                        {
                            wallData[row + 1][col] = 1;
                            wallArray[(row + 1) * 2][col * 2 + 1].visible = false;
                            wallArray[(row + 1) * 2 + 1][col * 2 + 1].visible = false;
                            
                            //dfs(row + 1, col);
                            nowY = row + 1;
                            nowX = col;
                            
                            stack.push(new Point(nowY, nowX));
                            
                        }
                        
                        break;
                    case "W":
                        
                        if (wallData[row][col - 1] == 0)
                        {
                            wallData[row][col - 1] = 1;
                            wallArray[row * 2 + 1][(col - 1) * 2 + 2].visible = false;
                            wallArray[row * 2 + 1][(col - 1) * 2 + 1].visible = false;
                            
                            //dfs(row, col - 1);
                            nowY = row;
                            nowX = col - 1;
                            
                            stack.push(new Point(nowY, nowX));
                            
                        }
                        
                        break;
                    case "E":
                        
                        if (wallData[row][col + 1] == 0)
                        {
                            wallData[row][col + 1] = 1;
                            wallArray[row * 2 + 1][(col + 1) * 2].visible = false;
                            wallArray[row * 2 + 1][(col + 1) * 2 + 1].visible = false;
                            
                            //dfs(row, col + 1);
                            nowY = row;
                            nowX = col + 1;
                            
                            stack.push(new Point(nowY, nowX));
                                                        
                        }
                        
                        break;
                }
            }
            
            
            
        }
        
        private function initEngine():void
        {
            view = new View3D();
            view.antiAlias = 4;
            
            scene = view.scene;
            camera = view.camera;
            camera.lens.far = 5000;
            
            cameraController = new HoverController(camera);
            cameraController.distance = 500;
            cameraController.panAngle = 45;
            cameraController.tiltAngle = 20;
            cameraController.maxTiltAngle = 90;
            cameraController.minTiltAngle = 10;
            
            awayStats = new AwayStats(view);
            
        }
        
        private function initLight():void
        {
            light = new DirectionalLight( 0.5, -1, 1);
            light.color = 0xffffff;
            light.ambient = 1;
            scene.addChild(light);
            
            lightPicker = new StaticLightPicker([light]);
        }
        
        private function initObject():void
        {
            var i:int;
            var j:int;
            
            
            var cube:Mesh;
            var cubeGeometry:CubeGeometry = new CubeGeometry(blockWidth, blockWidth, blockWidth, 1, 1, 1, false);
            var wallMaterial:ColorMaterial = new ColorMaterial(0x333333);
            var floorMaterial:ColorMaterial = new ColorMaterial(0xcccccc);
            
            wallMaterial.lightPicker = lightPicker;
            wallMaterial.specular = 0.5;
            wallMaterial.ambient = 0.3;
            
            floorMaterial.ambient = 0.1;
            
            wallArray = [];
            
            for (i = 0; i < rowNum; i += 1)
            {
                wallArray[i] = [];
                
                for (j = 0; j < colNum; j += 1)
                {
                    //make wall
                    cube = new Mesh(cubeGeometry, wallMaterial);
                    cube.x = (i - int(rowNum / 2)) * blockWidth;
                    cube.y = blockWidth;
                    cube.z = (j - int(colNum / 2)) * blockWidth;
                    scene.addChild(cube);
                    
                    wallArray[i].push(cube);
                    
                    //make floor
                    cube = new Mesh(cubeGeometry, floorMaterial);
                    cube.x = (i - int(rowNum / 2)) * blockWidth;
                    cube.y = 0;
                    cube.z = (j - int(colNum / 2)) * blockWidth;
                    scene.addChild(cube);
                    
                }
            }
            
            
            wallData = [];
            for (i = 0; i < int(rowNum / 2); i += 1)
            {
                wallData[i] = [];
                for (j = 0; j < int(colNum / 2); j += 1)
                {
                    wallData[i].push(0);
                }
            }
            
            cursor = new Mesh(cubeGeometry, new ColorMaterial(0x00ffff));
            cursor.y = blockWidth;
            scene.addChild(cursor);
            
        }
        
        private function initListener():void
        {
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(Event.RESIZE, resizeHandler);
            addEventListener(Event.ENTER_FRAME, render);
            
            
            addChild(view);
            addChild(awayStats);
        }
        
        private function render(e:Event):void
        {
            if (move)
            {
                cameraController.panAngle = 0.3 * (stage.mouseX - lastMouseX) + lastPanAngle;
                cameraController.tiltAngle = 0.3 * (stage.mouseY - lastMouseY) + lastTiltAngle;
            }
            
            if (stack.length != 0)
            {
                var row:int = stack[stack.length - 1].x;
                var col:int = stack[stack.length - 1].y;
                
                cursor.x = wallArray[row * 2 + 1][col * 2 + 1].x;
                cursor.z = wallArray[row * 2 + 1][col * 2 + 1].z;
                
                dfs(row, col);
            }    
            
            view.render();
            //view.renderer.queueSnapshot(source);
        }
        
        private function onMouseDown(e:MouseEvent):void
        {
            lastPanAngle = cameraController.panAngle;
            lastTiltAngle = cameraController.tiltAngle;
            lastMouseX = stage.mouseX;
            lastMouseY = stage.mouseY;
            move = true;
           
        }
        
        private function onMouseUp(e:MouseEvent):void
        {
            move = false;
        }
        
        private function resizeHandler(e:Event):void
        {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
        }
    }
}