/**
 * Copyright christian ( http://wonderfl.net/user/christian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/KSZB
 */

package
{
    import flash.display.*;

    public class FREQ extends Sprite
    {
        public function FREQ () { addChild (new Bitmap (new Main (465, 465))); }
    }
}


import flash.geom.*;
import flash.events.*;
import flash.display.*;
import flash.media.Sound;
import flash.net.URLRequest;
import flash.utils.setInterval;
import flash.system.LoaderContext;

/**  @author SPANVEGA // CHRISTIAN  **/

final class Main extends BitmapData
{
    private var amp : Number, mul : Number, vel : Number, off : Number = 0, v : Number = 0.1, 
                r : Rectangle, p : Point = new Point (), h : Number = 0, f : int,
                e : Boolean = false, m : Matrix, b : BitmapData, n : FAST_NOISE;

    private var url : String = // http://wonderfl.net/c/aYYL
    'http://assets.wonderfl.net/images/related_images/6/6c/6c0c/6c0ccd8e318992e483129046f3849fdf6827de00';

    public function Main (w : uint, h : uint) : void
    {
        super (w, h, false, 0);

        var l : Loader = new Loader ();
        l.load (new URLRequest (url), new LoaderContext (true));
        l.contentLoaderInfo.addEventListener (Event.COMPLETE, init);
    }

        private function init (e : Event) : void
        {
            b = Bitmap (e.target.content).bitmapData;

            m = new Matrix (width / b.width, 0, 0, height / b.height, 0, 0);

            n = new FAST_NOISE (width, height, 5); n.channelOptions = 7;

            r = new Rectangle (0, 0, width, 1);

            var s : Sound = new Sound ();
            s.addEventListener (SampleDataEvent.SAMPLE_DATA, sample);
            s.play ();

            setInterval (render, 60 / 1000);
        }

        public function render () : void
        {
            n.high = h; n.render ();

            copyPixels (n, rect, rect.topLeft);
            draw (b, m, null, BlendMode.SUBTRACT);

            if (! e && Math.random () < 0.1)
            {
                v = 0;
                e = true;
                f = 1 + Math.random () * 15;

                amp =     Math.random () * 0.5;
                vel =.5 + Math.random () * 5;
                mul = 5 + Math.random () * 20;
            }

            if (e)
            {
                for (var i : int = 0; i < height; i++)
                {
                    p.y = r.y = i;
                    p.x = Math.sin ((i + off) * amp) * mul;

                    copyPixels (this, r, p);
                }

                off += vel;

                if (0 >= f--) { v = 0.1; e = false; }
            }

            if (h < 0xFF) h++;
        }

        private function sample (e : SampleDataEvent) : void
        {
            for (var i : int = 0; i < 8192; i++)
            {
                e.data.writeFloat ((Math.random () * v) * (h / 0xFF));
                e.data.writeFloat ((Math.random () * v) * (h / 0xFF));
            }
        }

}


import flash.display.*;

final class FAST_NOISE extends BitmapData
{
    private var n : BitmapData, s : Shape = new Shape ();

    public function FAST_NOISE (w : uint, h : uint, scale : Number) : void
    {
        super (w, h, true, 0);

        n = new BitmapData (w / scale, h / scale, true, 0);
    }

    public function render () : void
    {
        n.noise (Math.random () * 0xFFFF, low, high, channelOptions, grayScale);

        s.graphics.clear ();
        s.graphics.beginBitmapFill (n);
        s.graphics.drawRect (0, 0, width, height);

        fillRect (rect, 0);
        draw (s);
    }

    public var channelOptions : uint = 15;

    public var grayScale : Boolean = true;

    public var low  : uint = 0x00;

    public var high : uint = 0xFF;
}