/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ETcb
 */

/// @mxmlc -swf-version 21
package 
{
	import flash.display.Sprite;
	import flash.geom.Vector3D;
	import flash.ui.Keyboard;
	
	[SWF(width='465', height='465')]
	public class WFL_cETcb extends Sprite
	{
		public function WFL_cETcb()
		{
			graphics.beginFill(0); graphics.drawRect(0, 0, 3000, 3000);
			
			var sw:int = stage.stageWidth;
			var sh:int = stage.stageHeight;
			
			var space:Space3D = new Space3D();
			
			space.addParent( this, sw >> 1, sh >> 1 );
			
			var count:int = 5;
			var mid_index:Number = (count - 1) / 2;
			var padding:int = 60;
			
			for (var i:int = 0; i < count; i++) {
				for (var j:int = 0; j < count; j++) {
					for (var k:int = 0; k < count; k++) {
						
						var circle:C = new C( this );
						
						space.position( 
							circle, 
							(i - mid_index) * padding, 
							(k - mid_index) * padding, 
							(j - mid_index) * padding
						);
						
					}
				}
			}
			
			// Keyboard control 
			var K:Vector.<Boolean> = new Vector.<Boolean>();
			for (var k:int = 0; k < 2000; k++) K.push( false );
			var input:Function = function( e:* ):void 
			{K[ e.keyCode ] = e.type == "keyDown";};
			stage.addEventListener('keyDown', input );
			stage.addEventListener('keyUp', input );
			
			// camera vars
			var rotation_speed:Number = 7;
			
			// Enter frame 
			stage.addEventListener('enterFrame', function(e:*):void
			{
				// Rotate UP, DOWN 
				if ( K[ Keyboard.W ] ) space.rotate( - rotation_speed );
				if ( K[ Keyboard.Q ] ) space.rotate( + rotation_speed );
				
				// Rotate LEFT , RIGHT
				if ( K[ Keyboard.A ] ) space.rotate( 0, + rotation_speed );
				if ( K[ Keyboard.S ] ) space.rotate( 0, - rotation_speed );
				
				// 2D rotation ( clockwise, counter-clockwose ) 
				if ( K[ Keyboard.X ] ) space.rotate( 0, 0, + rotation_speed );
				if ( K[ Keyboard.Z ] ) space.rotate( 0, 0, - rotation_speed );
				
				// Rotate UP, DOWN 
				if ( K[ Keyboard.R ] ) space.rotateObjects( - rotation_speed );
				if ( K[ Keyboard.E ] ) space.rotateObjects( + rotation_speed );
				
				// Rotate LEFT , RIGHT
				if ( K[ Keyboard.D ] ) space.rotateObjects( 0, + rotation_speed );
				if ( K[ Keyboard.F ] ) space.rotateObjects( 0, - rotation_speed );
				
				// 2D rotation ( clockwise, counter-clockwose ) 
				if ( K[ Keyboard.V ] ) space.rotateObjects( 0, 0, + rotation_speed );
				if ( K[ Keyboard.C ] ) space.rotateObjects( 0, 0, - rotation_speed );
			});
		}
	}
	
}
import flash.display.DisplayObject;
import flash.display.DisplayObjectContainer;
import flash.display.Shape;
import flash.display.Sprite;


class Space3D 
{
	public var display:Sprite;
	
	public function Space3D()
	{
		display = new Sprite();
	}
	
	public function addParent( parent:DisplayObjectContainer, x:Number = 0, y:Number = 0 ):void 
	{
		parent.addChild( display );
		display.x = x;
		display.y = y;
	}
	
	public function position( target:DisplayObject, x:Number = 0, y:Number = 0, z:Number = 0 ):void
	{
		if( ! target.parent || target.parent != display ) display.addChild( target );
		target.x = x;
		target.y = y;
		target.z = z;
	}
	
	public function rotate( x:Number, y:Number = 0, z:Number = 0 ):void
	{
		display.rotationX += x;
		display.rotationY += y;
		display.rotationZ += z;
	}
	
	public function rotateObjects( x:Number, y:Number = 0, z:Number = 0 ):void
	{
		var child:DisplayObject;
		for (var i:int = 0; i < display.numChildren; i++) 
		{
			child = display.getChildAt( i );
			child.rotationX += x;
			child.rotationY += y;
			child.rotationZ += z;
		}
	}
}

class C extends Shape
{
	public function C( parent:DisplayObjectContainer )
	{
		parent.addChild( this );
		
		graphics.lineStyle(0.1, 0xFF0000);
		graphics.beginFill( 0xFF0000, 0.1 );
		graphics.drawCircle( 0, 0, 10 );
		graphics.endFill();
	}
}