/**
 * Copyright hakerlab ( http://wonderfl.net/user/hakerlab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/CmSA
 */

// forked from ProjectNya's EmitLight [blue]
////////////////////////////////////////////////////////////////////////////////
//  EmitLight [blue]
//
// [AS3.0] EmitLightクラスだ！ (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1281
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.geom.Rectangle;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var light:EmitLight;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);
            light = new EmitLight(rect);
            addChild(light);
            light.start();
        }
        
    }

}


//////////////////////////////////////////////////
// EmitLightクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.ColorTransform;
import flash.display.BlendMode;
import flash.filters.BlurFilter;
import frocessing.color.ColorHSV;

class EmitLight extends Sprite {
    private var rect:Rectangle;
    private var cx:uint = 0;
    private var cy:uint = 0;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var container:Sprite;
    private var particles:Array;
    private var color:ColorHSV;
    private var colorTrans:ColorTransform;
    private static var blur:BlurFilter;
    private static var point:Point = new Point();

    public function EmitLight(r:Rectangle) {
        rect = r;
        cx = rect.x + rect.width/2;
        cy = rect.y + rect.height/2;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        container = new Sprite();
        addChild(container);
        particles = new Array();
        color = new ColorHSV(235);
        colorTrans = new ColorTransform();
        colorTrans.color = color.value;
        blur = new BlurFilter(8, 8, 3);
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    public function stop():void {
        removeEventListener(Event.ENTER_FRAME, update);
    }
    private function update(evt:Event):void {
        create();
        create();
        bitmapData.lock();
        for (var n:uint = 0; n < particles.length; n++) {
        var particle:ParticleLight = particles[n];
            particle.update();
            particle.scale = particle.alpha = particle.power;
            if (particle.power < 0) {
                container.removeChild(particle);
                particles.splice(n, 1);
                particle = null;
            }
        }
        bitmapData.draw(container, null, colorTrans, BlendMode.SCREEN, null, true);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
    }
    private function create():void {
        color.h = 210 + Math.random()*30;
        var particle:ParticleLight = new ParticleLight(12, color.value);
        particle.x = cx + (Math.random() - 0.5)*30;
        particle.y = cy + (Math.random() - 0.5)*30;
        particle.angle = Math.random()*360;
        particle.speed = Math.random()*4 + 6;
        particle.power = 1;
        particle.setup();
        particle.blendMode = BlendMode.ADD;
        container.addChild(particle);
        particles.push(particle);
    }

}


//////////////////////////////////////////////////
// ParticleLightクラス
//////////////////////////////////////////////////

import flash.display.Shape;

class ParticleLight extends Shape {
    private var radius:uint = 10;
    private var color:uint = 0xFFFFFF;
    public var angle:Number = 0;
    public var speed:Number = 0;
    private var vx:Number = 0;
    private var vy:Number = 0;
    public var power:Number = 0;
    private static var radian:Number = Math.PI/180;
    private static var friction:Number = 0.96;
    private static var deceleration:Number = 0.025;
    private var _scale:Number = 1;

    public function ParticleLight(r:uint = 10, c:uint = 0xFFFFFF) {
        radius = r;
        color = c;
        draw();
    }

    private function draw():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
    public function setup():void {
        vx = speed*Math.cos(angle*radian);
        vy = speed*Math.sin(angle*radian);
    }
    public function update():void {
        x += vx;
        y += vy;
        vx *= friction;
        vy *= friction;
        power -= deceleration;
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }

}
