/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/AvSU
 */

// forked from tepe's flash on 2011-3-19
package {
    import flash.events.*;
    import flash.display.*;
    import flash.text.*;
    //[SWF(backgroundColor=0, width=465, height=465)]
    public class FlashTest extends Sprite {
        private var node1:node = new node();
        private var text1:TextField = new TextField();

        public function FlashTest() {
            
            //パラボラ曲線の描画
            
            var s2:Shape = new Shape();
            s2.x = 100;
            s2.y = 300;
            var st:int = 100; 
            var a:Number =-0.001;
            s2.graphics.lineStyle(0,0x00ff00);
            s2.graphics.moveTo(st,a*(st*st));
            s2.graphics.lineTo(0,0.25/a);
            s2.graphics.moveTo(-st,a*(st*st));
            s2.graphics.lineTo(0,0.25/a);
            s2.graphics.beginFill(0x00ff00);
            s2.graphics.drawCircle(0,0.25/a,5);
            s2.graphics.endFill();
            //s2.graphics.beginFill(0xff0000);
            s2.graphics.lineStyle(0,0xff0000);
            s2.graphics.moveTo(-st,a*(st*st));
            
            for(var i:int = -st;i<st;i++){
                //放物線:y = ax^2
                s2.graphics.lineTo(i,a*(i*i));
                s2.graphics.moveTo(i,a*(i*i));
            }
            s2.graphics.lineTo(st,a*(st*st));
            
            node1.map.addChild(s2);
            addChild(node1);
            text1.selectable = false;
            text1.height = 20;
            text1.width = 20;
            text1.textColor = 0xff00ff;
            //text1.border = true;
            addChild(text1);
            //stage.showDefaultContextMenu=false;
            stage.addEventListener(KeyboardEvent.KEY_DOWN,screenMode);
            addEventListener(Event.ENTER_FRAME,function():void{
                
                text1.text = String(node1.scaleSize);
            });


                
        }
        
        private function screenMode(e:KeyboardEvent):void{      
            
            if(e.keyCode == 13){
                if(node1.IsBrowseMode == true)node1.browseOff();
                else node1.browseOn();
                
            }
            else if(e.keyCode == 66){
                node1.returnHome();
            }

            else if(e.keyCode == 73){
                if(stage.displayState == StageDisplayState.FULL_SCREEN){
                    stage.displayState = StageDisplayState.NORMAL;//元に戻す               
                }
                else{
                    stage.displayState = StageDisplayState.FULL_SCREEN;//フルスクリーンモード        
                }
            }


            //e.stopPropagation();//イベントの伝播を止める            
        }
    }
}


//------------------------------------------------------------------------------

//------------------------------------------------------------------------------

import flash.geom.*;
import flash.display.*;
import flash.text.*;
import flash.events.*;

class node extends Sprite{
        
        private var scale:Number = 1;
        
        public var wheel:int;//ホイール回転量
        private var zoom:Number = 1.0;//拡大率
        
        private var mapBase:Sprite;
        public var map:Sprite;//フィールド
        
        private var scrFocusX:Number=0; 
        private var scrFocusY:Number=0; 

        private var mapscale:int=0;
        
        private var dragPanel:Sprite = new Sprite();
                
        //ozmap状態フラグ
        private const testMode:Boolean = true;//テスト表示
        private var mapBrowseMode:Boolean;//マップ移動操作
        private var mapDragMode:Boolean;//マップドラッグ中はtrue
        private var mapRotationMode:Boolean;//マップ回転操作
        
        
        //コンストラクタ 
        public function node():void{
            
            mapBase = new Sprite();//ズーム中心
            
            if(testMode == true){ 
                with( mapBase.graphics ){
                    lineStyle(1,0x00ff00,0.3);
                    moveTo(-100,0);
                    lineTo(100,0);
                    moveTo(0,-100);
                    lineTo(0,100);
                }
            }
            addChild(mapBase);
 
            
            //マップ上への配置
            map = new Sprite();
            
            if(testMode == true){
                var t3:TextField = new TextField();
                with(t3){
                    textColor = 0x0000ff;
                    selectable = false;
                    y = -20;
                    text = "map 0,0";
                }
                map.addChild(t3);
                with( map.graphics ){
                    lineStyle(1,0x0000ff,0.3);
                    moveTo(-100,0);
                    lineTo(100,0);
                    moveTo(0,-100);
                    lineTo(0,100);
                }
            } 
            
            browseOn();
 
            mapBase.addChildAt(map,0); 
            map.addChild(dragPanel);
            dragPanel.doubleClickEnabled = true;

            update();
    
        }
        
        public function get scaleSize():int{
            return mapscale;
        }
        
        //マップ移動操作状態
        public function get IsBrowseMode():Boolean{
            return mapBrowseMode;
        }
        //マップドラッグスクロール状態
        public function get IsDragMode():Boolean{
            return mapDragMode;
        }        
        //マップ回転操作状態
        public function get IsRotationMode():Boolean{
            return mapRotationMode;
        }

        //
        public function returnHome():void{
            map.x = 0;
            map.y = 0;
            map.scaleX = map.scaleY = 1.0;
            mapscale = 0;
            update();
            
        }

        
        
        //画面移動操作の受付　ON・OFF切り替え
        public function browseOn():void{
            
            mapBrowseMode = true;
            map.addEventListener(MouseEvent.MOUSE_DOWN,down);
            map.addEventListener(MouseEvent.MOUSE_UP,up);
            dragPanel.addEventListener(MouseEvent.DOUBLE_CLICK,onDouble);
            this.addEventListener(MouseEvent.MOUSE_WHEEL,on_wheel,true);//ホイール操作 
            map.addChild(dragPanel);
        }
        public function browseOff():void{
            wheel = 0;
            mapBrowseMode = false;
            map.removeEventListener(MouseEvent.MOUSE_DOWN,down);
            map.removeEventListener(MouseEvent.MOUSE_UP,up);
            dragPanel.removeEventListener(MouseEvent.DOUBLE_CLICK,onDouble);
            this.removeEventListener(MouseEvent.MOUSE_WHEEL,on_wheel,true);//ホイール操作 
            map.removeChild(dragPanel);
        }
        
        //ダブルクリックでマップブラウズモード解除　⇒　オブジェクト操作モードに移行
        private function onDouble(e:MouseEvent):void{
            browseOff();
            //ホイール操作でブラウズモードに移行
            stage.addEventListener(MouseEvent.MOUSE_WHEEL,function():void{
                browseOn();
            });
        }


  
        //マップドラッグ開始
        private function down(e:MouseEvent):void{
            wheel=0;//ズーム操作ストップ

      　    e.currentTarget.startDrag();
      　    addEventListener(MouseEvent.MOUSE_MOVE,onMove);
      　    stage.removeEventListener(Event.ENTER_FRAME,onFrame);
      　    e.stopPropagation();//イベントの伝播を止める
      　    
        }
        
        private function up(e:MouseEvent):void{
            e.currentTarget.stopDrag();
            removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
            e.stopPropagation();//イベントの伝播を止める
        }
        
        //マップドラッグ中
        private function onMove(e:MouseEvent):void{
            update();
        }

        //ホイール操作
        private function on_wheel(e:MouseEvent):void{  
            
            wheel += e.delta;
            
            if(wheel != 0)addEventListener(Event.ENTER_FRAME,onFrame);
            //else removeEventListener(Event.ENTER_FRAME,onFrame);
        }
  
        private function onFrame(e:Event):void {
            if(wheel==0){
                removeEventListener(Event.ENTER_FRAME,onFrame);
            }

            on_zoom(1+(0.005*wheel));
        }
        
        
        //マップ表示位置を更新
        private function update(z:Number=1, x:Number=0, y:Number=0, a:Number=0):void{
            var mX:int,mY:int;
            
            if(1<=z){//ズームイン
                mX = mouseX;
                mY = mouseY;//カーソル位置 
            }
            else{//ズームアウト
                mX = this.root.loaderInfo.width/2;
                mY = this.root.loaderInfo.height/2;//カーソル位置
            }
            
            //ズーム中心
            mapBase.x = mX;
            mapBase.y = mY; 
            //マップ位置
            map.x -= (mX-scrFocusX)/zoom;
            map.y -= (mY-scrFocusY)/zoom;
            //フォーカス位置
            scrFocusX = mX;
            scrFocusY = mY;
            

            //フィールドドラッグ用
            with(dragPanel.graphics){
                clear();
                beginFill(0xffffff,0.2);
                drawCircle( -map.x/map.scaleX, -map.y/map.scaleY, 1200/(zoom*map.scaleX) );
                
                endFill();
            }
            if(true){
                var i:int;
                var c:uint = 0x00aa00;
                const j:int = 32;
                with(dragPanel.graphics){
                    for(i= -20-(map.y/j);i<20-(map.y/j);i++){
                        if(Math.abs(i)%2 == 1)lineStyle(0,c,(zoom*0.5)-0.5);
                        else lineStyle(0,c,0.5);
                        moveTo((-600-map.x)/map.scaleX , i*j/map.scaleX);
                        lineTo((1600-map.x)/map.scaleX , i*j/map.scaleX);
                    }
                    for(i=-20-(map.x/j);i<20-(map.x/j);i++){
                        if(Math.abs(i)%2 == 1)lineStyle(0,c,(zoom*0.5)-0.5);
                        else lineStyle(0,c,0.5);
                        moveTo(i*j/map.scaleX, (-600-map.y)/map.scaleX);
                        lineTo(i*j/map.scaleX, (1600-map.y)/map.scaleX);
                    }
                }
            }
      
        }

        //ズーム処理
        private function on_zoom(z:Number=0):void{
            if(z==0)return;
            zoom *= z;    
                
            if(2 < zoom){
                with(map){
                    x+=x; y+=y;
                    scaleX = scaleY *= 2;
                }
                zoom /= 2;      
                mapscale--;
                
            }
            else if(zoom < 1.0){
                with(map){
                    x-=x/2; y-=y/2;
                    scaleX = scaleY /= 2;
                }        
                zoom *= 2;    
                mapscale++;
                    
            }
            
            with(mapBase){
                scaleX = scaleY = zoom;
            }
            update(z);//基準点更新      
          
        }
        
    }
    
    

