/**
 * Copyright aduka ( http://wonderfl.net/user/aduka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/Akse
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.JointStyle;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    
    import flashx.textLayout.formats.BackgroundColor;
    
    [SWF( width="512", height="512", backgroundColor="0x0000" )]
    public class Adukan extends Sprite
    {

        private var aduka:Aduka;
        private var size:uint;
        private var backGround:BitmapData;
        
        public function Adukan()
        {
            //    背景部分の作成
            size = 512;
            backGround = new BitmapData( size, size, true, 0xffffffff );
            tinctureApart( backGround, -0.36, 263, 0xdbe9ec );
            var bitmap:Bitmap = new Bitmap( backGround );
            addChild( bitmap );
        
            //    顔画像の作成
            aduka = new Aduka(  465,  0xcc3467, 0x951c45  );
            aduka.rotation = 10;
            aduka.x = 85;
            aduka.y = -20;
            addChild( aduka );
        }
        
        //    指定した範囲を塗りつぶす
        private function tinctureApart( bitmapData:BitmapData, a:Number, b:Number, color:uint ):void
        {
            for( var y:uint = 0; y < bitmapData.height; ++y ){
                for( var x:uint = 0; x < bitmapData.width; ++x ){
                    if( a * x + b > y ){
                        bitmapData.setPixel( x, y, color );
                    }
                }
            }
        }
    }
}

import flash.display.JointStyle;
import flash.display.Sprite;

class Aduka extends Sprite
{
    private var size_:uint;    //    サイズ
    private var color_:uint;
    private var colorBorder_:uint;      
    //------------------------------------------
    // @param size アイコンの大きさ
    // @param color アイコンの内側の色
    // @param colorBorder アイコンの線の色
    public function Aduka( size:uint, color:uint, colorBorder:uint ){
        color_ = color;
        colorBorder_ = colorBorder;
        size_ = size;
        
        //    顔のパーツを描画
        drawParts( this );   
    }
    public function set size( size:uint):void{
        size_ = size;
        clear( this );
        drawParts( this );
    }
    public function get size():uint{ return size_; }
    
    // 顔のパーツを全部描画
    private function drawParts( sprite:Sprite ):void
    {
        drawNose( sprite );
        drawMouse( sprite );
        drawEyeRight( sprite );
        drawEyeLeft( sprite );
    }
        
    private function clear( sprite:Sprite ):void{
        sprite.graphics.clear();
    }
    
    private function drawNose( sprite:Sprite ):void
    {
        sprite.graphics.lineStyle( size_*0.06, colorBorder_) ;
        sprite.graphics.moveTo( 0.6093*size_, 0.3359*size_ );
        sprite.graphics.lineTo( 0.6269*size_, 0.4804*size_ );
        sprite.graphics.moveTo( 0.6269*size_, 0.4804*size_ );
        sprite.graphics.lineTo( 0.7677*size_, 0.6035*size_ );
        sprite.graphics.moveTo( 0.7677*size_, 0.6035*size_ );
        sprite.graphics.lineTo( 0.6914*size_, 0.6748*size_ );
        sprite.graphics.moveTo( 0.6914*size_, 0.6748*size_ );
        sprite.graphics.lineTo( 0.6386*size_, 0.6835*size_ );
        sprite.graphics.lineStyle( size_*0.04, color_ );
        sprite.graphics.moveTo( 0.6093*size_, 0.3359*size_ );
        sprite.graphics.lineTo( 0.6269*size_, 0.4804*size_ );
        sprite.graphics.moveTo( 0.6269*size_, 0.4804*size_ );
        sprite.graphics.lineTo( 0.7677*size_, 0.6035*size_ );
        sprite.graphics.moveTo( 0.7677*size_, 0.6035*size_ );
        sprite.graphics.lineTo( 0.6914*size_, 0.6748*size_ );
        sprite.graphics.moveTo( 0.6914*size_, 0.6748*size_ );
        sprite.graphics.lineTo( 0.6386*size_, 0.6835*size_ );    
    }    
            
    private function drawMouse( sprite:Sprite ):void
    {
        sprite.graphics.lineStyle( 0.06*size_, colorBorder_, 1.0 , false, "normal", "square" );
        sprite.graphics.moveTo( 0.2578*size_, (0.81)*size_ );
        sprite.graphics.lineTo( 0.8*size_, (0.81)*size_ );
        sprite.graphics.lineStyle( 0.04*size_, color_, 1.0 , false, "normal", "square" );
        sprite.graphics.moveTo( 0.2578*size_, (0.81)*size_ );
        sprite.graphics.lineTo( 0.8*size_, (0.81)*size_ );
    }
        
    private function drawEyeRight(sprite:Sprite):void
    {
        sprite.graphics.lineStyle(0.01*size_, colorBorder_);
        sprite.graphics.beginFill( color_ );
        sprite.graphics.drawRect( 0.72*size_, 0.3164*size_, 0.1406*size_, 0.0976*size_ );
        sprite.graphics.endFill();
    }
        
    private function drawEyeLeft( sprite:Sprite ):void
    {            
        sprite.graphics.lineStyle(0.01*size_, colorBorder_);
        sprite.graphics.beginFill( color_ );
        sprite.graphics.drawCircle( 0.2871*size_, 0.3691*size_, 0.1367*size_ );
        sprite.graphics.endFill();
            
        sprite.graphics.lineStyle( size_*0.07, colorBorder_, 1.0, false, "normal", "square", JointStyle.MITER );
        sprite.graphics.drawRect( 0.0781*size_, 0.166*size_, 0.4101*size_, 0.4042*size_ );
            
        sprite.graphics.lineStyle( size_*0.05, color_, 1.0, false, "normal", "square", JointStyle.MITER );
        sprite.graphics.drawRect( 0.0781*size_, 0.166*size_, 0.4101*size_, 0.4042*size_ );

            
    }
}