/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9ojc
 */

package {
    import flash.events.Event;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {

                  
           stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
           stage.addEventListener(KeyboardEvent.KEY_UP, onKup); 
           stage.addEventListener(Event.ENTER_FRAME, onEnter); 
        }//ctor
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512, false);
        public function onKdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; }
        public function onKup(e:KeyboardEvent):void { vecKey[e.keyCode] = false; }
        public function isKeyDown(k:int):Boolean { return vecKey[k]; }      
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0); 

            drawBox2(0,0,0, 512,1,512);
            
            
            var ta:Number; ta=0.2;
            var ms:Number; ms = -3;
            var i:int; i =0;
            //tank controls i choose you
            if (isKeyDown(Keyboard.LEFT)) { cyaw-=ta;}
            if (isKeyDown(Keyboard.RIGHT)) { cyaw+=ta;}
            if (isKeyDown(Keyboard.UP)) { cx+=Math.cos(cyaw)*ms; cz+=Math.sin(cyaw)*ms; i=1}
            if (isKeyDown(Keyboard.DOWN)) { cx+=Math.cos(cyaw)*-ms; cz+=Math.sin(cyaw)*-ms; i=1; }
            
          //  drawBox2(cx,cy,cz,32,64,32);
            drawBox2(cx,cy,cz,32,1,32);
            ori.reset();
            ori.rotYaw(-cyaw+1.57);
            //drawSlab(ori, cx,cy,cz, 16,32);

           
           if (vecFrame == null) { vecFrame = [vec0,vec1, vec2,vec1, vec0,vec3, vec4,vec3];   }
           if (i > 0) { curFrame +=0.3; if (curFrame >= vecFrame.length) { curFrame =0; } }

           //drawVec(vec0, -cyaw+1.57, cx, cy-16, cz, 0.5);
   //        drawVec(vecFrame[int(curFrame)]  , -cyaw+1.57, cx, cy-16, cz, 0.5);
           drawVec(vecFrame[int(curFrame)]  , -cyaw+1.57, cx, cy-16, cz, 1);

        }//onenter
        
        
        public var curFrame:Number = 0;
        public var vecFrame:Array;
        
        public var cx:Number = 256;
        public var cy:Number = 0;
        public var cz:Number = 256;
        public var cyaw:Number = 0;
 
        public var ori:xQuat = new xQuat();
 
        public var gt:int = 0;
        
        public var rendw:Number = 465 * 0.5;
        public var rendh:Number = 465 * 0.5;

        public var camx:Number = 0;
        public var camy:Number = 0;
        public var camz:Number = 0; 

        public function drawLine(ax:Number, ay:Number, az:Number,
        bx:Number, by:Number, bz:Number):void
        {
           var sx:Number; var sy:Number;     
           ax -= camx; ay -= camy; az -= camz;
           bx -= camx; by -= camy; bz -= camz;
    
            sx = ax - az + rendw;
            sy = (ax * 0.5) + (az * 0.5) - ay;
            graphics.moveTo(sx,sy);

            sx = bx - bz + rendw;
            sy = (bx * 0.5) + (bz * 0.5) - by;
            graphics.lineTo(sx, sy);
            
        }//drawline 
                
       public function drawBox2(ax:Number, ay:Number, az:Number,
       aw:Number, ah:Number, ad:Number):void
        {   drawBox(ax,ay,az,ax+aw,ay+ah,az+ad); }
        
       public function drawBox(ax:Number, ay:Number, az:Number,
          bx:Number, by:Number, bz:Number):void
        {
          drawLine(ax, ay, az,   bx, ay, az);
          drawLine(ax, by, az,   bx, by, az);
          drawLine(ax, ay, bz,   bx, ay, bz);
          drawLine(ax, by, bz,   bx, by, bz);
          
          drawLine(ax, ay, az,   ax, by, az);
          drawLine(bx, ay, az,   bx, by, az);
          drawLine(ax, ay, bz,   ax, by, bz);
          drawLine(bx, ay, bz,   bx, by, bz);
          
          drawLine(ax, ay, az,   ax, ay, bz);
          drawLine(bx, ay, az,   bx, ay, bz);
          drawLine(ax, by, az,   ax, by, bz);
          drawLine(bx, by, az,   bx, by, bz);
        }//drawbox         
       
        public var tempq:xQuat = new xQuat(); 
        public function drawSlab(o:xQuat, ax:Number, ay:Number, az:Number, r:Number = 16, h:Number = 32):void
        {
          var tq:xQuat; tq = tempq;
          var kx:Number; var ky:Number; var kz:Number;
          var kx2:Number; var ky2:Number; var kz2:Number;       
          var bx:Number; var by:Number; var bz:Number;
          var tx:Number; var ty:Number; var tz:Number;
          var bx2:Number; var by2:Number; var bz2:Number;
          var tx2:Number; var ty2:Number; var tz2:Number;
          
          tq.copyQuat(o); 
           
          kx = ax + tq.getFrontVx();   ky = ay + tq.getFrontVy();  kz = az + tq.getFrontVz();
          kx2 = ax + tq.getFrontVx() * h;   ky2 = ay + tq.getFrontVy() * h;  kz2 = az + tq.getFrontVz() * h;
       
          var i:int;
          for (i = 0; i < 4; i += 1)
          { 
            tx = kx + tq.getSideVx() * r;        ty = ky + tq.getSideVy() * r;        tz = kz + tq.getSideVz() * r;
            bx = kx2 + tq.getSideVx() * r;        by = ky2 + tq.getSideVy() * r;        bz = kz2 + tq.getSideVz() * r;        
            drawLine(tx, ty, tz, bx, by, bz);           
            
            tq.rotRoll(1.57);       
            tx2 = kx + tq.getSideVx() * r;        ty2 = ky + tq.getSideVy() * r;        tz2 = kz + tq.getSideVz() * r;
            bx2 = kx2 + tq.getSideVx() * r;        by2 = ky2 + tq.getSideVy() * r;        bz2 = kz2 + tq.getSideVz() * r;        
            drawLine(tx, ty, tz, tx2, ty2, tz2);
            drawLine(bx, by, bz, bx2, by2, bz2);
    
          }//nexti
    
        }//drawslab
        
        
    public var tq0:xQuat = new xQuat();
    public var tq1:xQuat = new xQuat();    
    public var tempmat:Vector.<Number> = new Vector.<Number>(16, false);
    public function drawVec(vec:Vector.<Number>, yaw:Number, ax:Number,ay:Number,az:Number, sx:Number=1):void
    {
     var mat:Vector.<Number>; mat = tempmat;
     var rx:Number; var ry:Number; var rz:Number;
     
     tq0.reset(); tq0.rotAxisY(yaw);
     tq0.setVec(mat);
     mat[12] = ax; mat[13] = ay; mat[14] = az; 
     
    
      var i:int; var num:int;
      num = vec.length;
      for (i = 0; i < num; i += 9)
      {
        tq1.setValue(vec[i + 5], vec[i + 6], vec[i + 7], vec[i + 8]);
        tq1.rotAxisX(-1.57); //correction

        tq0.reset(); tq0.rotAxisY(yaw);
        tq0.mul(tq1);
        
        ax = vec[i + 2]*sx;        ay = vec[i + 3]*sx;        az = vec[i + 4]*sx;
        
        rx = ax * mat[0] + ay * mat[4] + az * mat[8] + mat[12];
        ry = ax * mat[1] + ay * mat[5] + az * mat[9] + mat[13];
        rz = ax * mat[2] + ay * mat[6] + az * mat[10] + mat[14];
 
        drawSlab(tq0, rx, ry, rz, vec[i] * sx, vec[i + 1] * sx);
        
      }//nexti
    }//drawvec

    //radius(1) length(1)  pos(3)  ori(4)

     public var vec0:Vector.<Number> = Vector.<Number>([  14,43,  0,83,0,  0.0,0.0,0.0, 1.0,  8,18,  0,130,-7,  0.0,0.0,0.0, 1.0,  8,15,  -24,111,-1,  0.0,0.0,0.0, 1.0,  15,13,  0,83,0,  -1.0,0.0,0.0, 0.0,  8,32,  -11,68,0,  -1.0,0.0,0.0, 0.0, 
     8,32,  -11,33,0,  -1.0,0.0,0.0, 0.0,  8,32,  -30,110,0,  -1.0,0.0,0.0, 0.0,  8,32,  12,33,0,  -1.0,0.0,0.0, 0.0,  8,32,  12,68,0,  -1.0,0.0,0.0, 0.0,  8,32,  30,110,0,  -1.0,0.0,0.0, 0.0, 
     8, 15,  24, 111, -1,  0.0, 0.0, 0.0, 1.0, ]); 
 
     public var vec1:Vector.<Number> = Vector.<Number>([  14,43,  0,82,-1,  0.0,0.0,0.0, 1.0,  8,18,  0,129,-7,  0.0,0.0,0.0, 1.0,  8,15,  -24,109,-6,  0.0,0.0,0.0, 1.0,  15,13,  0,81,0,  -1.0,0.0,0.0, 0.0,  8,32,  -11,67,0,  -0.990268,0.0,0.0, -0.139173, 
     8,32,  -11,33,9,  -0.993476,-0.00414196,-0.0086934, -0.113637,  8,32,  -30,109,-6,  -0.996195,0.0,0.0, 0.087156,  8,32,  12,33,-7,  -0.994522,0.0,0.0, 0.104529,  8,32,  12,67,0,  -0.992546,0.0,0.0, 0.12187,  8,32,  30,109,4,  -0.994522,0.0,0.0, -0.104528, 
     8,15,  24,109,3,  -0.104528,0.0,0.0, 0.994522, ]); 

     public  var vec2:Vector.<Number> = Vector.<Number>([  14,43,  0,83,0,  0.0,0.0,0.0, 1.0,  8,18,  0,130,-7,  0.0,0.0,0.0, 1.0,  8,15,  -24,111,-11,  0.0,0.0,0.0, 1.0,  15,13,  0,83,0,  -1.0,0.0,0.0, 0.0,  8,32,  -11,68,0,  -0.939693,0.0,0.0, -0.34202, 
     8,32,  -11,33,23,  -0.959418,-0.00650916,-0.0231739, -0.280959,  8,32,  -30,110,-14,  -0.976296,0.0,0.0, 0.21644,  8,32,  12,33,-19,  -0.965926,0.0,0.0, 0.258819,  8,32,  12,68,0,  -0.953717,0.0,0.0, 0.300706,  8,32,  30,110,13,  -0.965926,0.0,0.0, -0.258819, 
     8,15,  24,110,12,  -0.258819,0.0,0.0, 0.965926, ]); 

     public var vec3:Vector.<Number> = Vector.<Number>([  14,43,  0,82,0,  0.0,0.0,0.0, 1.0,  8,18,  0,129,-7,  0.0,0.0,0.0, 1.0,  8,15,  -24,109,5,  -0.156434,0.0,0.0, 0.987688,  15,13,  0,81,0,  -1.0,0.0,0.0, 0.0,  8,32,  -11,67,0,  -0.983255,0.0,0.0, 0.182236, 
     8,32,  -11,33,-11,  -0.994522,0.0,0.0, 0.104529,  8,32,  -30,109,9,  -0.991445,0.0,0.0, -0.130526,  8,32,  12,33,11,  -0.978148,0.0,0.0, -0.207912,  8,32,  12,67,0,  -0.987688,0.0,0.0, -0.156435,  8,32,  30,109,-6,  -0.987688,0.0,0.0, 0.156435, 
     8, 15,  24, 109, -2,  0.0784591, 0.0, 0.0, 0.996917, ]); 
 
     public var vec4:Vector.<Number> = Vector.<Number>([  14,43,  0,81,-1,  0.0,0.0,0.0, 1.0,  8,18,  0,128,-7,  0.0,0.0,0.0, 1.0,  8,15,  -24,108,10,  -0.258819,0.0,0.0, 0.965926,  15,13,  0,80,0,  -1.0,0.0,0.0, 0.0,  8,32,  -11,66,0,  -0.953717,0.0,0.0, 0.300706, 
     8,32,  -11,33,-18,  -0.984808,0.0,0.0, 0.173648,  8,32,  -30,108,15,  -0.976296,0.0,0.0, -0.21644,  8,32,  12,33,19,  -0.939693,0.0,0.0, -0.34202,  8,32,  12,66,0,  -0.965926,0.0,0.0, -0.258819,  8,32,  30,108,-10,  -0.965926,0.0,0.0, 0.258819, 
     8,15,  24,108,-2,  0.130526,0.0,0.0, 0.991445, ]); 
   
        
        
        
          
    }//classend
}


import flash.geom.Matrix3D;


 internal  class xQuat
  {
   public var x:Number = 0, y:Number = 0, z:Number = 0,  w:Number = 1;

    public function reset():void {    x = 0;  y = 0;  z = 0;  w = 1;   }
    public function copyQuat(a:xQuat):void { x = a.x; y = a.y; z = a.z; w = a.w; }
    public function setValue(ax:Number, ay:Number, az:Number, aw:Number):void { x = ax; y = ay; z = az; w = aw; }
    public function invert():void     {    x = -x;  y = -y;  z = -z; } //aka negate, conjugate
      
    public function normalise():void
      {   var mag:Number;        mag = (x * x) + (y * y) + (z * z) + (w * w);
              if (mag == 1.0) return; //already normal
              if (mag == 0) { x = 0;  y = 0;  z = 0;  w = 1; return; }
          mag = 1.0 / Math.sqrt(mag);
          x *= mag;            y *= mag;            z *= mag;            w *= mag;
      }//norm
    
    public function mul(a:xQuat):void
      {   var tx:Number;            var ty:Number;            var tz:Number;            var tw:Number;
          tx =    (w * a.x + x * a.w + y * a.z - z * a.y);            ty =    (w * a.y + y * a.w + z * a.x - x * a.z);
          tz =    (w * a.z + z * a.w + x * a.y - y * a.x);            tw =    (w * a.w - x * a.x - y * a.y - z * a.z);
          x = tx;            y = ty;            z = tz;            w = tw;
      }//mul
   
   //0 x  1 y  2 z
      public function rotAxis(ang:Number, xyz:int=0):void
      {
          ang *= 0.5;
          var ax:Number; var ay:Number; var az:Number; var aw:Number;
          var tx:Number; var ty:Number; var tz:Number; var tw:Number;
          ax = xyz==0? Math.sin(ang):0;            ay  = xyz==1? Math.sin(ang):0;        az = xyz==2? Math.sin(ang):0;            aw = Math.cos(ang);
          tx =    (w * ax + x * aw + y * az - z * ay);            ty =    (w * ay + y * aw + z * ax - x * az);
          tz =    (w * az + z * aw + x * ay - y * ax);            tw =    (w * aw - x * ax - y * ay - z * az);
          x = tx;            y = ty;            z = tz;            w = tw;     
          normalise();        
      }//rotaxis
      
      //backwards compatibility with older xQuat
        public function rotPitch(ang:Number):void { rotAxis(ang, 0); }
        public function rotYaw(ang:Number):void { rotAxis(ang, 1); }
        public function rotRoll(ang:Number):void { rotAxis(ang, 2); }
        public function rotAxisX(ang:Number):void { rotAxis(ang, 0); }
        public function rotAxisY(ang:Number):void { rotAxis(ang, 1); }
        public function rotAxisZ(ang:Number):void { rotAxis(ang, 2); }
      
      
      public function nlerp(q1:xQuat, q2:xQuat, t:Number):void
      {
        var dot:Number;    var b:Number;    var rx:Number;     var ry:Number;     var rz:Number;     var rw:Number; 
        dot = q1.w*q2.w + q1.x*q2.x + q1.y*q2.y + q1.z * q2.z;
        b = 1.0 - t;  if (dot < 0) { t = -t;}
        w = b * q1.w + t * q2.w;      x = b * q1.x + t * q2.x;      y = b * q1.y + t * q2.y;      z = b * q1.z + t * q2.z;
      }//nlerp
      
      public function setVec(vec:Vector.<Number>):void
      {
          var xx:Number      = x * x;            var xy:Number      = x * y;            var xz:Number      = x * z;            var xw:Number      = x * w;
          var yy:Number      = y * y;            var yz:Number      = y * z;          var yw:Number      = y * w;
          var zz:Number      = z * z;            var zw:Number      = z * w;
          vec[3]  = vec[7] = vec[11] = vec[12] = vec[13] = vec[14] = 0.0;            vec[15] = 1.0;
          vec[0]  = 1.0 - 2.0 * ( yy + zz );            vec[4]  =     2.0 * ( xy - zw );            vec[8]  =     2.0 * ( xz + yw );
          vec[1]  =  2.0 * ( xy + zw ) ;                vec[5]  = 1.0 - 2.0 * ( xx + zz ) ;      vec[9]  =  2.0 * ( yz - xw ) ;
          vec[2]  =     2.0 * ( xz - yw );              vec[6]  =     2.0 * ( yz + xw );            vec[10] = 1.0 - 2.0 * ( xx + yy );        
      }//setvec

      public static var tempVec:Vector.<Number> = new Vector.<Number>(16, false);
      public function setMatrix(m:Matrix3D):void  { setVec(tempVec); m.rawData = tempVec;  }
      
    public function lookAtXYZ(ax:Number, ay:Number, az:Number,  bx:Number, by:Number, bz:Number):void  
    { var yaw:Number, pitch:Number;     var dx:Number, dz:Number;
      var am:Number;
      x = 0;  y = 0;  z = 0;  w = 1;
      dx = bx - ax;      dz = bz - az;
      yaw = Math.atan2(dz, dx);
      am = Math.cos(yaw) * dx + Math.sin(yaw) * dz;
      pitch = Math.atan2(by - ay, am);
      rotAxisY( -yaw - 1.57);      rotAxisX(pitch);     
    }//lookat  

        public function getSideVx():Number        { return 1.0 - 2.0 * ( y * y + z * z ); }        
        public function getSideVy():Number        { return 2.0 * ( x * y + z * w ); }    
        public function getSideVz():Number        { return  2.0 * ( x * z - y * w ); }
        public function getUpVx():Number        { return 2.0 * ( x*y - z*w ); }
        public function getUpVy():Number        { return 1.0 - 2.0 * ( x*x + z*z ); }    
        public function getUpVz():Number        { return 2.0 * ( y*z + x*w ); }
        public function getFrontVx():Number        {    return  2.0 * ( x*z + y*w ); }        
        public function getFrontVy():Number        {   return  2.0 * ( y*z - x*w );     }        
        public function getFrontVz():Number        {    return  1.0 - 2.0 * ( x*x + y*y );  }

    public function fromAxisAngle(ang:Number, ax:Number, ay:Number, az:Number):void
    {   var sina:Number; ang * 0.5; sina = Math.sin(ang);
        x = ax * sina; y = ay * sina; z = az * sina; w = Math.cos(ang);
        normalise();
    }//fromaxis
        
    public static var tempq:xQuat = new xQuat();
    public function ballRot(vx:Number, vz:Number, rad:Number):void
    {
      rad *= -1;
      var rot:Number;  var mag:Number;
      mag = Math.sqrt(vx * vx + vz * vz); if (mag <= 0) { return; }
      rot = mag / rad; //rad*deltatime
      vx /= mag; vz /= mag;  //also cross vel with up (0,1,0)          
      tempq.fromAxisAngle(rot, -vz, 0, vx);
      tempq.mul(this);  this.copyQuat(tempq);
    }//ballrot
        
  }//xquat
  
  
  