/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9SlV
 */

package  
{
	import flash.display.Sprite;
	import flash.events.Event;
	/**
	 * ...
	 * @author lizhi http://game-develop.net/
	 */
	public class TestGrid extends Sprite
	{
		private var gw:int = 10;
		private var X0:Number = 400 * Math.random();
		private var Y0:Number = 400 * Math.random();
		public function TestGrid() 
		{
			addEventListener(Event.ENTER_FRAME, enterFrame);
		}
		
		private function enterFrame(e:Event):void 
		{
			var x0:Number = X0;
			var y0:Number = Y0;
			
			//draw grid
			graphics.clear();
			graphics.lineStyle(0,0x999999);
			for (var i:int = 0, len:int = 400 / gw; i < len;i++ ) {
				graphics.moveTo(i * gw, 0);
				graphics.lineTo(i * gw, 400);
				graphics.moveTo(0,i*gw);
				graphics.lineTo( 400,i*gw);
			}
			var x1:Number = mouseX;
			var y1:Number = mouseY;
			
			//draw line
			graphics.lineStyle(0);
			graphics.moveTo(x0, y0);
			graphics.lineTo(x1, y1);
			
			var dx:Number = x1 - x0;
			var dy:Number = y1 - y0;
			var temp:Number;
			var flag:Boolean = true;
			if (Math.abs(dx) < Math.abs(dy)) {
				temp = dx;
				dx = dy;
				dy = temp;
				temp = x0;
				x0 = y0;
				y0 = temp;
				temp = x1;
				x1 = y1;
				y1 = temp;
				flag = false;
			}
			var ix0:int = x0 / gw;
			var iy0:int = y0 / gw;
			var ix1:int = x1 / gw;
			var iy1:int = y1 / gw;
			
			if (ix1 < ix0) {
				temp = ix0;
				ix0 = ix1;
				ix1 = temp;
			}
			var c:Number = (ix0 * gw - x0) / dx;
			var ny:Number = y0 / gw + dy * c / gw;
			var ndy:Number = dy / dx ;
			for (i = ix0; i <= ix1;i++ ) {
				graphics.beginFill(0xff0000, 0.3);
				if(flag){
					graphics.drawRect(i * gw, int(ny) * gw, gw, gw);
				}else {
					graphics.drawRect( int(ny) * gw, i * gw,gw, gw);
				}
				graphics.endFill();
				ny += ndy;
				graphics.beginFill(0xff0000, .3);
				if(flag){
					graphics.drawRect(i * gw, int(ny) * gw, gw, gw);
				}else {
					graphics.drawRect( int(ny) * gw, i * gw,gw, gw);
				}
				graphics.endFill();
			}
		}
		
	}

}