/**
 * Copyright just_a_dude ( http://wonderfl.net/user/just_a_dude )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8uhW
 */

package {
	
	import caurina.transitions.Tweener;

	import flash.display.DisplayObject;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
		
	[SWF (backgroundColor = 0, width = 465, height = 465, frameRate = 30)]
	
	public class TileGrid extends Sprite {
		
		private var _cols:int = 6;
		private var _rows:int = 6;
		private var _gap:int =  5;
		private var _size:int = 30;
		private var _tiles:Array = [];
		
		private var _container:Sprite;
		
		public function TileGrid() {	
			addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
		}
		
		protected function addedToStageHandler(event:Event):void  {
			removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
			
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;

		//	drawGuides();
			addContainer();
			addTiles();
		}
		
		private function drawGuides():void {
			
			graphics.clear();
			graphics.lineStyle(0);
			graphics.moveTo(stage.stageWidth * .5, 0);
			graphics.lineTo(stage.stageWidth * .5, stage.stageHeight);
			
			graphics.moveTo(0, stage.stageHeight * .5);
			graphics.lineTo(stage.stageWidth, stage.stageHeight * .5);
			
		}
		
		private function addContainer():void {
			_container = new Sprite();
			addChild(_container);
			_container.x = (stage.stageWidth - _container.width)   * .5;
			_container.y = (stage.stageHeight - _container.height) * .5;
		}
		
		private function addTiles():void {	
			
			_tiles = [];
			
			var i:int;
			var j:int;
			
			var tile:Tile;
			
			var totalWidth:Number = _cols * (_size + _gap);
			var totalHeight:Number = _rows * (_size + _gap);
			
			for (i = 0; i < _cols; i++) {
				for (j = 0; j < _rows; j++) {
					tile = new Tile(_size, _size, 0xffffff);

					tile.x = totalWidth * ((i + .5) / _cols) - (totalWidth / 2);
					tile.y = totalHeight * ((j + .5) / _rows) - (totalHeight / 2);
					tile.addEventListener(MouseEvent.CLICK, tileClickHandler);
					
					_container.addChild(tile);
					_tiles.push(tile);
				}
			}
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}

		protected function enterFrameHandler(e:Event):void {
			_container.rotationY += (_container.x - mouseX) * .04 - (_container.rotationY * .015);
			_container.rotationX += (_container.y - mouseY) * .04 - (_container.rotationX * .15);
		}
				
		protected function tileClickHandler(event:MouseEvent):void {
			
			removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
			
			var target:DisplayObject = event.currentTarget as DisplayObject;
			
			resetTiles();
			bringTileToFront(target);
			
		}
				
		private function resetContainerRotation():void{
			Tweener.addTween(_container, {
				rotationX: 0,
				rotationY: 0,
				time: 2.4,
				transition: "easeInOutBack",
				onComplete: function():void {
					addEventListener(Event.ENTER_FRAME, enterFrameHandler);
				}
			} );
		}
		
		private function resetTiles():void{
			var tile:DisplayObject;
			for (var i:int = 0; i < _tiles.length; i++) {
				tile = _tiles[i] as DisplayObject;
				if (tile.z < 0) 
					resetTile(tile);
			}
		}
		
		private function resetTile(target:DisplayObject):void {
			Tweener.addTween(target, {
				z: 0, 
				rotationX: 0, 
				rotationY: 0, 
				time: .8, 
				transition: "easeInBack"
			} );
		}
		
		private function bringTileToFront(target:DisplayObject):void {
			Tweener.addTween(target, { 
				z: -250,
				rotationX: 360, 
				rotationY: 360, 
				time: .8, 
				transition: "easeOutBack",
				onComplete: resetContainerRotation
			} );
		}
		
	}

}



import flash.display.Sprite;

class Tile extends Sprite {
	
	private var _width:Number;
	private var _height:Number;
	private var _color:uint;
	
	public function Tile(width:Number, height:Number, color:uint = 0) {
		_width = width;
		_height = height;
		_color = color;
		draw();
	}
	
	private function draw():void {
		
		var w:Number = _width  * .5;
		var h:Number = _height * .5;
		
		var vertices:Vector.<Number> = Vector.<Number>([
			-w, -h, 
			-w,  h,
			 w,  h,
			 w, -h,
			 w,  h,
			-w, -h,
		]);
		
		var indices:Vector.<int> = Vector.<int>([0, 1, 2, 3, 2, 0]);
		
		graphics.clear();

		graphics.beginFill(_color);
		graphics.drawTriangles(vertices, indices);
		graphics.endFill();
	}
	
}


