/**
 * Copyright kazy ( http://wonderfl.net/user/kazy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8Lau
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	/**
	 * Main
	 * メインクラス.
	 */
	public class Main extends Sprite
	{
		private var ball0:Ball;
		private var ball1:Ball;
		private var ball2:Ball;
		private var ball3:Ball;
		private var ball0Dragging:Boolean = false;
		private var ball1Dragging:Boolean = false;
		private var ball2Dragging:Boolean = false;
		private var ball3Dragging:Boolean = false;
		private var spring:Number = 0.05;
		private var friction:Number = 0.95;
		private var springLength:Number = 100;
		/**
		 * コンストラクタ.
		 */
		public function Main()
		{
			init();
		}
		/**
		 * 初期化.
		 */
		private function init():void
		{
			//ボール生成
			ball0 = new Ball(20);
			//初期位置決定
			ball0.x = Math.random() * stage.stageWidth;
			ball0.y = Math.random() * stage.stageHeight;
			//リスナー登録
			ball0.addEventListener(MouseEvent.MOUSE_DOWN, onPress);
			//表示
			addChild(ball0);
			//ボール生成
			ball1 = new Ball(20);
			//初期位置決定
			ball1.x = Math.random() * stage.stageWidth;
			ball1.y = Math.random() * stage.stageHeight;
			//リスナー登録
			ball1.addEventListener(MouseEvent.MOUSE_DOWN, onPress);
			//表示
			addChild(ball1);
			//ボール生成
			ball2 = new Ball(20);
			//初期位置決定
			ball2.x = Math.random() * stage.stageWidth;
			ball2.y = Math.random() * stage.stageHeight;
			//リスナー登録
			ball2.addEventListener(MouseEvent.MOUSE_DOWN, onPress);
			//表示
			addChild(ball2);
			//ボール生成
			ball3 = new Ball(20);
			//初期位置決定
			ball3.x = Math.random() * stage.stageWidth;
			ball3.y = Math.random() * stage.stageHeight;
			//リスナー登録
			ball3.addEventListener(MouseEvent.MOUSE_DOWN, onPress);
			//表示
			addChild(ball3);
			//Mainリスナー登録
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(MouseEvent.MOUSE_UP, onRelease);
		}
		/**
		 * onEnterFrame.
		 */
		private function onEnterFrame(event:Event):void
		{
			//ドロップされていないボールにバネの動き
			if(!ball0Dragging)
			{
				springTo(ball0, ball1);
				springTo(ball0, ball2);
				springTo(ball0, ball3);
			}
			if(!ball1Dragging)
			{
				springTo(ball1, ball0);
				springTo(ball1, ball2);
				springTo(ball1, ball3);
			}
			if(!ball2Dragging)
			{
				springTo(ball2, ball0);
				springTo(ball2, ball1);
				springTo(ball2, ball3);
			}
			if(!ball3Dragging)
			{
				springTo(ball3, ball0);
				springTo(ball3, ball1);
				springTo(ball3, ball2);
			}
			//線を引く
			graphics.clear();
			graphics.lineStyle(1);
			graphics.moveTo(ball0.x, ball0.y);
			graphics.lineTo(ball1.x, ball1.y);
			graphics.lineTo(ball2.x, ball2.y);
			graphics.lineTo(ball3.x, ball3.y);
			graphics.lineTo(ball0.x, ball0.y);
		}
		/**
		 * ばねの動き.
		 */
		private function springTo(ballA:Ball, ballB:Ball):void
		{
			//ボール間の座標上の距離
			var dx:Number = ballB.x - ballA.x;
			var dy:Number = ballB.y - ballA.y;
			//ボール間を結んだ線の角度
			var angle:Number = Math.atan2(dy, dx);
			//バネの長さを座標方向の長さに変換し、適応する
			var targetX:Number = ballB.x - Math.cos(angle) * springLength;
			var targetY:Number = ballB.y - Math.sin(angle) * springLength;
			//ボールにスプリングの加速を加える
			ballA.vx += (targetX - ballA.x) * spring;
			ballA.vy += (targetY - ballA.y) * spring;
			//減速
			ballA.vx *= friction;
			ballA.vy *= friction;
			//ボールの座標に適応
			ballA.x += ballA.vx;
			ballA.y += ballA.vy;
		}
		/**
		 * onPress.
		 */
		private function onPress(event:MouseEvent):void
		{
			event.target.startDrag();
			if(event.target == ball0)
			{
				ball0Dragging = true;
			}
			if(event.target == ball1)
			{
				ball1Dragging = true;
			}
			if(event.target == ball2)
			{
				ball2Dragging = true;
			}
			if(event.target == ball3)
			{
				ball3Dragging = true;
			}
		}
		/**
		 * onRelease.
		 */
		private function onRelease(event:MouseEvent):void
		{
			ball0.stopDrag();
			ball1.stopDrag();
			ball2.stopDrag();
			ball3.stopDrag();
			ball0Dragging = false;
			ball1Dragging = false;
			ball2Dragging = false;
			ball3Dragging = false;
		}
	}
}

/**
 * Ball
 * ボール生成クラス.
 */
class Ball extends flash.display.Sprite {
	public var radius:Number;
	private var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
	/**
	 * コンストラクタ.
	 */
	public function Ball(radius:Number=40, color:uint=0x990033) {
		this.radius = radius;
		this.color = color;
		init();
	}
	/**
	 * 初期化.
	 */
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}